package com.af.plugins.calculate;

import java.math.BigDecimal;
import java.text.NumberFormat;

import org.json.JSONArray;
import org.json.JSONObject;

/**
 * caption 混合单价计算。 费用 = 气量*混合单价1比例*混合单价1 + 气量*混合单价2比例*混合单价2
 *
 * @author Lyf
 *
 */
public class MixedpriceSettlement implements ISettlementInterface {

	@Override
	public JSONObject calcCharge(JSONArray chargeInfo, BigDecimal gas) {
		//价格1单价
		BigDecimal hybridprice1 = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get("f_hybridprice1")));
		//价格2单价
		BigDecimal hybridprice2 = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get("f_hybridprice2")));
		//价格1比例
		BigDecimal hybridprice1rate = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get("f_hybridprice1rate")));

		//费用 = 气量*混合单价1比例*混合单价1 + 气量*混合单价2比例*混合单价2
		BigDecimal chargenum = gas
				.multiply(hybridprice1rate)
				.multiply(hybridprice1)
				.add(new BigDecimal("1").subtract(hybridprice1rate).multiply(gas)
						.multiply(hybridprice2));

		JSONArray array = new JSONArray();
		//目前只支持两种
		JSONObject json = new JSONObject();
		json.put("f_price_name", "混合1");
		json.put("f_price", hybridprice1);
		json.put("f_gas", gas);
		json.put("f_money", chargenum);
		array.put(json);
		JSONObject json2 = new JSONObject();
		json2.put("f_price_name", "混合2");
		json2.put("f_price", hybridprice2);
		json2.put("f_gas", gas);
		json2.put("f_money", chargenum);
		array.put(json2);

		JSONObject ret = new JSONObject();
		ret.put("chargeprice", array);
		ret.put("chargenum", chargenum);
		//格式化数字类型
		PriceDateFormatTools.formatNumber(ret);
		return ret;
	}

	@Override
	public JSONObject calcAmount(JSONArray chargeInfo, BigDecimal fee) {
		//价格1单价
		BigDecimal hybridprice1 = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get(
				"f_hybridprice1")));
		//价格2单价
		BigDecimal hybridprice2 = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get(
				"f_hybridprice2")));
		//价格1比例
		BigDecimal hybridprice1rate = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0)
				.get("f_hybridprice1rate")));

		BigDecimal amount = fee.divide(
				hybridprice1rate.multiply(hybridprice1).add(
						new BigDecimal("1").subtract(hybridprice1rate).multiply(
								hybridprice2)), 0, BigDecimal.ROUND_DOWN);

		JSONArray array = new JSONArray();
		//目前只支持两种
		JSONObject json = new JSONObject();
		json.put("f_price_name", "混合1");
		json.put("f_price", hybridprice1);
		json.put("f_gas", amount);
		json.put("f_money", fee);
		array.put(json);
		JSONObject json2 = new JSONObject();
		json2.put("f_price_name", "混合2");
		json2.put("f_price", hybridprice2);
		json2.put("f_gas", amount);
		json2.put("f_money", fee);
		array.put(json2);

		JSONObject ret = new JSONObject();
		ret.put("chargeprice", array);
		ret.put("gas", amount);
		//格式化数字类型
		PriceDateFormatTools.formatNumber(ret);
		return ret;
	}
}
