package com.af.plugins.calculate;

import java.math.BigDecimal;

import org.json.JSONArray;
import org.json.JSONObject;

public interface ISettlementInterface {

	/**
	 * 气量划价接口
	 * 
	 * @param chargeInfo
	 *            用户价格方案明细
	 * @param gas
	 *            累计购气量
	 * @return 返回价格明细
	 */
	public JSONObject calcCharge(JSONArray chargeInfo, BigDecimal gas);

	/**
	 * 气费划价接口
	 * 
	 * @param chargeInfo 用户价格方案明细
	 * @param fee BigDecimal对象
	 *
	 * @return 返回价格明细
	 */
	public JSONObject calcAmount(JSONArray chargeInfo, BigDecimal fee);
}