package com.af.plugins;

import org.apache.http.client.methods.*;
import org.apache.http.client.methods.HttpPost;
import org.json.JSONObject;

import java.io.IOException;

import java.util.Iterator;


/**
 * REST风格请求插件
 */
public class RestTools {

	/**
	 * 发送通用Http请求
	 * @param path  请求路径
	 * @param value 请求参数
	 * @param headers 请求头
	 * @param base  请求类型
	 * @return  请求结果
	 */
	public static String request(String path, String value, String headers, HttpRequestBase base){
		try {
			JSONObject headerJson;
			if(headers == null || headers.equals("")){
				headerJson = new JSONObject();
			} else {
				headerJson = new JSONObject(headers);
			}
			if(!headerJson.has("Content-Type")){
				//指定请求参数的数据格式是JSON。
				headerJson.put("Content-Type", "application/json");
			}
			return HttpConnectionPoolUtil.request(path, value, headerJson.toString(), base);
		} catch (IOException e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * 发送post请求
	 *
	 * @param path    请求路径
	 * @param value   请求体
	 * @param headers  请求头
	 * @return String结果
	 */
	public static String post(String path, String value, String headers) {
		return request(path, value, headers, new HttpPost());
	}
	public static String post(String path, JSONObject value, JSONObject headers) {
		if(value == null){
			return post(path, null, headers.toString());
		} else {
			return post(path, value.toString(), headers.toString());
		}
	}
	public static String post(String path, JSONObject value) {
		return post(path, value.toString(), null);
	}
	public static String post(String path, String value) {
		return post(path, value, null);
	}
	public static String post(String path){
		return post(path, "",null);
	}

	/**
	 * 发送get请求
	 * @param path	请求路径
	 * @param headers 请求头
	 * @return String结果
	 */
	public static String get(String path, String headers) {
		return request(path, null, headers, new HttpGet());
	}
	public static String get(String path, JSONObject headers){
		return get(path, headers.toString());
	}
	public static String get(String path) {
		return get(path, "");
	}

	/**
	 * 发送put请求
	 *
	 * @param path	请求路径
	 * @param value	请求参数
	 * @param headers 请求头
	 * @return String结果
	 */
	public static String put(String path,String value,String headers){
		return request(path, value, headers, new HttpPut());
	}
	public static String put(String path,JSONObject value,JSONObject headers){
		if(value == null){
			return put(path, null, headers.toString());
		} else {
			return put(path, value.toString(), headers.toString());
		}
	}
	public static String put(String path, String value){
		return put(path,value,"");
	}
	public static String put(String path, JSONObject value){
		return put(path,value.toString(),"");
	}
	public static String put(String path){
		return put(path,"",null);
	}

	/**
	 * 发送delete请求
	 *
	 * @param path	请求路径
	 * @param value	请求参数
	 * @param headers 请求头
	 * @return String结果
	 */
	public static String delete(String path,String value,String headers){
		return request(path, value, headers, new HttpDeleteWithBody());
	}
	public static String delete(String path,JSONObject value,JSONObject headers){
		if(value == null){
			return delete(path, null, headers.toString());
		} else {
			return delete(path, value.toString(), headers.toString());
		}
	}
	public static String delete(String path,String value){
		return delete(path,value,"");
	}
	public static String delete(String path,JSONObject value){
		return delete(path,value.toString(),"");
	}
	public static String delete(String path) {
		return delete(path, "",null);
	}

	/**
	 * REST请求路径拼接参数
	 *
	 * @param url   请求路径
	 * @param params 请求参数
	 * @return String结果
	 */
	public static String formatURL(String url, JSONObject params) {
		//设置表单长度30字节*N个请求参数
		int capacity = params.length() * 30;
		//拼接请求路径
		StringBuilder buffer = new StringBuilder(capacity);
		buffer.append(url).append("?");
		//取出JSON里面的请求参数，添加到路径中。
		Iterator<String> keys = params.keys();
		while (keys.hasNext()){
			String key = keys.next();
			String val = String.valueOf(params.get(key));
			if(!"".equals(val)){
				buffer.append(key).append("=").append(val);
			} else {
				buffer.append(key);
			}
			if(keys.hasNext()){
				buffer.append("&");
			}
		}
		return buffer.toString();
	}

	/**
	 * 获取标准格式的请求路径
	 * @param protocolType 协议类型（http,https,ftp...）
	 * @param url 请求ip,域名
	 * @param port 端口，默认80
	 * @param paramStr 需要拼接的路径
	 * @return 标准格式的请求路径
	 */
	public static String getStandardURL(String protocolType,String url,String port,String paramStr){
		if (port == null){
			port = "80";
		}
		url = protocolType+"://"+url+":"+port;
		if(paramStr != null){
			url += paramStr;
		}
		return url;
	}
}
