/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins;

import com.af.plugins.HttpConnectionPoolUtil;
import com.af.plugins.HttpDeleteWithBody;
import java.io.IOException;
import java.util.Iterator;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.json.JSONObject;

public class RestTools {
    public static String request(String path, String value, String headers, HttpRequestBase base) {
        try {
            JSONObject headerJson = headers == null || headers.equals("") ? new JSONObject() : new JSONObject(headers);
            if (!headerJson.has("Content-Type")) {
                headerJson.put("Content-Type", (Object)"application/json");
            }
            return HttpConnectionPoolUtil.request(path, value, headerJson.toString(), base);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String post(String path, String value, String headers) {
        return RestTools.request(path, value, headers, (HttpRequestBase)new HttpPost());
    }

    public static String post(String path, JSONObject value, JSONObject headers) {
        return RestTools.post(path, value.toString(), headers.toString());
    }

    public static String post(String path, JSONObject value) {
        return RestTools.post(path, value.toString(), null);
    }

    public static String post(String path, String value) {
        return RestTools.post(path, value, null);
    }

    public static String post(String path) {
        return RestTools.post(path, "", null);
    }

    public static String get(String path, String headers) {
        return RestTools.request(path, null, headers, (HttpRequestBase)new HttpGet());
    }

    public static String get(String path, JSONObject headers) {
        return RestTools.get(path, headers.toString());
    }

    public static String get(String path) {
        return RestTools.get(path, "");
    }

    public static String put(String path, String value, String headers) {
        return RestTools.request(path, value, headers, (HttpRequestBase)new HttpPut());
    }

    public static String put(String path, JSONObject value, JSONObject headers) {
        return RestTools.put(path, value.toString(), headers.toString());
    }

    public static String put(String path, String value) {
        return RestTools.put(path, value, "");
    }

    public static String put(String path, JSONObject value) {
        return RestTools.put(path, value.toString(), "");
    }

    public static String put(String path) {
        return RestTools.put(path, "", null);
    }

    public static String delete(String path, String value, String headers) {
        return RestTools.request(path, value, headers, (HttpRequestBase)new HttpDeleteWithBody());
    }

    public static String delete(String path, JSONObject value, JSONObject headers) {
        return RestTools.delete(path, value.toString(), headers.toString());
    }

    public static String delete(String path, String value) {
        return RestTools.delete(path, value, "");
    }

    public static String delete(String path, JSONObject value) {
        return RestTools.delete(path, value.toString(), "");
    }

    public static String delete(String path) {
        return RestTools.delete(path, "", null);
    }

    public static String formatURL(String url, JSONObject params) {
        int capacity = params.length() * 30;
        StringBuilder buffer = new StringBuilder(capacity);
        buffer.append(url).append("?");
        Iterator keys = params.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String val = String.valueOf(params.get(key));
            if (!"".equals(val)) {
                buffer.append(key).append("=").append(val);
            } else {
                buffer.append(key);
            }
            if (!keys.hasNext()) continue;
            buffer.append("&");
        }
        return buffer.toString();
    }

    public static String getStandardURL(String protocolType, String url, String port, String paramStr) {
        if (port == null) {
            port = "80";
        }
        url = protocolType + "://" + url + ":" + port;
        if (paramStr != null) {
            url = url + paramStr;
        }
        return url;
    }
}

