package com.af.plugins.calculate;

import java.math.BigDecimal;

import org.json.JSONArray;
import org.json.JSONObject;

public class StairpriceSettlement implements ISettlementInterface {
	@Override
    public JSONObject calcCharge(JSONArray chargeInfo, BigDecimal gas) {
		int length = chargeInfo.length();

		BigDecimal sumamont = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(length - 1)
				.get("sumamount")));

		BigDecimal allamount = sumamont.add(gas);

		BigDecimal[] stairPrice = new BigDecimal[length - 1];
		BigDecimal[] stairAmount = new BigDecimal[length - 2];
		BigDecimal[] stairFee = new BigDecimal[length - 1];
		BigDecimal[] stairNum = new BigDecimal[length - 1];
		BigDecimal[] stairSurplus = new BigDecimal[length - 2];

		for (int i = 0; i < length - 1; i++) {
			stairPrice[i] = new BigDecimal("0");
			stairFee[i] = new BigDecimal("0");
			stairNum[i] = new BigDecimal("0");
		}

		for (int i = 0; i < length - 2; i++) {
			stairAmount[i] = new BigDecimal("0");
			stairSurplus[i] = new BigDecimal("0");
		}

		int start = 0;
		int end = 0;
		int i = 0;
		for (; i < length - 2; i++) {
			stairPrice[i] = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(i).get("price")));
			stairAmount[i] = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(i).get("amount")));

			if (allamount.compareTo(sumamont) > 0) {
				if (sumamont.compareTo(stairAmount[i]) >= 0) {
					start = i + 1;
				}

				if (allamount.compareTo(stairAmount[i]) > 0) {
					end = i + 1;
				}
			} else {
				if (allamount.compareTo(stairAmount[i]) >= 0) {
					start = i + 1;
				}

				if (sumamont.compareTo(stairAmount[i]) >= 0) {
					end = i + 1;
				}
			}

		}

		stairPrice[i] = new BigDecimal(String.valueOf(
				chargeInfo.getJSONObject(i).get("price")));

		if (gas.compareTo(BigDecimal.ZERO) > 0) {
			if (start == end) {
				stairNum[start] = gas;
				stairFee[start] = gas.multiply(stairPrice[start]).setScale(4,4);
			} else {
				stairNum[start] = stairAmount[start].subtract(sumamont);
				stairFee[start] = stairNum[start].multiply(stairPrice[start])
						.setScale(4, 4);

				for (i = start + 1; i < end; i++) {
					stairNum[i] = stairAmount[i].subtract(stairAmount[(i - 1)]);
					stairFee[i] = stairNum[i].multiply(stairPrice[i]).setScale(
							4, 4);
				}
				stairNum[end] = allamount.subtract(stairAmount[(end - 1)]);
				stairFee[end] = stairNum[end].multiply(stairPrice[end])
						.setScale(4, 4);
			}
		} else {
			if (start == end) {
				stairNum[start] = gas;
				stairFee[start] = gas.multiply(stairPrice[start]);
			} else {
				stairNum[start] = allamount.subtract(stairAmount[start]);
				stairFee[start] = stairNum[start].multiply(stairPrice[start])
						.setScale(4, 4);

				for (i = start + 1; i < end; i++) {
					stairNum[i] = stairAmount[i - 1].subtract(stairAmount[i]);
					stairFee[i] = stairNum[i].multiply(stairPrice[i]).setScale(
							4, 4);
				}

				stairNum[end] = stairAmount[(end - 1)].subtract(sumamont);
				stairFee[end] = stairNum[end].multiply(stairPrice[end])
						.setScale(4, 4);
			}
		}

		JSONObject ret = new JSONObject();
		BigDecimal chargenum = new BigDecimal("0");
		BigDecimal oughtamount = new BigDecimal("0");

		JSONArray array = new JSONArray();
		for (i = 0; i < length - 1; i++) {
			chargenum = chargenum.add(stairFee[i]);
			oughtamount = oughtamount.add(stairNum[i]);
			ret.put("f_stair" + (i + 1) + "fee", stairFee[i]);
			ret.put("f_stair" + (i + 1) + "amount", stairNum[i]);
			ret.put("f_stair" + (i + 1) + "price", stairPrice[i]);

			JSONObject json = new JSONObject();
			json.put("f_price_name", "阶梯" + (i + 1));
			json.put("f_price", stairPrice[i]);
			json.put("f_gas", stairNum[i]);
			json.put("f_money", stairFee[i]);
			array.put(json);
		}

		for (i = 0; i < stairAmount.length; i++) {
			ret.put("f_stair" + (i + 1) + "ceiling", stairAmount[i]);
		}

		for (i = 0; i < length - 2; i++) {
			if (allamount.compareTo(stairAmount[i]) < 0) {
				for (int j = 0; j < i; j++) {
					stairSurplus[j] = BigDecimal.ZERO;
					ret.put("f_stair" + (j + 1) + "surplus", stairSurplus[j]);
				}

				stairSurplus[i] = stairAmount[i].subtract(allamount);
				ret.put("f_stair" + (i + 1) + "surplus", stairSurplus[i]);
				for (int j = i + 1; j < length - 2; j++) {
					stairSurplus[j] = stairAmount[j]
							.subtract(stairAmount[(j - 1)]);

					ret.put("f_stair" + (j + 1) + "surplus", stairSurplus[j]);
				}

				break;
			}
		}
		ret.put("chargenum", chargenum);
		ret.put("oughtamount", oughtamount);
		ret.put("sumamount", sumamont);
		ret.put("chargeprice", array);
		//格式化数字类型
		PriceDateFormatTools.formatNumber(ret);
		return ret;
	}

	@Override
    public JSONObject calcAmount(JSONArray chargeInfo, BigDecimal fee) {
		int length = chargeInfo.length();

		BigDecimal sumamont = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(length - 1)
				.get("sumamount")));
		BigDecimal sumamont1 = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(length - 1)
				.get("sumamount")));

		BigDecimal[] stairPrice = new BigDecimal[length - 1];
		BigDecimal[] stairAmount = new BigDecimal[length - 2];
		BigDecimal[] stairFee = new BigDecimal[length - 1];
		BigDecimal[] stairNum = new BigDecimal[length - 1];
		BigDecimal[] stairSurplus = new BigDecimal[length - 2];

		JSONObject ret = new JSONObject();
		BigDecimal chargenum = new BigDecimal("0");
		BigDecimal oughtamount = new BigDecimal("0");

		for (int i = 0; i < length - 1; i++) {
			stairPrice[i] = new BigDecimal("0");
			stairFee[i] = new BigDecimal("0");
			stairNum[i] = new BigDecimal("0");
		}

		for (int i = 0; i < length - 2; i++) {
			stairAmount[i] = new BigDecimal("0");
			stairSurplus[i] = new BigDecimal("0");
		}

		int start = 0;
		int i = 0;
		for (; i < length - 2; i++) {
			stairPrice[i] = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(i).get("price")));
			stairAmount[i] = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(i).get("amount")));

			if (sumamont.compareTo(stairAmount[i]) >= 0) {
				start = i + 1;
			}
		}

		stairPrice[i] = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(i).get("price")));

		for (i = start; i < stairAmount.length; i++) {
			if (stairAmount[i].subtract(sumamont).multiply(stairPrice[i])
					.compareTo(fee) >= 0) {
				stairNum[i] = fee.divide(stairPrice[i], 2, 4);

				stairFee[i] = stairNum[i].multiply(stairPrice[i])
						.setScale(4, 4);

				for (int j = 0; j < i; j++) {
					stairSurplus[j] = BigDecimal.ZERO;
					ret.put("f_stair" + (j + 1) + "surplus", stairSurplus[j]);
				}

				stairSurplus[i] = stairAmount[i].subtract(stairNum[i])
						.subtract(sumamont);

				ret.put("f_stair" + (i + 1) + "surplus", stairSurplus[i]);

				for (int j = i + 1; j < stairAmount.length; j++) {
					stairSurplus[j] = stairAmount[j]
							.subtract(stairAmount[(j - 1)]);

					ret.put("f_stair" + (j + 1) + "surplus", stairSurplus[j]);
				}

				break;
			}
			stairNum[i] = stairAmount[i].subtract(sumamont);
			stairFee[i] = stairNum[i].multiply(stairPrice[i]).setScale(4, 4);

			fee = fee.subtract(stairFee[i]);
			sumamont = stairAmount[i];
		}

		stairNum[i] = fee.divide(stairPrice[i], 2, 4);
		stairFee[i] = fee;

		JSONArray array = new JSONArray();
		for (i = 0; i < length - 1; i++) {
			chargenum = chargenum.add(stairFee[i]);
			oughtamount = oughtamount.add(stairNum[i]);
			ret.put("f_stair" + (i + 1) + "fee", stairFee[i]);
			ret.put("f_stair" + (i + 1) + "amount", stairNum[i]);
			ret.put("f_stair" + (i + 1) + "price", stairPrice[i]);

			JSONObject json = new JSONObject();
			json.put("f_price_name", "阶梯" + (i + 1));
			json.put("f_price", stairPrice[i]);
			json.put("f_gas", stairNum[i]);
			json.put("f_money", stairFee[i]);
			array.put(json);
		}

		for (i = 0; i < stairAmount.length; i++) {
			ret.put("f_stair" + (i + 1) + "ceiling", stairAmount[i]);
		}
		int j;
		try {
			ret.get("f_stair1surplus");
		} catch (Exception ignored) {
		}
		for (j = 0; j < stairSurplus.length; j++) {
			//stairSurplus[j] = BigDecimal.ZERO;
			ret.put("f_stair" + (j + 1) + "surplus", stairSurplus[j]);
			//system.out.println("阶梯" + (j + 1) + "剩余购气量 :" + stairSurplus[j]);
		}

		ret.put("chargenum", chargenum);
		ret.put("sumamount", sumamont1);
		ret.put("gas", oughtamount);
		ret.put("chargeprice", array);
		//格式化数字类型
		PriceDateFormatTools.formatNumber(ret);
		return ret;
	}
}
