package com.aote.plugins;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.client.j2se.MatrixToImageWriter;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

/**
 * @Classname QRCodeGenerator
 * @Description TODO
 * @Date 2024/5/10 下午5:14
 * @Created by 张振宇
 */
public class QRCodeGenerator {

    public static void main(String[] args) {
        try {
            String url = "https://dlj.51fapiao.cn/dlj/v8/9a4ed1b60d8f61c62420c4bf4041870051c2ae";
            String base64 = url2QRCodeImage(url);
            System.out.println(base64);
        } catch (WriterException | IOException e) {
            e.printStackTrace();
        }
    }

    public static String url2QRCodeImage(String url) throws WriterException, IOException {
       return generateQRCodeImage(url,100,100);
    }

    public static String generateQRCodeImage(String text, int width, int height) throws WriterException, IOException {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        Map<EncodeHintType, ErrorCorrectionLevel> hints = new HashMap<>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
        BitMatrix bitMatrix = qrCodeWriter.encode(text, BarcodeFormat.QR_CODE, width, height, hints);

        BufferedImage image = MatrixToImageWriter.toBufferedImage(bitMatrix);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageIO.write(image, "PNG", outputStream);
        byte[] bytes = outputStream.toByteArray();

        String base64 = Base64.getEncoder().encodeToString(bytes);
        return "data:image/png;base64," + base64;
    }
}
