package com.aote.plugins;

import org.apache.log4j.Logger;

import javax.swing.*;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TimerTask;
import java.util.Timer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChooseLoadUtil {
    public static final Logger log = Logger.getLogger(ChooseLoadUtil.class);

    /**
     * 分公司选择框
     *
     * @param path jar包路径
     * @return 选择的公司
     * @throws Exception
     */
    public String choose(String path) throws Exception {
        //要返回的值
        String choose = "";
        try {
            //根据路径获取目标文件
            File File = new File(path);
            //获取文件的绝对路径
            String jarFilepath = File.getAbsolutePath();
            log.debug("获取到jar路径: " + jarFilepath);
            JarFile jarFile = new JarFile(jarFilepath);
            Enumeration<JarEntry> entries = jarFile.entries();
            ArrayList<String> list = new ArrayList<>();
            while (entries.hasMoreElements()) {
                JarEntry element = entries.nextElement();
                String name = element.getName();
                String regex = "^filiale/(.+)/logic.xml$";
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(name);
                if (matcher.find()) {
                    String group = matcher.group(1);
                    list.add(group);
                }
            }
            log.debug("获取到所有分公司: " + list.toString());
            if (list.size() > 0) {
                String group = null;
                String regex = "^(.+)WEB-INF\\\\|/lib\\\\|/.+.jar$";
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(jarFilepath);
                if (matcher.find()) {
                    group = matcher.group(1) + "filiale.txt";
                }
                log.debug("文件路径:" + group);
                choose = this.getDefaultFiliale(group);
                log.debug("获取到默认选择的分公司:" + choose);
                // 没有默认公司, 去选择公司
                if ("".equals(choose) || null == choose) {
                    String[] options = list.toArray(new String[list.size()]);
                    choose = (String) JOptionPane.showInputDialog(null, "请选择分公司：", "提示", JOptionPane.QUESTION_MESSAGE, null, options, "");
                    if (choose == null) choose = "";
                    this.dataPersistence(group, choose);
                }
                log.debug("最终选择的值:" + choose);
                // 给个提示
                this.dialog(choose);
            } else {
                log.debug("无分公司文件夹, 不进行任何操作");
            }
        } catch (Exception e) {
            log.debug("选择分公司执行异常: ", e);
            throw e;
        }
        return choose;
    }

    /**
     * 通过文件获取默认的选择的分公司
     *
     * @param path 文件路径 文件不存在或者路径为null,返回空字符串
     * @return
     */
    public String getDefaultFiliale(String path) {
        if (null == path || !new File(path).exists()) {
            return "";
        }
        StringBuilder filiale = new StringBuilder();
        try (FileReader fileReader = new FileReader(path)) {
            int len;
            while ((len = fileReader.read()) != -1) {
                filiale.append((char) len);
            }
        } catch (Exception e) {
            log.debug("读取文件异常:", e);
        }
        return filiale.toString();
    }

    /**
     * 将选择的分公司存入文件,方便下次默认选中
     *
     * @param path    文件路径
     * @param filiale 选择的分公司
     */
    public void dataPersistence(String path, String filiale) throws IOException {
        log.debug("准备存储文件路径为: " + path);
        File file = new File(path);
        if (!file.exists()) {
            // 创建文件
            boolean newFile = file.createNewFile();
            log.debug("创建文件结果:" + newFile);
        }
        try (FileWriter fileWriter = new FileWriter(file)) {
            fileWriter.write(filiale);
            fileWriter.flush();
        } catch (Exception e) {
            log.debug("写入文件异常:", e);
        }
        log.debug("文件写入完毕");
    }

    /**
     * 对话框提示
     *
     * @param filiale 选择的分公司
     */
    public void dialog(String filiale) {
        JOptionPane op = new JOptionPane("当前使用的分公司是: " + filiale, JOptionPane.INFORMATION_MESSAGE);
        final JDialog dialog = op.createDialog("本对话框将在20秒后自动关闭");

        // 创建一个新计时器
        Timer timer = new Timer();

        // 30秒 后执行该任务
        timer.schedule(new TimerTask() {
            public void run() {
                dialog.setVisible(false);
                dialog.dispose();
                timer.cancel();
            }
        }, 20000);

        dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
        dialog.setAlwaysOnTop(true);
        dialog.setModal(false);
        dialog.setVisible(true);
    }
}
