package com.af.plugins.timeoutReturn;

import com.aote.util.ResourceHelper;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisPool;

/**
 * 针对前台超时，需要获取返回信息工具
 */
@Component
public class TimeCache {

    @Autowired
    private RedisCacheTools redisCacheTools;

    public TimeCache() {

    }

    /**
     * redis缓存值
     * @param key
     * @param value
     * @param timeout
     * @throws Exception
     */
    public void setCahce(String key,JSONObject value,int timeout) throws Exception {
        if(key == null || "".equals(key) || value == null){
            throw new Exception("key或value传参为null无法进行缓存");
        }
        if(timeout<=0){
            redisCacheTools.setValue(key,value.toString(),timeout);
        }else{
            redisCacheTools.setValue(key,value.toString(),timeout);
        }
    }

    /**
     * redis缓存值
     * @param key
     * @param value
     * @throws Exception
     */
    public void setCahce(String key,JSONObject value) throws Exception {
        if(key == null || "".equals(key) || value == null){
            throw new Exception("key或value传参为null无法进行缓存");
        }
        redisCacheTools.setValue(key,value.toString());
    }

    /**
     * redis获取值
     * @param key
     * @return
     * @throws Exception
     */
    public JSONObject getCache(String key) throws Exception {
        if(key == null || "".equals(key) ){
            throw new Exception("key或value传参为null无法进行缓存");
        }
        String value = redisCacheTools.getValue(key);
        return new JSONObject(value);
    }

    /**
     * redis删除数据
     * @param key
     * @return  1 成功 0 失败
     * @throws Exception
     */
    public String delCache(String key) throws Exception {
        if(key == null || "".equals(key) ){
            throw new Exception("key或value传参为null无法进行缓存");
        }
        return redisCacheTools.removeKey(key);
    }
}
