package com.af.plugins.string;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.regex.Matcher;
import java.util.regex.Pattern;



/**
 * 字符串分割插件
 * @author aofeng
 */
public class SubStringPlugin {

	private static final Pattern PATTERN1 = Pattern.compile("-?[0-9]+?[0-9]+");
	private static final Pattern PATTERN2 = Pattern.compile("-?[0-9]+.?[0-9]+");

	public static String sub(String s, int beginIndex, int endIndex) {
		return s.substring(beginIndex, endIndex);
	}


	public static JSONObject Split(String s, String spl) {
		JSONObject rest=new JSONObject();
		String[] sarr=s.split("|".equals(spl) ?"\\|":spl);
		for (int i=0;i<sarr.length;i++) {
			rest.put("s"+i, sarr[i]);
		}
		return rest;
	}


	public static String repl(String s, String oldChar, String newChar) {
		return s.replace(oldChar, newChar);
	}


	public static double toDouble(String s) {
		return Double.parseDouble(s.replaceFirst("^0*", ""));
	}


	public static int toInt(String s) {
		return Integer.parseInt(s.replaceFirst("^0*", ""));
	}


	public static boolean isInt(String str) {
		Matcher isNum = PATTERN1.matcher(str);
		return isNum.matches();
	}


	public static boolean isDouble(String str) {
		Matcher isNum = PATTERN2.matcher(str);
		return isNum.matches();
	}

	public static boolean StringReg(String str, String regex) {
		Pattern p = Pattern.compile(regex);
		Matcher matcher = p.matcher(str);
		return matcher.matches();
	}


	public static int getYear(String date) {
		String year = date.substring(0, 4);
		return Integer.parseInt(year);
	}


	public static int getMonth(String date) {
		String month = date.substring(5, 7);
		return Integer.parseInt(month);
	}
	
	
	public static String strid(String s){
		StringBuilder str = new StringBuilder();
		JSONArray obj = new JSONArray(s);
		System.out.println(obj);
		for (int i=0;i<obj.length();i++) {
			JSONObject js = (JSONObject) obj.get(i);
			str.append(js.getString("id")).append(",");
		}
		return str.toString();
	}
}
