package com.af.plugins.kafka.kafka_consumer;

import com.af.plugins.xq.AsyncTools;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;

import java.time.Duration;
import java.util.Collections;
import java.util.Properties;

public class ConsumerRunnable implements Runnable{
    // 本例中使用一个consumer将消息放入后端队列
    private final KafkaConsumer<String, String> consumer;
    //服务地址
    private static String url;
    //异步请求对象
    private static AsyncTools asyncTools;

    //读取consumer配置文件，初始化consumer(小组id，话题名称，初始化用的配置参数)
    ConsumerRunnable(String groupId, String topic, Properties prop,String url) {
        //配置服务地址
        ConsumerRunnable.url = url;
        //给本小组设置id
        prop.put("group.id",groupId);
        //构建消费者对象
        this.consumer = new KafkaConsumer<>(prop);
        //构建异步请求对象
        asyncTools = new AsyncTools() {
            @Override
            public void callBack(Boolean result, String httpCode, String response, String body) {}
        };
        //订阅的话题
        consumer.subscribe(Collections.singletonList(topic));
    }

    @Override
    public void run() {
        //无限循环实时拿数据
        while (true) {
            //拿到的消息结果集
            ConsumerRecords<String, String> records = consumer.poll(Duration.ZERO);
            //遍历这个结果集,并处理每一条消息
            for (final ConsumerRecord<String, String> record : records) {
                //发送异步请求
                asyncTools.postAsync(url+record.topic(),record.value(),false);
                System.out.println(" url: " + url + record.topic() + " val: "+record.value());
            }
            try {
                Thread.sleep(100);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}