package com.af.plugins.kafka.kafka_consumer;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

/**
 * kafka消费者主入口
 */
public class ConsumerMain {
    //消费者主入口
    public static void main(String[] args) throws Exception {
        //创建kafka配置文件对象
        Properties prop = new Properties();
        prop.load(ConsumerMain.class.getResourceAsStream("/kafka_consumer.properties"));
        //获取自定义配置项
        JSONObject params = readJsonFile();
        //获取topic集合
        JSONArray topicArray = params.getJSONArray("topics");
        //获取服务地址
        String url = params.getString("serviceUrl");
        //获取每个消费者组的最大线程数
        int workerNum = params.getInt("workerNum");
        //如果有topic
        if (topicArray.length() > 0) {
            //遍历topic集合，针对每个topic进行参数设置
            for(int i = 0 ; i < topicArray.length() ; i++){
                JSONObject topic = topicArray.getJSONObject(i);
                //获取话题对应的logic名称
                String topicName = topic.getString("logicName");
                String groupId = topicName+"-1";
                //创建消费者组，将小组id，topic名称，配置文件参数，服务地址传入
                ConsumerGroup consumerGroup = new ConsumerGroup(workerNum,groupId,prop,topicName,url);
                consumerGroup.execute();
                System.out.println("topic["+topicName+"]创建完成！");
            }
        }
    }

    /**
     * 读取topicConfig文件
     * @return JSONObject
     */
    private static JSONObject readJsonFile() {
        BufferedReader reader = null;
        StringBuilder laststr = new StringBuilder();
        try {
            InputStream input = ConsumerMain.class
                    .getResourceAsStream("/topicConfig.json");
            InputStreamReader inputStreamReader = new InputStreamReader(input,
                    StandardCharsets.UTF_8);
            reader = new BufferedReader(inputStreamReader);
            String tempString;
            while ((tempString = reader.readLine()) != null) {
                laststr.append(tempString);
            }
            reader.close();
            return new JSONObject(laststr.toString());
        } catch (IOException e) {
            throw new RuntimeException(e);
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}