package com.af.plugins;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Transparency;
import java.awt.image.BufferedImage;
import java.io.*;
import java.util.Iterator;

import javax.imageio.ImageIO;

import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

/**
 * 添加水印
 *
 */
public class WaterMarkUtil {
    static Logger log = Logger.getLogger(WaterMarkUtil.class);
    public static void insertWaterMarkTextToXlsx(String templatePath, String waterMarkText)   {
        try {
            XSSFWorkbook workbook = new XSSFWorkbook(new FileInputStream(templatePath));
            FileOutputStream out = new FileOutputStream(templatePath);
            // 创建水印
            BufferedImage watermarkImage = createWatermarkImage(waterMarkText);
            ByteArrayOutputStream imageOs = new ByteArrayOutputStream();
            ImageIO.write(watermarkImage, "png", imageOs);
            // 引入水印
            int pictureIdx = workbook.addPicture(imageOs.toByteArray(), Workbook.PICTURE_TYPE_PNG);
            int sumSheet = workbook.getNumberOfSheets();
             for (int i = 0; i < sumSheet; i++) {
                 log.debug("为sheet" + i + "添加水印");
                 XSSFSheet sheet = workbook.getSheetAt(i);
                String rID = sheet.addRelation(null, XSSFRelation.IMAGES, workbook.getAllPictures().get(pictureIdx)).getRelationship().getId();
                 // 添加水印
                sheet.getCTWorksheet().addNewPicture().setId(rID);
            }
            workbook.write(out);

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public static void insertWaterMarkTextToTemp(SXSSFWorkbook theBook, String waterMarkText)   {
        try {
            // 创建水印
            BufferedImage watermarkImage = createWatermarkImage(waterMarkText);
            ByteArrayOutputStream imageOs = new ByteArrayOutputStream();
            ImageIO.write(watermarkImage, "png", imageOs);
            // 引入水印
            int pictureIdx = theBook.getXSSFWorkbook().addPicture(imageOs.toByteArray(), Workbook.PICTURE_TYPE_PNG);
            int numberOfSheets = theBook.getXSSFWorkbook().getNumberOfSheets();
            XSSFSheet sheet = theBook.getXSSFWorkbook().getSheetAt(numberOfSheets-1);
            String rID = sheet.addRelation(null, XSSFRelation.IMAGES, theBook.getXSSFWorkbook().getAllPictures().get(pictureIdx)).getRelationship().getId();
            // 添加水印
            sheet.getCTWorksheet().addNewPicture().setId(rID);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public static void main(String[] args) {
        String templatePath = "C:\\Users\\76025\\Desktop\\缴费记录 (3).xlsx";
        String waterMarkText = "铜川天然气有限公司";
        insertWaterMarkTextToXlsx(templatePath,waterMarkText);
    }



    public static BufferedImage createWatermarkImage(String waterMark){
        String[] textArray = waterMark.split("\n");
        Font font = new Font("仿宋_GB2312", Font.PLAIN, 32);
        Integer width = 500;
        Integer height = 400;

        BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
        // 背景透明 开始
        Graphics2D g = image.createGraphics();
        image = g.getDeviceConfiguration().createCompatibleImage(width, height, Transparency.TRANSLUCENT);
        g.dispose();
        // 背景透明 结束
        g = image.createGraphics();
        g.setColor(new Color(Color.lightGray.getRGB()));// 设定画笔颜色
        g.setFont(font);// 设置画笔字体
        //   g.shear(0.1, -0.26);// 设定倾斜度

//        设置字体平滑
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

        //文字从中心开始输入，算出文字宽度，左移动一半的宽度，即居中
        FontMetrics fontMetrics = g.getFontMetrics(font);

        // 水印位置
        int x = width / 2;
        int y = height / 2;
        // 设置水印旋转
        g.rotate(Math.toRadians(-40), x,y);
        for (int i = 0; i < textArray.length; i++) {
            // 文字宽度
            int textWidth = fontMetrics.stringWidth(textArray[i]);
            g.drawString(textArray[i], x-(textWidth/2), y);// 画出字符串
            y = y + font.getSize();
        }

        g.dispose();// 释放画笔
        return image;
    }
}