/*
 * Decompiled with CFR 0.152.
 */
package com.aote.plugins.impexp.exportfile;

import com.aote.ThreadResource;
import com.aote.module.ModuleMapper;
import com.aote.plugins.impexp.exportfile.IExportFile;
import com.aote.sql.SqlServer;
import com.aote.util.ExcelUtil;
import com.aote.util.ResourceHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.sql.DataSource;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExportFile
implements IExportFile {
    private JSONObject map = null;
    private static final int MAX_ROWS_PER_SHEET = 10001;
    private static final String defaultCondition = "{orderitem: 'id',condition: '1=1'}";
    @Autowired
    private DataSource dataSource;

    @Override
    public JSONArray export(String condition, String configName) throws Exception {
        this.map = this.getConfig(configName);
        if (this.map == null) {
            return this.noTemplate(condition);
        }
        Set templateNames = this.map.keySet();
        if (templateNames.size() == 0) {
            throw new Exception("\u6b64\u5bfc\u51fa\u9700\u8981\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5impexp/exp/\u8def\u5f84\u4e0b\u7684\u76f8\u5173\u914d\u7f6e\uff01\uff01");
        }
        return this.hasTemplate(templateNames, condition);
    }

    private JSONObject getConfig(String configName) {
        if (configName == null || "".equals(configName)) {
            return null;
        }
        String dir = (String)ThreadResource.ComponentDir.get();
        if (dir != null) {
            return null;
        }
        Map map = ModuleMapper.getMap();
        for (String key : map.keySet()) {
            try {
                String configStr = ResourceHelper.getString((String)(key + "/impexp/exp/" + configName));
                JSONObject result = new JSONObject(configStr);
                return result;
            }
            catch (Exception e) {
            }
        }
        throw new RuntimeException("\u5bfc\u51fa\u7684\u914d\u7f6e\u6587\u4ef6\u672a\u627e\u5230\uff01" + configName);
    }

    private JSONArray noTemplate(String condition) throws Exception {
        JSONArray result = new JSONArray();
        JSONObject json = new JSONObject();
        long tick = System.currentTimeMillis();
        String filepath = this.getFilePath(new JSONObject(condition).getString("templateName") + ".xlsx");
        json.put("filename", (Object)filepath);
        result.put((Object)json);
        this.export(new JSONObject(condition).getString("sqlName"), condition, null, filepath);
        tick = System.currentTimeMillis() - tick;
        System.out.println("\u8fdb\u884cExcel\u5bfc\u51fa\u8017\u65f6\uff1a" + (double)tick / 1000.0 + "\u79d2");
        System.out.println("\u6587\u4ef6\u540d\uff1a" + result);
        return result;
    }

    private JSONArray hasTemplate(Set<String> templateNames, String condition) throws Exception {
        JSONArray result = new JSONArray();
        boolean i = false;
        for (String template : templateNames) {
            String sqlName = this.map.getString(template);
            String filepath = this.getFilePath(template);
            JSONObject json = new JSONObject();
            json.put("filename", (Object)filepath);
            result.put((Object)json);
            template = "excel/" + template;
            long tick = System.currentTimeMillis();
            if (!i) {
                this.export(sqlName, condition, template, filepath);
            } else {
                this.export(sqlName, defaultCondition, template, filepath);
            }
            tick = System.currentTimeMillis() - tick;
            System.out.println("\u8fdb\u884cExcel\u5bfc\u51fa\u8017\u65f6\uff1a" + (double)tick / 1000.0 + "\u79d2");
            System.out.println("\u6587\u4ef6\u540d\uff1a" + result);
        }
        return result;
    }

    private String getFilePath(String name) {
        String excelFileName = name == null ? UUID.randomUUID() + ".xlsx" : name;
        String path = ExcelUtil.class.getClassLoader().getResource("config.json").getPath();
        String rootPath = path.split("WEB-INF")[0];
        String filePath = rootPath + "excel/" + excelFileName;
        return filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export(String name, String body, String templateName, String filePath) throws Exception {
        JSONObject joParam = new JSONObject(body);
        String[][] footer = null;
        if (joParam.has("total")) {
            JSONArray totals = joParam.getJSONArray("total");
            footer = this.getFooter(totals);
        }
        JSONObject joVariable = joParam.getJSONObject("data");
        String sql = new SqlServer().call(name, joVariable);
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        try {
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement(sql);
            rs = preparedStatement.executeQuery();
            rs.setFetchSize(10001);
            if (templateName == null) {
                this.exportWithHedear(filePath, joParam, sql, rs, footer);
            } else {
                this.exportWithTemplate(templateName, filePath, rs, footer);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    private String[][] getFooter(JSONArray totals) {
        int n = totals.length();
        String[][] footer = new String[n][];
        for (int i = 0; i < n; ++i) {
            JSONObject jo = totals.getJSONObject(i);
            String[] names = JSONObject.getNames((JSONObject)jo);
            Arrays.sort(names, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return Integer.parseInt(o1) - Integer.parseInt(o2);
                }
            });
            footer[i] = new String[names.length];
            for (int j = 0; j < names.length; ++j) {
                footer[i][j] = jo.isNull(names[j]) ? null : jo.get(names[j]) + "";
            }
        }
        return footer;
    }

    private void exportWithTemplate(String templateName, String filePath, ResultSet rs, String[][] footer) throws Exception {
        ExcelUtil eu = new ExcelUtil();
        eu.createBook(templateName, filePath);
        int nCol = rs.getMetaData().getColumnCount();
        int n = 1;
        ArrayList rows = new ArrayList();
        while (rs.next()) {
            if (n % 10001 == 0) {
                eu.createSheet();
                n = 1;
                eu.writeToSheet(rows, null, footer);
                rows = new ArrayList();
            }
            ArrayList<Object> fieldList = new ArrayList<Object>();
            for (int i = 1; i <= nCol; ++i) {
                Object object = rs.getObject(i);
                fieldList.add(object);
            }
            rows.add(fieldList);
            ++n;
        }
        if (n > 1) {
            eu.createSheet();
            eu.writeToSheet(rows, null, footer);
        }
        eu.saveBook();
    }

    private void exportWithHedear(String filePath, JSONObject joParam, String sql, ResultSet rs, String[][] footer) throws Exception, SQLException {
        boolean fromHbm = false;
        JSONArray joField = joParam.getJSONArray("field");
        LinkedHashMap<String, String> colsMap = new LinkedHashMap<String, String>();
        this.findOutHeaders(joField, colsMap);
        String[] header = colsMap.values().toArray(new String[colsMap.size()]);
        String[] cols = colsMap.keySet().toArray(new String[colsMap.size()]);
        ExcelUtil eu = new ExcelUtil();
        eu.createBook(null, filePath);
        int n = 1;
        ArrayList rows = new ArrayList();
        while (rs.next()) {
            int i;
            if (n % 10001 == 0) {
                eu.createSheet();
                n = 1;
                eu.writeToSheet(rows, header, footer);
                rows = new ArrayList();
            }
            ArrayList<Object> fieldList = new ArrayList<Object>();
            if (fromHbm) {
                fieldList.add(rs.getObject("id"));
            }
            int n2 = i = fromHbm ? 1 : 0;
            while (i < colsMap.size()) {
                Object object = rs.getObject(cols[i]);
                fieldList.add(object);
                ++i;
            }
            rows.add(fieldList);
            ++n;
        }
        if (n > 1) {
            eu.createSheet();
            eu.writeToSheet(rows, header, footer);
        }
        eu.saveBook();
    }

    private void findOutHeaders(JSONArray joField, Map<String, String> headers) {
        for (Object temp : joField) {
            String col = ((String)temp).split(":")[0];
            headers.put(col, ((String)temp).split(":")[1]);
        }
    }
}

