/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins.iot;

import com.af.plugins.DateTools;
import com.af.plugins.HttpConnectionPoolUtil;
import com.af.plugins.iot.AuthenticationTools;
import com.af.plugins.iot.NorthApiClientTools;
import com.af.plugins.iot.NotifyType;
import com.af.plugins.iot.WebMeterInfo;
import com.af.plugins.xq.JsonTools2;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iotplatform.client.NorthApiClient;
import com.iotplatform.client.NorthApiException;
import com.iotplatform.client.dto.CommandDTOV4;
import com.iotplatform.client.dto.DeviceCommandRespV4;
import com.iotplatform.client.dto.PostDeviceCommandInDTO2;
import com.iotplatform.client.dto.PostDeviceCommandOutDTO2;
import com.iotplatform.client.dto.QueryDeviceCommandInDTO2;
import com.iotplatform.client.dto.QueryDeviceCommandOutDTO2;
import com.iotplatform.client.invokeapi.SignalDelivery;
import com.iotplatform.constant.AuthConstant;
import com.iotplatform.constant.ExceptionEnum;
import com.iotplatform.utils.JsonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.HashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class SignalDeliveryTools {
    private static Logger logger = Logger.getLogger(SignalDeliveryTools.class);
    private static SSLConnectionSocketFactory factory;

    public static JSONArray getCommandStatus(String deviceId) {
        QueryDeviceCommandOutDTO2 qdcod;
        SignalDelivery sd = new SignalDelivery();
        sd.setNorthApiClient(NorthApiClientTools.getNorthApiClient());
        QueryDeviceCommandInDTO2 qdcid = new QueryDeviceCommandInDTO2();
        qdcid.setDeviceId(deviceId);
        qdcid.setPageNo(Integer.valueOf(0));
        qdcid.setPageSize(Integer.valueOf(150));
        qdcid.setStartTime(DateTools.getDiffDate("DATE", "-2", "yyyyMMdd'T'000000'Z'"));
        try {
            qdcod = sd.queryDeviceCommand(qdcid, AuthenticationTools.getAuthToken());
        }
        catch (NorthApiException e) {
            logger.error((Object)"IOT\u63a5\u53e3\u8c03\u7528\u9519\u8bef\uff01\uff0c\u4fe1\u606f\uff1a", (Throwable)e);
            return null;
        }
        JSONArray result = new JSONArray();
        for (DeviceCommandRespV4 command : qdcod.getData()) {
            JSONObject item = new JSONObject();
            item.put("commandId", (Object)command.getCommandId());
            item.put("status", (Object)command.getStatus());
            result.put((Object)item);
        }
        return result;
    }

    public static JSONObject postCommand(String serviceId, String method, String deviceId, JSONObject jo, Integer expireTime) {
        PostDeviceCommandOutDTO2 pdcod;
        SignalDelivery sd = new SignalDelivery();
        sd.setNorthApiClient(NorthApiClientTools.getNorthApiClient());
        PostDeviceCommandInDTO2 pdcid = new PostDeviceCommandInDTO2();
        pdcid.setDeviceId(deviceId);
        CommandDTOV4 acdo = new CommandDTOV4();
        ObjectNode paras = null;
        try {
            paras = JsonUtil.convertObject2ObjectNode((Object)jo.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        acdo.setServiceId(serviceId);
        acdo.setMethod(method);
        acdo.setParas((Object)paras);
        pdcid.setCommand(acdo);
        if (expireTime != null) {
            pdcid.setExpireTime(expireTime);
        }
        pdcid.setCallbackUrl(WebMeterInfo.getString("telecomCallBackUrl"));
        long begin = System.currentTimeMillis();
        try {
            pdcod = sd.postDeviceCommand(pdcid, WebMeterInfo.getString("telecomAPIKey"), AuthenticationTools.getAuthToken());
            long end = System.currentTimeMillis();
            logger.warn((Object)("\u8bf7\u6c42\u63a5\u53e3\u8017\u65f6\uff1a" + (end - begin) + "ms"));
        }
        catch (NorthApiException e) {
            logger.error((Object)"IOT\u63a5\u53e3\u8c03\u7528\u9519\u8bef\uff01\uff0c\u4fe1\u606f\uff1a", (Throwable)e);
            long end = System.currentTimeMillis();
            logger.warn((Object)("\u8bf7\u6c42\u63a5\u53e3\u8017\u65f6\uff1a" + (end - begin) + "ms"));
            return null;
        }
        JSONObject object = new JSONObject();
        object.put("commandId", (Object)pdcod.getCommandId());
        object.put("appId", (Object)pdcod.getAppId());
        object.put("deviceId", (Object)pdcod.getDeviceId());
        object.put("callbackUrl", (Object)pdcod.getCallbackUrl());
        object.put("status", (Object)pdcod.getStatus());
        object.put("result", (Object)pdcod.getResult());
        return object;
    }

    public static JSONObject myPostCommand(String serviceId, String method, String deviceId, JSONObject jo) throws NorthApiException, IOException {
        String accessToken = AuthenticationTools.getAuthToken();
        String urlCreateDeviceCommand = "https://" + WebMeterInfo.getString("telecomApplicationUrl") + ":8743/iocm/app/cmd/v1.4.0/deviceCommands";
        String appId = WebMeterInfo.getString("telecomAPIKey");
        String callbackUrl = WebMeterInfo.getString("telecomCallBackUrl");
        Integer expireTime = 0;
        Integer maxRetransmit = 3;
        HashMap<String, String> paramCommand = new HashMap<String, String>();
        paramCommand.put("serviceId", serviceId);
        paramCommand.put("method", method);
        paramCommand.put("paras", (String)jo);
        JSONObject paramCreateDeviceCommand = new JSONObject();
        paramCreateDeviceCommand.put("deviceId", (Object)deviceId);
        paramCreateDeviceCommand.put("command", paramCommand);
        paramCreateDeviceCommand.put("callbackUrl", (Object)callbackUrl);
        paramCreateDeviceCommand.put("expireTime", (Object)expireTime);
        paramCreateDeviceCommand.put("maxRetransmit", (Object)maxRetransmit);
        JSONObject header = new JSONObject();
        header.put("app_key", (Object)appId);
        header.put("Authorization", (Object)("Bearer " + accessToken));
        header.put("Content-Type", (Object)"application/json");
        String responseBody = HttpConnectionPoolUtil.request(urlCreateDeviceCommand, paramCreateDeviceCommand.toString(), header.toString(), (HttpEntityEnclosingRequestBase)new HttpPost(), factory);
        HashMap result = JsonTools2.jsonToMap(new JSONObject(responseBody));
        if (result.get("error_code") != null) {
            throw new RuntimeException(responseBody);
        }
        return new JSONObject().put("commandId", result.get("commandId"));
    }

    public static JSONObject postCommand(String serviceId, String method, String deviceId, JSONObject jo) throws NorthApiException {
        return SignalDeliveryTools.postCommand(serviceId, method, deviceId, jo, 0);
    }

    public static JSONObject postCommand(String method, String deviceId, String base64String) throws NorthApiException {
        return SignalDeliveryTools.postCommand(method, deviceId, base64String, 0);
    }

    public static JSONObject postCommand(String method, String deviceId, String base64String, Integer expireTime) throws NorthApiException {
        JSONObject object = new JSONObject();
        object.put("rawData", (Object)base64String);
        return SignalDeliveryTools.postCommand("RawData", method, deviceId, object, expireTime);
    }

    public static JSONObject subscribe(NotifyType notifyType, String callBackUrl) {
        String accessToken;
        try {
            accessToken = AuthenticationTools.getAuthToken();
        }
        catch (NorthApiException e) {
            logger.error((Object)"IOT\u63a5\u53e3\u8c03\u7528\u9519\u8bef\uff01\uff0c\u4fe1\u606f\uff1a", (Throwable)e);
            return null;
        }
        NorthApiClient northApiClient = NorthApiClientTools.getNorthApiClient();
        String regDeviceUrl = "https://" + northApiClient.getClientInfo().getPlatformIp() + ":" + northApiClient.getClientInfo().getPlatformPort() + "/iocm/app/sub/v1.2.0/subscriptions";
        HashMap<String, String> header = new HashMap<String, String>(2);
        header.put("app_key", WebMeterInfo.getString("telecomAPIKey"));
        header.put("Authorization", "Bearer " + accessToken);
        JSONObject bodyParams = new JSONObject();
        bodyParams.put("notifyType", (Object)notifyType.getValue());
        bodyParams.put("callbackUrl", (Object)callBackUrl);
        try {
            return (JSONObject)northApiClient.invokeAPI(regDeviceUrl, "POST", null, bodyParams.toString(), header, null, null, ContentType.APPLICATION_JSON, null, JSONObject.class);
        }
        catch (NorthApiException e) {
            logger.error((Object)"IOT\u63a5\u53e3\u8c03\u7528\u9519\u8bef\uff01\uff0c\u4fe1\u606f\uff1a", (Throwable)e);
            return null;
        }
    }

    public static JSONObject deleteAllSubscribe() {
        String accessToken;
        try {
            accessToken = AuthenticationTools.getAuthToken();
        }
        catch (NorthApiException e) {
            logger.error((Object)"IOT\u63a5\u53e3\u8c03\u7528\u9519\u8bef\uff01\uff0c\u4fe1\u606f\uff1a", (Throwable)e);
            return null;
        }
        NorthApiClient northApiClient = NorthApiClientTools.getNorthApiClient();
        String regDeviceUrl = "https://" + northApiClient.getClientInfo().getPlatformIp() + ":" + northApiClient.getClientInfo().getPlatformPort() + "/iocm/app/sub/v1.2.0/subscriptions";
        HashMap<String, String> header = new HashMap<String, String>(16);
        header.put("app_key", WebMeterInfo.getString("telecomAPIKey"));
        header.put("Authorization", "Bearer " + accessToken);
        try {
            return (JSONObject)northApiClient.invokeAPI(regDeviceUrl, "DELETE", null, null, header, null, null, ContentType.APPLICATION_JSON, null, JSONObject.class);
        }
        catch (NorthApiException e) {
            logger.error((Object)"IOT\u63a5\u53e3\u8c03\u7528\u9519\u8bef\uff01\uff0c\u4fe1\u606f\uff1a", (Throwable)e);
            return null;
        }
    }

    private static SSLConnectionSocketFactory initSSLConfig() throws NorthApiException {
        try {
            InputStream isTrustCa = SignalDeliveryTools.class.getResourceAsStream("/ca.jks");
            InputStream isSelfCert = SignalDeliveryTools.class.getResourceAsStream("/outgoing.CertwithKey.pkcs12");
            KeyStore selfCert = KeyStore.getInstance("pkcs12");
            selfCert.load(isSelfCert, AuthConstant.SELFCERTPWD.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("sunx509");
            kmf.init(selfCert, AuthConstant.SELFCERTPWD.toCharArray());
            KeyStore caCert = KeyStore.getInstance("jks");
            caCert.load(isTrustCa, AuthConstant.TRUSTCAPWD.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("sunx509");
            tmf.init(caCert);
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sc, (HostnameVerifier)new NoopHostnameVerifier());
            isTrustCa.close();
            isSelfCert.close();
            return sslConnectionSocketFactory;
        }
        catch (Exception var10) {
            throw new NorthApiException(ExceptionEnum.CLIENT_SSL_CONFIG_ERROR, var10.getMessage().toString());
        }
    }

    public static SSLConnectionSocketFactory getFactory() {
        return factory;
    }

    static {
        try {
            factory = SignalDeliveryTools.initSSLConfig();
        }
        catch (NorthApiException e) {
            e.printStackTrace();
        }
    }
}

