/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins.iot;

import com.af.plugins.HttpConnectionPoolUtil;
import com.af.plugins.iot.SignalDeliveryTools;
import com.af.plugins.iot.WebMeterInfo;
import com.iotplatform.client.NorthApiException;
import com.iotplatform.client.dto.AuthOutDTO;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class AuthenticationTools {
    private static Logger logger = Logger.getLogger(AuthenticationTools.class);
    private static Map<String, Long> stamp = new ConcurrentHashMap<String, Long>();
    private static Map<String, String> aod = new ConcurrentHashMap<String, String>();

    public static String getAuthToken() throws NorthApiException {
        long current = System.currentTimeMillis();
        String apiKey = WebMeterInfo.getString("telecomAPIKey");
        String accessToken = aod.get(apiKey);
        Long stampValue = stamp.get(apiKey);
        if (accessToken != null && stampValue != null && current - stampValue < 1800000L) {
            logger.info((Object)(apiKey + ":\u83b7\u53d6\u73b0\u6709token"));
            return accessToken;
        }
        try {
            return AuthenticationTools.getToken(apiKey, AuthenticationTools.getWebAuthToken());
        }
        catch (NorthApiException e) {
            if (accessToken != null) {
                return accessToken;
            }
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static AuthOutDTO getWebAuthToken() throws IOException {
        String urlAuthToken = "https://" + WebMeterInfo.getString("telecomApplicationUrl") + ":8743/iocm/app/sec/v1.1.0/login";
        String appId = WebMeterInfo.getString("telecomAPIKey");
        String secret = WebMeterInfo.getString("telecomSecret");
        Integer expireTime = 0;
        Integer maxRetransmit = 3;
        HashMap<String, String> paramCommand = new HashMap<String, String>();
        paramCommand.put("appId", appId);
        paramCommand.put("secret", secret);
        String responseBody = HttpConnectionPoolUtil.requestFormUrlEncoded(urlAuthToken, paramCommand, (HttpEntityEnclosingRequestBase)new HttpPost(), SignalDeliveryTools.getFactory());
        AuthOutDTO authOutDTO = new AuthOutDTO();
        authOutDTO.setAccessToken(new JSONObject(responseBody).getString("accessToken"));
        return authOutDTO;
    }

    private static synchronized String getToken(String apiKey, AuthOutDTO auth) throws NorthApiException {
        long current = System.currentTimeMillis();
        String accessToken = aod.get(apiKey);
        Long stampValue = stamp.get(apiKey);
        if (accessToken != null && stampValue != null && current - stampValue < 1800000L) {
            logger.info((Object)(apiKey + ":\u83b7\u53d6\u73b0\u6709token"));
            return accessToken;
        }
        logger.info((Object)(apiKey + ":\u8fdb\u884c\u9274\u6743\u64cd\u4f5c"));
        String newAccessToken = auth.getAccessToken();
        aod.put(apiKey, newAccessToken);
        stamp.put(apiKey, System.currentTimeMillis());
        return newAccessToken;
    }
}

