/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins;

import com.af.plugins.Config;
import com.af.plugins.RestTools;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class HttpConnectionPoolUtil {
    private static Logger logger = Logger.getLogger(HttpConnectionPoolUtil.class);
    private static final int CONNECT_TIMEOUT = Config.getConnectTimeout();
    private static final int SOCKET_TIMEOUT = Config.getConnectTimeout();
    private static final int SO_TIMEOUT = Config.getConnectTimeout();
    private static final int VALIDATE_AFTER_INACTIVITY = Config.getValidateAfterInactivity();
    private static final int MAX_CONN = Config.getHttpMaxPoolSize();
    private static CloseableHttpClient httpClient;
    private static PoolingHttpClientConnectionManager manager;
    private static final Object syncLock;

    private static void setRequestConfig(HttpRequestBase httpRequestBase) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(CONNECT_TIMEOUT).setConnectTimeout(CONNECT_TIMEOUT).setSocketTimeout(SOCKET_TIMEOUT).build();
        httpRequestBase.setConfig(requestConfig);
    }

    private static CloseableHttpClient getHttpClient() {
        return HttpConnectionPoolUtil.getHttpClient(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CloseableHttpClient getHttpClient(LayeredConnectionSocketFactory sslSocketFactory) {
        if (httpClient == null) {
            Object object = syncLock;
            synchronized (object) {
                if (httpClient == null) {
                    logger.debug((Object)"\u521b\u5efahttp\u5ba2\u6237\u7aef\u4f1a\u8bdd");
                    httpClient = HttpConnectionPoolUtil.createHttpClient(sslSocketFactory);
                }
            }
        }
        return httpClient;
    }

    private static CloseableHttpClient createHttpClient() {
        return HttpConnectionPoolUtil.createHttpClient(null);
    }

    private static CloseableHttpClient createHttpClient(LayeredConnectionSocketFactory sslSocketFactory) {
        if (sslSocketFactory == null) {
            sslSocketFactory = SSLConnectionSocketFactory.getSocketFactory();
        }
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)sslSocketFactory).build();
        manager = new PoolingHttpClientConnectionManager(registry);
        manager.setMaxTotal(MAX_CONN);
        manager.setDefaultMaxPerRoute(MAX_CONN);
        manager.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(SO_TIMEOUT).setSoKeepAlive(false).build());
        HttpRequestRetryHandler handler = (e, i, httpContext) -> {
            if (i > 3) {
                logger.error((Object)"\u91cd\u8bd5\u8d85\u8fc73\u6b21,\u653e\u5f03\u8bf7\u6c42");
                return false;
            }
            if (e instanceof NoHttpResponseException) {
                logger.error((Object)"\u670d\u52a1\u5668\u6ca1\u6709\u54cd\u5e94,\u53ef\u80fd\u662f\u670d\u52a1\u5668\u65ad\u5f00\u4e86\u8fde\u63a5,\u8fdb\u884c\u91cd\u8bd5");
                return true;
            }
            if (e instanceof SSLHandshakeException) {
                logger.error((Object)"SSL\u63e1\u624b\u5f02\u5e38:", (Throwable)e);
                return false;
            }
            if (e instanceof InterruptedIOException) {
                logger.error((Object)"\u8fde\u63a5\u8d85\u65f6:", (Throwable)e);
                return false;
            }
            if (e instanceof UnknownHostException) {
                logger.error((Object)"\u670d\u52a1\u5668\u4e0d\u53ef\u8fbe:", (Throwable)e);
                return false;
            }
            if (e instanceof SSLException) {
                logger.error((Object)"SSL\u5f02\u5e38:", (Throwable)e);
                return false;
            }
            HttpClientContext context = HttpClientContext.adapt((HttpContext)httpContext);
            HttpRequest request = context.getRequest();
            return !(request instanceof HttpEntityEnclosingRequest);
        };
        ConnectionKeepAliveStrategy myStrategy = (response, context) -> {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (it.hasNext()) {
                HeaderElement he = it.nextElement();
                String param = he.getName();
                String value = he.getValue();
                if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                try {
                    return Long.parseLong(value) * 1000L;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            HttpHost target = (HttpHost)context.getAttribute("http.target_host");
            if ("www.naughty-server.com".equalsIgnoreCase(target.getHostName())) {
                return 5000L;
            }
            return 30000L;
        };
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)manager).setRetryHandler(handler).setKeepAliveStrategy(myStrategy).evictExpiredConnections().evictIdleConnections((long)Config.getHttpIdelTimeout(), TimeUnit.MILLISECONDS).build();
    }

    private static void setPostParams(HttpEntityEnclosingRequestBase base, String params) {
        if (params != null && !"".equals(params)) {
            StringEntity se = new StringEntity(params, StandardCharsets.UTF_8);
            base.setEntity((HttpEntity)se);
        }
    }

    private static void setHeaders(HttpEntityEnclosingRequestBase base, String headersStr) {
        if (headersStr != null && !"".equals(headersStr)) {
            JSONObject headers = new JSONObject(headersStr);
            Iterator keys = headers.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String val = headers.getString(key);
                base.setHeader(key, val);
            }
        }
    }

    public static String request(String path, String value, String headersStr, HttpEntityEnclosingRequestBase base) throws IOException {
        return HttpConnectionPoolUtil.request(path, value, headersStr, base, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String request(String path, String value, String headersStr, HttpEntityEnclosingRequestBase base, SSLConnectionSocketFactory factory) throws IOException {
        HttpConnectionPoolUtil.setRequestConfig((HttpRequestBase)base);
        HttpConnectionPoolUtil.setPostParams(base, value);
        HttpConnectionPoolUtil.setHeaders(base, headersStr);
        base.setURI(URI.create(path));
        String result = null;
        try (CloseableHttpResponse response = null;){
            long begin = System.currentTimeMillis();
            response = HttpConnectionPoolUtil.getHttpClient((LayeredConnectionSocketFactory)factory).execute((HttpUriRequest)base, (HttpContext)HttpClientContext.create());
            long end = System.currentTimeMillis();
            logger.warn((Object)("\u8bf7\u6c42\u63a5\u53e3\u8017\u65f6\uff1a" + (end - begin) + "ms"));
            result = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
        }
        return result;
    }

    public static void closeConnectionPool() {
        try {
            httpClient.close();
            manager.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String requestFormUrlEncoded(String path, Map<String, String> params, HttpEntityEnclosingRequestBase base, SSLConnectionSocketFactory factory) throws IOException {
        HttpConnectionPoolUtil.setRequestConfig((HttpRequestBase)base);
        base.setURI(URI.create(path));
        base.setEntity((HttpEntity)new UrlEncodedFormEntity(HttpConnectionPoolUtil.paramsConverter(params)));
        String result = null;
        try (CloseableHttpResponse response = null;){
            long begin = System.currentTimeMillis();
            response = HttpConnectionPoolUtil.getHttpClient((LayeredConnectionSocketFactory)factory).execute((HttpUriRequest)base, (HttpContext)HttpClientContext.create());
            long end = System.currentTimeMillis();
            logger.warn((Object)("\u8bf7\u6c42\u63a5\u53e3\u8017\u65f6\uff1a" + (end - begin) + "ms"));
            result = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
        }
        return result;
    }

    private static List<NameValuePair> paramsConverter(Map<String, String> params) {
        LinkedList<NameValuePair> nvps = new LinkedList<NameValuePair>();
        Set<Map.Entry<String, String>> paramsSet = params.entrySet();
        for (Map.Entry<String, String> paramEntry : paramsSet) {
            nvps.add((NameValuePair)new BasicNameValuePair(paramEntry.getKey(), paramEntry.getValue()));
        }
        return nvps;
    }

    public static void main(String[] args) {
        System.out.println(RestTools.post("http://localhost:8080/webmeter/rs/logic/WeiSiDaYZMoneyRunChargeMeter", new JSONObject().put("f_instruct_content", (Object)new JSONObject().put("f_balance", 5).toString()).put("id", (Object)"1").put("deviceId", (Object)"ce6fe21d-32cb-44fc-bb8e-a7e0087b0738")));
    }

    static {
        syncLock = new Object();
    }
}

