/*
 * Decompiled with CFR 0.152.
 */
package com.aote.plugins.impexp;

import com.af.plugins.RestTools;
import com.aote.ThreadResource;
import com.aote.module.ModuleMapper;
import com.aote.plugins.impexp.exportfile.IExportFile;
import com.aote.plugins.impexp.importfile.IDataAnaly;
import com.aote.plugins.impexp.importfile.JSONConfigAnaly;
import com.aote.rs.mapper.WebException;
import com.aote.util.ExcelUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ContextLoader;

public class FileManager {
    public ApplicationContext assingedContext = null;

    public JSONArray read(String filepath, String configName) {
        InputStream is = null;
        try {
            filepath = filepath.replaceAll("\\\\", "/");
            String jsonString = "{\"filepath\":\"" + filepath + "\"}";
            HttpEntity httpEntity = RestTools.postHttpEntity("/rs/file/getUploadFile", new JSONObject(jsonString));
            is = httpEntity.getContent();
        }
        catch (FileNotFoundException e) {
            throw new WebException(500, filepath + "\u60a8\u6240\u9009\u7684\u6587\u4ef6\u4e0d\u5b58\u5728!!!");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        filepath = filepath.replace("\\", "/");
        String fileName = filepath.split("/")[filepath.split("/").length - 1];
        List data = null;
        if (fileName.endsWith("xls") || fileName.endsWith("xlsx")) {
            try {
                data = ExcelUtil.readExcel((InputStream)is, (String)fileName);
            }
            catch (IOException e) {
                throw new WebException(500, "\u6587\u4ef6\u89e3\u6790\u9519\u8bef!!!");
            }
        } else {
            throw new WebException(500, "\u975eexcel\u6587\u4ef6\u6682\u65f6\u672a\u4f5c\u5904\u7406.\u5982\u6709\u9700\u6c42,\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458!!!!");
        }
        return this.getBean(configName).analy(data);
    }

    public JSONArray export(String condition, String beanName, String configName) {
        try {
            return this.getExportBean(beanName).export(condition, configName);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private IDataAnaly getBean(String configName) {
        String userConfigFile = this.getUserConfig(configName);
        Map map = ModuleMapper.getMap();
        String configFilePath = null;
        for (String key : map.keySet()) {
            if (FileManager.class.getClassLoader().getResourceAsStream(key + "/impexp/imp/" + configName) == null) continue;
            configFilePath = key + "/impexp/imp/" + configName;
            break;
        }
        map.toString();
        JSONConfigAnaly jca = new JSONConfigAnaly();
        if (userConfigFile != null) {
            jca.setJsonPath(userConfigFile);
        } else if (configFilePath != null) {
            jca.setJsonPath(configFilePath);
        } else {
            throw new WebException(404, "\u627e\u4e0d\u5230\u914d\u7f6e: " + configName);
        }
        return jca;
    }

    private String getUserConfig(String configName) {
        String dir = (String)ThreadResource.ComponentDir.get();
        if (dir == null) {
            return null;
        }
        String path = dir + "/impexp/imp/" + configName;
        if (FileManager.class.getClassLoader().getResourceAsStream(path) == null) {
            return null;
        }
        return path;
    }

    private IExportFile getExportBean(String name) {
        Object wac = this.assingedContext != null ? this.assingedContext : ContextLoader.getCurrentWebApplicationContext();
        return (IExportFile)wac.getBean(name);
    }
}

