/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins.sms;

import com.af.plugins.ConvertTools;
import com.af.plugins.iot.IOTException;
import com.af.plugins.iot.IOTExceptionCode;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.Set;
import org.json.JSONObject;

public class PropertiesReaderPlugin {
    public static String read(String propsName, String key) {
        try {
            return PropertiesReaderPlugin.read(propsName, key, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String readToUTF8(String propsName, String key) {
        String s = PropertiesReaderPlugin.read(propsName, key);
        return ConvertTools.stringToCharset(s, StandardCharsets.ISO_8859_1, StandardCharsets.UTF_8);
    }

    public static JSONObject readTojson(String propsName, String key) {
        String s = PropertiesReaderPlugin.read(propsName, key);
        return new JSONObject(ConvertTools.stringToCharset(s, StandardCharsets.ISO_8859_1, StandardCharsets.UTF_8));
    }

    public static String read(String propsName, String key, JSONObject param) {
        Properties props = new Properties();
        try {
            props.load(PropertiesReaderPlugin.class.getResourceAsStream("/" + propsName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String str = props.getProperty(key);
        if (param != null) {
            Set set = param.keySet();
            for (String paramStr : set) {
                String replaceString = "\\{" + paramStr + "}";
                str = str.replaceAll(replaceString, param.getString(paramStr));
            }
        }
        return str;
    }

    public static String readWebMeter(String key, String moduleName, JSONObject param) {
        Properties props = new Properties();
        InputStream proStream = PropertiesReaderPlugin.class.getResourceAsStream("/" + moduleName + "/webmeter.properties");
        if (proStream == null) {
            return null;
        }
        InputStreamReader propertiesAsStream = new InputStreamReader(PropertiesReaderPlugin.class.getResourceAsStream("/" + moduleName + "/webmeter.properties"), StandardCharsets.UTF_8);
        try {
            props.load(propertiesAsStream);
        }
        catch (IOException e) {
            throw new IOTException(IOTExceptionCode.CONFIG_FAIL);
        }
        if (key != null) {
            String str = props.getProperty(key);
            if (param != null) {
                Set set = param.keySet();
                for (String paramStr : set) {
                    String replaceString = "\\{" + paramStr + "}";
                    if (!"null".equals(param.getString(paramStr))) {
                        str = str.replaceAll(replaceString, param.getString(paramStr));
                        continue;
                    }
                    if (props.containsKey(paramStr)) {
                        str = str.replaceAll(replaceString, props.getProperty(paramStr));
                        continue;
                    }
                    str = str.replaceAll(replaceString, "null");
                }
            }
            return str;
        }
        JSONObject params = new JSONObject();
        Set<Object> keys = props.keySet();
        for (Object k : keys) {
            String keyStr = k.toString();
            String value = props.getProperty(keyStr);
            params.put(keyStr, (Object)value);
        }
        return params.toString();
    }
}

