/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins.onenet;

import com.af.plugins.RestTools;
import com.af.plugins.iot.WebMeterInfo;
import org.apache.http.conn.HttpHostConnectException;
import org.json.JSONObject;

public class OnenetRestTools
extends RestTools {
    public static JSONObject createDevice(JSONObject params, String imei, String imsi) {
        String path = WebMeterInfo.getString("onenetApplicationUrl") + "/devices";
        JSONObject headers = new JSONObject();
        headers.put("api-key", (Object)WebMeterInfo.getString("onenetAPIKey"));
        JSONObject auth_info = new JSONObject();
        auth_info.put(imei, (Object)imsi);
        params.put("auth_info", (Object)auth_info);
        int count = 1;
        while (true) {
            try {
                return new JSONObject(OnenetRestTools.post(path, params, headers));
            }
            catch (RuntimeException e) {
                if (!(e.getCause() instanceof HttpHostConnectException) || ++count < 3) continue;
                throw e;
            }
            break;
        }
    }

    public static JSONObject getDevice(String device_id) {
        String path = WebMeterInfo.getString("onenetApplicationUrl") + "/devices/" + device_id;
        JSONObject headers = new JSONObject();
        headers.put("api-key", (Object)WebMeterInfo.getString("onenetAPIKey"));
        int count = 1;
        while (true) {
            try {
                return new JSONObject((Object)OnenetRestTools.getJson(path, headers));
            }
            catch (RuntimeException e) {
                if (!(e.getCause() instanceof HttpHostConnectException) || ++count < 3) continue;
                throw e;
            }
            break;
        }
    }

    public static JSONObject deleteDevice(String device_id) {
        String path = WebMeterInfo.getString("onenetApplicationUrl") + "/devices/" + device_id;
        JSONObject headers = new JSONObject();
        headers.put("api-key", (Object)WebMeterInfo.getString("onenetAPIKey"));
        int count = 1;
        while (true) {
            try {
                return new JSONObject(OnenetRestTools.delete(path, null, headers));
            }
            catch (RuntimeException e) {
                if (!(e.getCause() instanceof HttpHostConnectException) || ++count < 3) continue;
                throw e;
            }
            break;
        }
    }

    public static JSONObject readDeviceRes(String imei, String timeout) {
        JSONObject params = new JSONObject();
        params.put("imei", (Object)imei);
        params.put("obj_id", (Object)WebMeterInfo.getString("onenetObjectID"));
        params.put("obj_inst_id", (Object)WebMeterInfo.getString("onenetObjectInstID"));
        params.put("res_id", (Object)WebMeterInfo.getString("onenetResID"));
        params.put("timeout", (Object)(timeout == null ? "25" : timeout));
        String path = OnenetRestTools.formatURL(WebMeterInfo.getString("onenetApplicationUrl") + "/nbiot", params);
        JSONObject headers = new JSONObject();
        headers.put("api-key", (Object)WebMeterInfo.getString("onenetAPIKey"));
        int count = 1;
        while (true) {
            try {
                return new JSONObject((Object)OnenetRestTools.getJson(path, headers));
            }
            catch (RuntimeException e) {
                if (!(e.getCause() instanceof HttpHostConnectException) || ++count < 3) continue;
                throw e;
            }
            break;
        }
    }

    public static JSONObject writeDeviceRes(String imei, String mode, String timeout, JSONObject content) {
        JSONObject params = new JSONObject();
        params.put("imei", (Object)imei);
        params.put("obj_id", (Object)WebMeterInfo.getString("onenetObjectID"));
        params.put("obj_inst_id", (Object)WebMeterInfo.getString("onenetObjectInstID"));
        params.put("mode", mode == null ? Integer.valueOf(1) : mode);
        params.put("timeout", (Object)(timeout == null ? "25" : timeout));
        String path = OnenetRestTools.formatURL(WebMeterInfo.getString("onenetApplicationUrl") + "/nbiot", params);
        JSONObject headers = new JSONObject();
        headers.put("api-key", (Object)WebMeterInfo.getString("onenetAPIKey"));
        int count = 1;
        while (true) {
            try {
                return new JSONObject(OnenetRestTools.post(path, content, headers));
            }
            catch (RuntimeException e) {
                if (!(e.getCause() instanceof HttpHostConnectException) || ++count < 3) continue;
                throw e;
            }
            break;
        }
    }

    public static JSONObject sendCommand(String imei, String timeout, JSONObject content) {
        JSONObject params = new JSONObject();
        params.put("imei", (Object)imei);
        params.put("obj_id", (Object)WebMeterInfo.getString("onenetObjectID"));
        params.put("obj_inst_id", (Object)WebMeterInfo.getString("onenetObjectInstID"));
        params.put("res_id", (Object)WebMeterInfo.getString("onenetResID"));
        params.put("timeout", (Object)(timeout == null ? "25" : timeout));
        String path = OnenetRestTools.formatURL(WebMeterInfo.getString("onenetApplicationUrl") + "/nbiot/execute", params);
        JSONObject headers = new JSONObject();
        headers.put("api-key", (Object)WebMeterInfo.getString("onenetAPIKey"));
        int count = 1;
        while (true) {
            try {
                return new JSONObject(OnenetRestTools.post(path, content, headers));
            }
            catch (RuntimeException e) {
                if (!(e.getCause() instanceof HttpHostConnectException) || ++count < 3) continue;
                throw e;
            }
            break;
        }
    }

    public static JSONObject getResources(JSONObject params) {
        String path = OnenetRestTools.formatURL(WebMeterInfo.getString("onenetApplicationUrl") + "/nbiot/resources", params);
        JSONObject headers = new JSONObject();
        headers.put("api-key", (Object)WebMeterInfo.getString("onenetAPIKey"));
        int count = 1;
        while (true) {
            try {
                return new JSONObject((Object)OnenetRestTools.getJson(path, headers));
            }
            catch (RuntimeException e) {
                if (!(e.getCause() instanceof HttpHostConnectException) || ++count < 3) continue;
                throw e;
            }
            break;
        }
    }

    public static JSONObject subscribe(JSONObject params) {
        String path = OnenetRestTools.formatURL(WebMeterInfo.getString("onenetApplicationUrl") + "/nbiot/observe", params);
        JSONObject headers = new JSONObject();
        headers.put("api-key", (Object)WebMeterInfo.getString("onenetAPIKey"));
        int count = 1;
        while (true) {
            try {
                return new JSONObject(OnenetRestTools.post(path, null, headers));
            }
            catch (RuntimeException e) {
                if (!(e.getCause() instanceof HttpHostConnectException) || ++count < 3) continue;
                throw e;
            }
            break;
        }
    }
}

