/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins.android;

import com.af.plugins.android.zt.BlueRW;
import com.af.plugins.android.zt.ReadCard;
import com.af.plugins.android.zt.SlotCard;
import com.af.plugins.android.zt.StringUtility;
import com.af.plugins.android.zt.WriCard;
import com.szzt.sdk.device.card.ContactlessCardReader;
import com.szzt.sdk.device.card.SmartCardReader;

public class ZTCAReader {
    public ContactlessCardReader rfReader;
    public SmartCardReader icReader;
    public int defaultReaderNo = 0;
    private BlueRW blueRW = new BlueRW();

    public SlotCard findTheSlotThatHasCardOn() {
        SlotCard sc = new SlotCard();
        byte[] data = new byte[256];
        int rfCardSlot = this.ifCardOnContactlessSlot(data);
        int icCardSlot = this.ifCardInSlot(data);
        if (rfCardSlot == -2 && icCardSlot == -2) {
            sc.slot = -3;
        } else if (rfCardSlot == -1 && icCardSlot == -1) {
            sc.slot = -1;
        } else if (rfCardSlot >= 0 && icCardSlot >= 0) {
            sc.slot = -2;
        } else if (icCardSlot >= 0) {
            sc.slot = 1;
            sc.cardType = icCardSlot;
        } else {
            sc.slot = 0;
            sc.cardType = rfCardSlot;
        }
        return sc;
    }

    private int ifCardInSlot(byte[] data) {
        if (this.icReader != null) {
            int r = this.icReader.open(this.defaultReaderNo, null);
            if (r < 0) {
                return -2;
            }
            r = this.icReader.powerOn(this.defaultReaderNo, data);
            if (r <= 0) {
                this.icReader.powerOff(this.defaultReaderNo);
                this.icReader.close();
                return -2;
            }
            int cardType = this.icReader.getCardType(this.defaultReaderNo);
            if (cardType >= 0 && cardType <= 6 || cardType == 256) {
                // empty if block
            }
            this.icReader.powerOff(this.defaultReaderNo);
            return cardType;
        }
        return -1;
    }

    private int ifCardOnContactlessSlot(byte[] data) {
        if (this.rfReader != null) {
            int r = this.rfReader.open();
            if (r < 0) {
                return -2;
            }
            r = this.rfReader.waitForCard(1000);
            if (r != 0) {
                return -2;
            }
            int ret = this.rfReader.powerOn(data);
            if (ret <= 0) {
                this.rfReader.powerOff();
                this.rfReader.close();
                return -2;
            }
            int cardType = this.rfReader.getCardType();
            if (cardType >= 0 && cardType <= 9 || cardType == 256) {
                // empty if block
            }
            this.rfReader.powerOff();
            this.rfReader.close();
            return cardType;
        }
        return -1;
    }

    private int oneRound(int r, String s, byte[] ret) {
        byte[] b = StringUtility.StringToByteArray(s);
        int len = r == 0 ? this.rfReader.transmit(b, ret) : this.icReader.transmit(this.defaultReaderNo, b, ret);
        if (len < 0) {
            return len;
        }
        return len;
    }

    private int isCPU() {
        SlotCard sc = this.findTheSlotThatHasCardOn();
        if (sc.slot < 0) {
            return sc.slot;
        }
        if (sc.slot == 1 && sc.cardType == 0) {
            return 1;
        }
        if (sc.slot == 0 && sc.cardType == 0) {
            return 0;
        }
        return -1;
    }

    public int prelude() {
        int n;
        int r = this.isCPU();
        if (r < 0) {
            return -9999;
        }
        if (this.openDevice(r) < 0) {
            return -9998;
        }
        byte[] ret = new byte[64];
        String cmd = "00A404000E325041592E5359532E4444463031";
        if (r == 1) {
            cmd = "00A404000E315041592E5359532E44444630310000";
        }
        if ((n = this.oneRound(r, cmd, ret)) < 0) {
            return -1;
        }
        if (n > 2 && ret[n - 2] == 97 && (n = this.oneRound(r, "00C00000" + StringUtility.ByteArrayToString(ret, n - 1, 1), ret)) < 0) {
            return -1;
        }
        return r;
    }

    public int readCard(ReadCard rc) {
        int r = this.prelude();
        if (r < 0) {
            return r;
        }
        this.blueRW.icReader = this.icReader;
        this.blueRW.rfReader = this.rfReader;
        this.blueRW.defaultReaderNo = this.defaultReaderNo;
        this.blueRW.isRfOrCpu = r;
        int n = this.blueRW.readRfCard(rc);
        this.closeDevice(r);
        return n;
    }

    private int openDevice(int ic) {
        byte[] data = new byte[256];
        if (ic == 0) {
            int r = this.rfReader.open();
            if (r < 0) {
                return -2;
            }
            r = this.rfReader.waitForCard(1000);
            if (r != 0) {
                return -2;
            }
            int ret = this.rfReader.powerOn(data);
            if (ret <= 0) {
                this.rfReader.powerOff();
                this.rfReader.close();
                return -2;
            }
            return 0;
        }
        int r = this.icReader.open(this.defaultReaderNo, null);
        if (r < 0) {
            return -2;
        }
        r = this.icReader.powerOn(this.defaultReaderNo, data);
        if (r <= 0) {
            this.icReader.powerOff(this.defaultReaderNo);
            this.icReader.close();
            return -2;
        }
        return 0;
    }

    private void closeDevice(int r) {
        if (r == 0) {
            this.rfReader.powerOff();
            this.rfReader.close();
        } else {
            this.icReader.powerOff(this.defaultReaderNo);
            this.icReader.close();
        }
    }

    public int writeCard(ReadCard rc, WriCard wc) {
        int r = this.prelude();
        if (r < 0) {
            return r;
        }
        this.blueRW.icReader = this.icReader;
        this.blueRW.rfReader = this.rfReader;
        this.blueRW.defaultReaderNo = this.defaultReaderNo;
        this.blueRW.isRfOrCpu = r;
        int n = this.blueRW.writeRfCard(rc, wc);
        this.closeDevice(r);
        return n;
    }

    public int clearCard(ReadCard rc, WriCard wc) {
        int r = this.prelude();
        if (r < 0) {
            return r;
        }
        this.blueRW.icReader = this.icReader;
        this.blueRW.rfReader = this.rfReader;
        this.blueRW.defaultReaderNo = this.defaultReaderNo;
        this.blueRW.isRfOrCpu = r;
        int n = this.blueRW.clearRfCard(rc, wc);
        this.closeDevice(r);
        return n;
    }
}

