package com.af.plugins.string;

import java.text.SimpleDateFormat;
import java.util.Date;
/**
 * 榆林安检手机端编号生产相关函数
 */
public class CheckNumberPlugin {
	//获取完整规则的安检单编号
	public String getFullCheckNumber(String number,String type){
		String mid="";
		if("非民用".indexOf(type)!=-1) {
            mid = "F";
        }  else if("改装".indexOf(type)!=-1){
			mid = "G";
		} else {
            mid = "M";
        }
		String last = String.format("%06d",Integer.parseInt(number));
		String head = getCurrentYear();
		return head + mid + last;
	}
	// 获取当前年份
	private String getCurrentYear(){
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        Date date = new Date();
        return sdf.format(date);
	}
	// 安检单编号+1后保存
	public String addCheckNumber(String src){
		int i = Integer.parseInt(src)+1;
		String des = String.format("%d", i);
		return des;
	}
}
