package com.af.plugins.kafka.kafka_consumer;

import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.json.JSONArray;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.concurrent.ExecutionException;

/**
 * kafka-topic管理工具
 *
 * @version 1.0
 * @author Mr.river
 */
public class TopicTools {
    private static String brokerUrl;
    private static AdminClient adminClient;
    private static Set<String> topicList;
    private static JSONArray topicConfigList;

    static {
        initConfig();
    }
    
    private static void initConfig(){
        //获取自定义配置项
        JSONObject topicConfig = readJsonFile();
        //更新broker地址
        brokerUrl = topicConfig.getString("brokerUrl");
        //获取topic集合
        topicConfigList = topicConfig.getJSONArray("topics");
        //打开topic客户端
        openClient();
    }

    private static void openClient(){
        Properties properties = new Properties();
        properties.put(CommonClientConfigs.BOOTSTRAP_SERVERS_CONFIG,brokerUrl);
        adminClient = AdminClient.create(properties);
    }

    private static void closeClient(){
        adminClient.close();
    }

    private static void createTopics(){
        Collection<NewTopic> newTopicList = new ArrayList<>();
        //遍历topic集合
        for(int i = 0 ; i < topicConfigList.length() ; i++) {
            JSONObject topic = topicConfigList.getJSONObject(i);
            //获取topic名称
            String topicName = topic.getString("logicName");
            if(!topicList.contains(topicName)){
                NewTopic newTopic = new NewTopic(topicName,3,(short) 1);
                System.out.println("重建topic["+topicName+"]中...");
                newTopicList.add(newTopic);
            }
        }
        if(newTopicList.size() > 0){
            adminClient.createTopics(newTopicList);
        } else {
            System.out.println("没有可以重建的topic");
        }
    }

    public static void deleteAllTopics() {
        adminClient.deleteTopics(topicList);
    }

    private static void deleteTopicForName(String topicName) {
        adminClient.deleteTopics(Collections.singletonList(topicName));
    }

    private static Set<String> viewTopics() throws ExecutionException, InterruptedException {
        ListTopicsResult topics = adminClient.listTopics();
        return topics.names().get();
    }

    public static void main(String[] args) throws ExecutionException, InterruptedException {
        Scanner scanner = new Scanner(System.in);
        boolean isExit = false;
        topicList = viewTopics();
        System.out.println("kafka-topic管理工具V1.0 by Mr.river");
        System.out.println("当前topic列表：" + topicList);
        System.out.println("------------------");
        System.out.println("操作菜单：");
        System.out.println("1.重建所有topic");
        System.out.println("2.查看当前topic列表");
        System.out.println("3.删除指定名称的topic");
        System.out.println("4.退出");
        System.out.println("------------------");
        do {
            int choose;
            while (true) {
                System.out.print("请选择：");
                try {
                    choose = Integer.parseInt(scanner.next());
                    break;
                } catch (Exception ignored) {
                }
            }
            switch (choose) {
                case 1:
                    createTopics();
                    System.out.println("重建所有topic------操作完成");
                    break;
                case 2:
                    System.out.println("=====================");
                    topicList = viewTopics();
                    System.out.println("当前topic列表：" + topicList);
                    break;
                case 3:
                    System.out.println("操作被禁用");
//                    System.out.print("请输入topic名称：");
//                    String name = scanner.next();
//                    deleteTopicForName(name);
//                    System.out.println("操作完成");
                    break;
                case 4:
                    isExit = true;
                    break;
                default:
                    System.out.println("未知的选项");
                    break;
            }
        } while (!isExit);
        closeClient();
    }

    /**
     * 读取topicConfig文件
     * @return JSONObject
     */
    private static JSONObject readJsonFile() {
        BufferedReader reader = null;
        StringBuilder laststr = new StringBuilder();
        try {
            InputStream input = TopicTools.class
                    .getResourceAsStream("/topicConfig.json");
            InputStreamReader inputStreamReader = new InputStreamReader(input,
                    StandardCharsets.UTF_8);
            reader = new BufferedReader(inputStreamReader);
            String tempString;
            while ((tempString = reader.readLine()) != null) {
                laststr.append(tempString);
            }
            reader.close();
            return new JSONObject(laststr.toString());
        } catch (IOException e) {
            throw new RuntimeException(e);
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}
