package com.af.plugins.kafka.kafka_consumer;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/**
 * 消费者组
 */
public class ConsumerGroup {
    //消费者线程集合
    private List<ConsumerRunnable> consumers;

    public ConsumerGroup(int consumerNum, String groupId, Properties prop, String topic, String url) {
        consumers = new ArrayList<>(consumerNum);
        for (int i = 0; i < consumerNum; ++i) {
            ConsumerRunnable consumerThread = new ConsumerRunnable(groupId,topic,prop,url);
            consumers.add(consumerThread);
        }
    }

    public void execute() {
        for (ConsumerRunnable task : consumers) {
            new Thread(task).start();
        }
    }
}
