package com.af.plugins.iot;

import com.af.plugins.DateTools;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iotplatform.client.NorthApiClient;
import com.iotplatform.client.NorthApiException;
import com.iotplatform.client.dto.*;
import com.iotplatform.client.invokeapi.SignalDelivery;
import com.iotplatform.utils.JsonUtil;
import org.apache.http.entity.ContentType;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

/**
 * 发送指令
 * @author Gear
 */
public class SignalDeliveryTools {

	/**
	 * 查询命令状态
	 */
	public static JSONArray getCommandStatus(String deviceId){
		SignalDelivery sd = new SignalDelivery();
		sd.setNorthApiClient(NorthApiClientTools.getNorthApiClient());
		QueryDeviceCommandInDTO2 qdcid = new QueryDeviceCommandInDTO2();
		qdcid.setDeviceId(deviceId);
		qdcid.setPageNo(0);
		qdcid.setPageSize(150);
		qdcid.setStartTime(DateTools.getDiffDate("DATE","-2","yyyyMMdd'T'000000'Z'"));
		QueryDeviceCommandOutDTO2 qdcod;
		try {
			qdcod = sd.queryDeviceCommand(qdcid,AuthenticationTools.getAuthToken());
		} catch (NorthApiException e) {
			throw new IOTException(e);
		}
		JSONArray result = new JSONArray();
		for(DeviceCommandRespV4 command : qdcod.getData()){
			JSONObject item = new JSONObject();
			item.put("commandId",command.getCommandId());
			item.put("status",command.getStatus());
			result.put(item);
		}
		return result;
	}


	/**
	 * 发送命令请求
	 * @param serviceId 服务ID
	 * @param method 命令名称
	 * @param deviceId 设备ID
	 * @param jo 命令参数JSON
	 * @param expireTime 等待时间
	 * @return 请求结果JSON
	 */
	public static JSONObject postCommand(String serviceId, String method, String deviceId, JSONObject jo,Integer expireTime) {
		SignalDelivery sd = new SignalDelivery();
        sd.setNorthApiClient(NorthApiClientTools.getNorthApiClient());
		PostDeviceCommandInDTO2 pdcid = new PostDeviceCommandInDTO2();
        pdcid.setDeviceId(deviceId);
		CommandDTOV4 acdo = new CommandDTOV4();
		ObjectNode paras = null;
		try {
			paras = JsonUtil.convertObject2ObjectNode(jo.toString());
		} catch (Exception e) {
			e.printStackTrace();
		}
		acdo.setServiceId(serviceId);
		acdo.setMethod(method);
		acdo.setParas(paras);
		pdcid.setCommand(acdo);
		if(expireTime != null){
			pdcid.setExpireTime(expireTime);
		}
		pdcid.setCallbackUrl(WebMeterInfo.getString("telecomCallBackUrl"));
		PostDeviceCommandOutDTO2 pdcod;
		try {
			pdcod = sd.postDeviceCommand(pdcid, WebMeterInfo.getString("telecomAPIKey"), AuthenticationTools.getAuthToken());
		} catch (NorthApiException e) {
			throw new IOTException(e);
		}
		JSONObject object = new JSONObject();
		object.put("commandId", pdcod.getCommandId());
		object.put("appId", pdcod.getAppId());
		object.put("deviceId", pdcod.getDeviceId());
		object.put("callbackUrl", pdcod.getCallbackUrl());
		object.put("status", pdcod.getStatus());
		object.put("result", pdcod.getResult());
		return object;
	}

	/**
	 * 发送命令请求（即时）
	 * @param serviceId 服务ID
	 * @param method 命令名称
	 * @param deviceId 设备ID
	 * @param jo 命令参数JSON
	 * @return 请求结果JSON
	 */
	public static JSONObject postCommand(String serviceId, String method, String deviceId, JSONObject jo){
		return postCommand(serviceId,method,deviceId,jo,0);
	}

	/**
	 * 发送透传命令请求（即时）
	 * @param method 命令名称
	 * @param deviceId 设备ID
	 * @param base64String base64编码字符串
	 * @return 请求结果JSON
	 */
	public static JSONObject postCommand(String method,String deviceId,String base64String){
		return postCommand(method,deviceId,base64String,0);
	}

	/**
	 * 发送透传命令请求
	 * @param method 命令名称
	 * @param deviceId 设备ID
	 * @param base64String base64编码字符串
	 * @param expireTime 等待时间
	 * @return 请求结果JSON
	 */
	public static JSONObject postCommand(String method,String deviceId,String base64String, Integer expireTime){
		JSONObject object = new JSONObject();
		object.put("rawData", base64String);
		return postCommand("RawData", method, deviceId, object,expireTime);
	}

	/**
	 * 发送订阅请求
	 * @param notifyType  订阅类型
	 * @param callBackUrl 回调地址
	 * @return 请求结果JSON
	 */
	public static JSONObject subscribe(NotifyType notifyType, String callBackUrl) {
		String accessToken = AuthenticationTools.getAuthToken();
		NorthApiClient northApiClient = NorthApiClientTools.getNorthApiClient();
		String regDeviceUrl = "https://" + northApiClient.getClientInfo().getPlatformIp() + ":" + northApiClient.getClientInfo().getPlatformPort() + "/iocm/app/sub/v1.2.0/subscriptions";
		Map<String, String> header = new HashMap<>(16);
		header.put("app_key", WebMeterInfo.getString("telecomAPIKey"));
		header.put("Authorization", "Bearer " + accessToken);
		JSONObject bodyParams = new JSONObject();
		bodyParams.put("notifyType", notifyType.getValue());
		bodyParams.put("callbackUrl", callBackUrl);
		try {
			return northApiClient.invokeAPI(regDeviceUrl, "POST", null, bodyParams.toString(), header, null, null, ContentType.APPLICATION_JSON, null, JSONObject.class);
		} catch (NorthApiException e) {
			throw new IOTException(e);
		}
	}

	/**
	 * 删除所有订阅
	 * @return 请求结果JSON
	 */
	public static JSONObject deleteAllSubscribe(){
		String accessToken = AuthenticationTools.getAuthToken();
		NorthApiClient northApiClient = NorthApiClientTools.getNorthApiClient();
		String regDeviceUrl = "https://" + northApiClient.getClientInfo().getPlatformIp() + ":" + northApiClient.getClientInfo().getPlatformPort() + "/iocm/app/sub/v1.2.0/subscriptions";
		Map<String, String> header = new HashMap<>(16);
		header.put("app_key", WebMeterInfo.getString("telecomAPIKey"));
		header.put("Authorization", "Bearer " + accessToken);
		try {
			return northApiClient.invokeAPI(regDeviceUrl, "DELETE", null, null, header, null, null, ContentType.APPLICATION_JSON, null, JSONObject.class);
		} catch (NorthApiException e) {
			throw new IOTException(e);
		}
	}
}
