package com.af.plugins;

import org.bouncycastle.jce.provider.BouncyCastleProvider;
import sun.misc.BASE64Decoder;

import javax.crypto.Cipher;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.*;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

/**
 * rsa加解密工具
 */
public class RSAUtil {

    /**
     * 加密
     * @param str
     * @return
     */
    public static String encrypt(String str) {
        try {
            PublicKey publicKey = getPublicKey("MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCqPvovSfXcwBbW8cKMCgwqNpsYuzF8RPAPFb7LGsnVo44JhM/xxzDyzoYtdfNmtbIuKVi9PzIsyp6rg+09gbuI6UGwBZ5DWBDBMqv5MPdOF5dCQkB2Bbr5yPfURPENypUz+pBFBg41d+BC+rwRiXELwKy7Y9caD/MtJyHydj8OUwIDAQAB");
            Security.addProvider(new org.bouncycastle.jce.provider.BouncyCastleProvider());
            final Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(Cipher.ENCRYPT_MODE, publicKey);
            byte[] text = Base64.getEncoder().encode(cipher.doFinal(str.getBytes()));
            return new String(text, StandardCharsets.UTF_8);
        }catch(RuntimeException e) {
            throw e;
        }catch(Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 解密
     * @param str
     * @return
     */
    public static String descrypt(String str) {
        try {
            PrivateKey privateKey = getPrivateKey("MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAKo++i9J9dzAFtbxwowKDCo2mxi7MXxE8A8VvssaydWjjgmEz/HHMPLOhi1182a1si4pWL0/MizKnquD7T2Bu4jpQbAFnkNYEMEyq/kw904Xl0JCQHYFuvnI99RE8Q3KlTP6kEUGDjV34EL6vBGJcQvArLtj1xoP8y0nIfJ2Pw5TAgMBAAECgYAGGB8IllMwxceLhjf6n1l0IWRH7FuHIUieoZ6k0p6rASHSgWiYNRMxfecbtX8zDAoG0QAWNi7rn40ygpR5gS1fWDAKhmnhKgQIT6wW0VmD4hraaeyP78iy8BLhlvblri2nCPIhDH5+l96v7D47ZZi3ZSOzcj89s1eS/k7/N4peEQJBAPEtGGJY+lBoCxQMhGyzuzDmgcS1Un1ZE2pt+XNCVl2b+T8fxWJH3tRRR8wOY5uvtPiK1HM/IjT0T5qwQeH8Yk0CQQC0tcv3d/bDb7bOe9QzUFDQkUSpTdPWAgMX2OVPxjdq3Sls9oA5+fGNYEy0OgyqTjde0b4iRzlD1O0OhLqPSUMfAkEAh5FIvqezdRU2/PsYSR4yoAdCdLdT+h/jGRVefhqQ/6eYUJJkWp15tTFHQX3pIe9/s6IeT/XyHYAjaxmevxAmlQJBAKSdhvQjf9KAjZKDEsa7vyJ/coCXuQUWSCMNHbcR5aGfXgE4e45UtUoIE1eKGcd6AM6LWhx3rR6xdFDpb9je8BkCQB0SpevGfOQkMk5i8xkEt9eeYP0fi8nv6eOUcK96EXbzs4jV2SAoQJ9oJegPtPROHbhIvVUmNQTbuP10Yjg59+8=");
            Security.addProvider(new org.bouncycastle.jce.provider.BouncyCastleProvider());
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(Cipher.DECRYPT_MODE, privateKey);
            byte[] text = Base64.getDecoder().decode(str.getBytes(StandardCharsets.UTF_8));
            byte[] dectyptedText = cipher.doFinal(text);
            return new String(dectyptedText, StandardCharsets.UTF_8);
        }catch(RuntimeException e) {
            throw e;
        }catch(Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 获取公钥
     * @param key
     * @return
     * @throws Exception
     */
    public static PublicKey getPublicKey(String key) throws Exception {
        X509EncodedKeySpec bobPubKeySpec = new X509EncodedKeySpec(new BASE64Decoder().decodeBuffer(key));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(bobPubKeySpec);
    }

    /**
     * 获取私钥
     * @param key
     * @return
     * @throws Exception
     */
    public static PrivateKey getPrivateKey(String key) throws Exception {
        byte[] keyBytes;
        keyBytes = (new BASE64Decoder()).decodeBuffer(key);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(keySpec);
    }


    /**
     * 公钥加密
     * @param data
     * 数据数组
     * @param key
     * base64加密公钥
     * @return
     * 加密之后的数据数组
     */
    public static byte[] encryptByPublic(byte[] data , String key)
    {
        return encrytion(data,key,0,0);
    }

    /**
     * 公钥解密
     * @param data
     * 需要解密的数据数组
     * @param key
     * base64转换的公钥字符串
     * @return
     * 解密之后的数据数组
     */
    public static byte[] decryptByPublic(byte[] data , String key)
    {

        return encrytion(data,key,1,0);
    }


    public static byte[] encryptByPrivate(byte[] data , String key)
    {
        return encrytion(data,key,0,1);

    }

    public static byte[] decryptByPrivate(byte[] data , String key)
    {
        return encrytion(data,key,1,1);
    }

    /**
     * 加解密功能集合
     * @param data
     * 需要加密（或解密）的数据
     * @param Base64key
     * 秘钥（公钥或私钥）
     * @param type
     * 加解密类型 0：加密  1：解密
     * @param flag
     * 公私钥类型 0：公钥  1：私钥
     * @return
     */
    public static byte[] encrytion(byte[] data , String Base64key , int type , int flag) {
        byte[] cipherText;
        Cipher cipher;
        Key key;
        int keySize;
        try {
            cipher = Cipher.getInstance("RSA");
            KeyFactory kf = KeyFactory.getInstance("RSA");
            if (flag == 0) {
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(Base64key.getBytes(StandardCharsets.UTF_8)));
                key = kf.generatePublic(keySpec);
                keySize = ((RSAPublicKey)key).getModulus().bitLength();
            } else {
                PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(Base64key.getBytes(StandardCharsets.UTF_8)));
                key = kf.generatePrivate(keySpec);
                keySize = ((RSAPrivateKey)key).getModulus().bitLength();
            }
            cipher.init(type + Cipher.ENCRYPT_MODE, key);
            cipherText = doEncryption(cipher,type + Cipher.ENCRYPT_MODE,data,keySize);
            return cipherText;
        } catch (Exception e) {

            return null;
        }
    }

    private static byte[] doEncryption(Cipher cipher,int type, byte[] datas,int keySize){
        int maxBlock;
        byte[] resultDatas;
        if(type == Cipher.DECRYPT_MODE){
            maxBlock = keySize / 8;
        }else{
            maxBlock = keySize / 8 - 11;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            byte[] buff;
            int i = 0;

            while (datas.length > offSet) {
                if (datas.length - offSet > maxBlock) {
                    buff = cipher.doFinal(datas, offSet, maxBlock);
                } else {
                    buff = cipher.doFinal(datas, offSet, datas.length - offSet);
                }
                out.write(buff, 0, buff.length);
                i++;
                offSet = i * maxBlock;

            }
            resultDatas = out.toByteArray();
            out.close();
            return resultDatas;
        }catch(Exception e){
            return null;
        }
    }

}
