package com.aote.plugins;

import com.aote.entity.EntityServer;
import com.aote.logic.LogicServer;
import com.aote.sql.SqlServer;
import com.aote.util.ResourceHelper;
import com.aote.util.StringHelper;
import org.apache.log4j.Logger;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 编号产生器
 */
@Component
public class ServiceNoGenerator {
	static Logger log = Logger.getLogger(LogicServer.class);

	@Autowired
	private EntityServer entityServer;

	@Autowired
	private SqlServer sqlServer;

	/**
	 * 新的编号产生器，所有编号从1开始
	 * @param key 编号主键
	 * @param len 产生的编号长度，不够前面补0。len=0，则不需要补前缀0
	 * @return 产生的编号
	 * @throws Exception 异常
	 */
	public String getNo(String key, int len) throws Exception {
		long value = 0;
		int id = -1;
		// 如果编号键存在, 获取编号键
		String sql = "select id, f_key, f_value from t_sequence where f_key='" + key + "'";
		log.debug(sql);
		JSONArray array = sqlServer.query(sql);
		if (array.length() > 0) {
			value = array.getJSONObject(0).getLong("f_value");
			id = array.getJSONObject(0).getInt("id");
		}
		// 编号+1
		value++;
		// 保存结果
		if (id == -1) {
			entityServer.save("t_sequence", "{data: {f_key: '" + key + "', f_value: " + value + "}}");
		} else {
			entityServer.save("t_sequence", "{data: {id: " + id + ", f_key: '" + key + "', f_value: " + value + "}}");
		}

		String result = value + "";
		int resultLen = result.length();
		// 如果有长度限制，前面补0
		if (len != 0 && resultLen < len) {
			result = StringHelper.repeate('0', len - resultLen) + result;
		}
		// 否则，直接返回
		return result;
	}

	public static String getNo(SqlServer sql, String key, String number) {
		//key 传入工单编号规则 日期截止  eg：BXC0525     number：日期后边需要多少位编号
		Session session = sql.getSessionFactory().getCurrentSession();
		SQLQuery sq = session
				.createSQLQuery("select count(*) c from t_serviceworkorder where f_service_id like :id");
		// 保证取到的单号连续
		synchronized (ServiceNoGenerator.class) {
			Object obj = sq.addScalar("c").setParameter("id", key + "%")
					.uniqueResult();
			key += String.format("%"+number+"s", (Integer.parseInt(obj.toString()) + 1) + "")
					.replace(" ", "0");
			key = key.substring(key.length()-Integer.parseInt(number));
		}
		return key;
	}
}
