package com.af.plugins.onenet;

import com.af.plugins.RestTools;
import com.af.plugins.iot.WebMeterInfo;
import org.apache.http.conn.HttpHostConnectException;
import org.json.JSONObject;

/**
 * Onenet API调用工具类
 * @author Mr.river
 */
public class OnenetRestTools extends RestTools {
    /**
     * 创建设备
     * @param params 请求参数
     * @param imei imei码
     * @param imsi imsi码
     * @return 响应结果
     */
    public static JSONObject createDevice(JSONObject params, String imei, String imsi) {
        //指定请求路径
        String path = WebMeterInfo.getString("onenetApplicationUrl") + "/devices";
        //设置请求头
        JSONObject headers = new JSONObject();
        headers.put("api-key", WebMeterInfo.getString("onenetAPIKey"));
        //设置imei和imsi
        JSONObject auth_info = new JSONObject();
        auth_info.put(imei, imsi);
        params.put("auth_info", auth_info);
        //发送请求
        int count = 1;
        while (true){
            try {
                return new JSONObject(post(path, params, headers));
            } catch (RuntimeException e) {
                if (e.getCause() instanceof HttpHostConnectException) {
                    count++;
                    if(count >= 3){
                        throw e;
                    }
                }
            }
        }
    }

    /**
     * 获取设备信息
     * @param device_id 设备ID
     * @return 响应结果
     */
    public static JSONObject getDevice(String device_id) {
        //指定请求路径
        String path = WebMeterInfo.getString("onenetApplicationUrl") + "/devices/" + device_id;
        //设置请求头
        JSONObject headers = new JSONObject();
        headers.put("api-key", WebMeterInfo.getString("onenetAPIKey"));
        //发送请求
        int count = 1;
        while (true){
            try {
                return new JSONObject(getJson(path, headers));
            } catch (RuntimeException e) {
                if (e.getCause() instanceof HttpHostConnectException) {
                    count++;
                    if(count >= 3){
                        throw e;
                    }
                }
            }
        }
    }

    /**
     * 删除设备
     * @param device_id 设备ID
     * @return 响应结果
     */
    public static JSONObject deleteDevice(String device_id) {
        //指定请求路径
        String path = WebMeterInfo.getString("onenetApplicationUrl") + "/devices/" + device_id;
        //设置请求头
        JSONObject headers = new JSONObject();
        headers.put("api-key", WebMeterInfo.getString("onenetAPIKey"));
        //发送请求
        int count = 1;
        while (true){
            try {
                return new JSONObject(delete(path,null, headers));
            } catch (RuntimeException e) {
                if (e.getCause() instanceof HttpHostConnectException) {
                    count++;
                    if(count >= 3){
                        throw e;
                    }
                }
            }
        }
    }

    /**
     * 读取设备资源
     * @param imei 设备imei
     * @param timeout 超时时间，默认25秒
     * @return 响应结果
     */
    public static JSONObject readDeviceRes(String imei, String timeout) {
        JSONObject params = new JSONObject();
        params.put("imei", imei);
        params.put("obj_id", WebMeterInfo.getString("onenetObjectID"));
        params.put("obj_inst_id", WebMeterInfo.getString("f_gasproperties"));
        params.put("res_id", WebMeterInfo.getString("onenetResID"));
        params.put("timeout", timeout == null ? "25" : timeout);
        //指定请求路径
        String path = formatURL(WebMeterInfo.getString("onenetApplicationUrl") + "/nbiot", params);
        //设置请求头
        JSONObject headers = new JSONObject();
        headers.put("api-key", WebMeterInfo.getString("onenetAPIKey"));
        //发送请求
        int count = 1;
        while (true){
            try {
                return new JSONObject(getJson(path, headers));
            } catch (RuntimeException e) {
                if (e.getCause() instanceof HttpHostConnectException) {
                    count++;
                    if(count >= 3){
                        throw e;
                    }
                }
            }
        }
    }

    /**
     * 写入设备资源
     * @param imei 设备imei
     * @param mode 写入模式（1或2）
     * @param timeout 超时时间，默认25秒
     * @param content 请求内容(实际请求参数)
     * @return 响应结果
     */
    public static JSONObject writeDeviceRes(String imei, String mode, String timeout, JSONObject content) {
        JSONObject params = new JSONObject();
        params.put("imei", imei);
        params.put("obj_id", WebMeterInfo.getString("onenetObjectID"));
        params.put("obj_inst_id", WebMeterInfo.getString("onenetObjectInstID"));
        params.put("mode", mode == null ? 1 : mode);
        params.put("timeout", timeout == null ? "25" : timeout);
        //指定请求路径
        String path = formatURL(WebMeterInfo.getString("onenetApplicationUrl") + "/nbiot", params);
        //设置请求头
        JSONObject headers = new JSONObject();
        headers.put("api-key", WebMeterInfo.getString("onenetAPIKey"));
        //发送请求
        int count = 1;
        while (true){
            try {
                return new JSONObject(post(path, content, headers));
            } catch (RuntimeException e) {
                if (e.getCause() instanceof HttpHostConnectException) {
                    count++;
                    if(count >= 3){
                        throw e;
                    }
                }
            }
        }
    }

    /**
     * 命令下发
     * @param imei 设备imei
     * @param timeout 超时时间，默认25秒
     * @param content 请求内容(实际请求参数)
     * @return 响应结果
     */
    public static JSONObject sendCommand(String imei, String timeout, JSONObject content) {
        JSONObject params = new JSONObject();
        params.put("imei", imei);
        params.put("obj_id", WebMeterInfo.getString("onenetObjectID"));
        params.put("obj_inst_id", WebMeterInfo.getString("onenetObjectInstID"));
        params.put("res_id", WebMeterInfo.getString("onenetResID"));
        params.put("timeout", timeout == null ? "25" : timeout);
        //指定请求路径
        String path = formatURL(WebMeterInfo.getString("onenetApplicationUrl") + "/nbiot/execute", params);
        //设置请求头
        JSONObject headers = new JSONObject();
        headers.put("api-key", WebMeterInfo.getString("onenetAPIKey"));
        //发送请求
        int count = 1;
        while (true){
            try {
                return new JSONObject(post(path, content, headers));
            } catch (RuntimeException e) {
                if (e.getCause() instanceof HttpHostConnectException) {
                    count++;
                    if(count >= 3){
                        throw e;
                    }
                }
            }
        }
    }

    /**
     * 获取资源列表
     * @param params 请求参数
     * @return 响应结果
     */
    public static JSONObject getResources(JSONObject params) {
        //指定请求路径
        String path = formatURL(WebMeterInfo.getString("onenetApplicationUrl") + "/nbiot/resources", params);
        //设置请求头
        JSONObject headers = new JSONObject();
        headers.put("api-key", WebMeterInfo.getString("onenetAPIKey"));
        //发送请求
        int count = 1;
        while (true){
            try {
                return new JSONObject(getJson(path, headers));
            } catch (RuntimeException e) {
                if (e.getCause() instanceof HttpHostConnectException) {
                    count++;
                    if(count >= 3){
                        throw e;
                    }
                }
            }
        }
    }

    /**
     * 订阅
     * @param params 请求参数
     * @return 响应结果
     */
    public static JSONObject subscribe(JSONObject params) {
        //指定请求路径
        String path = formatURL(WebMeterInfo.getString("onenetApplicationUrl") + "/nbiot/observe", params);
        //设置请求头
        JSONObject headers = new JSONObject();
        headers.put("api-key", WebMeterInfo.getString("onenetAPIKey"));
        //发送请求
        int count = 1;
        while (true){
            try {
                return new JSONObject(post(path, null,headers));
            } catch (RuntimeException e) {
                if (e.getCause() instanceof HttpHostConnectException) {
                    count++;
                    if(count >= 3){
                        throw e;
                    }
                }
            }
        }
    }
}
