package com.af.plugins.iot;

import com.af.plugins.sms.PropertiesReaderPlugin;
import com.aote.module.ModuleMapper;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * 物联网表模块配置映射
 * moduleName用于获取参数时指定模块（线程安全）
 */
public class WebMeterInfo {
    private static Map<String, JSONObject> propertiesMap;
    private static ThreadLocal<String> moduleName;

    static {
        moduleName = new ThreadLocal<>();
        propertiesMap = new HashMap<>();
        // 获取所有引入的模块
        Map<String, Map<String, String>> map = ModuleMapper.getMap();
        for(String moduleName : map.keySet()) {
            //获取物联网表模块配置文件
            String config = PropertiesReaderPlugin.readWebMeter(null, moduleName, null);
            if (config != null) {
                JSONObject params = new JSONObject(config);
                propertiesMap.put(moduleName,params);
            }
        }
    }

    public static Map<String,JSONObject> getPropertiesMap(){
        return propertiesMap;
    }

    public static String getString(String key){
        return propertiesMap.get(moduleName.get()).getString(key);
    }

    public static String getString(String key,JSONObject params){
        String valueStr = propertiesMap.get(getModuleName()).getString(key);
        Set<String> set =  params.keySet();
        for (String paramStr : set) {
            String replaceString = "\\{"+paramStr+"}";
            //如果传入的参数JSON中含有该参数的值，则直接替换{}内容
            if(!"null".equals(params.getString(paramStr))) {
                valueStr = valueStr.replaceAll(replaceString, params.getString(paramStr));
            }else {
                try{
                    //如果配置文件本身有该参数的值，则拿配置文件中该参数对应的值替换{}内容
                    valueStr = valueStr.replaceAll(replaceString,getString(paramStr));
                } catch (JSONException e) {
                    valueStr = valueStr.replaceAll(replaceString, "null");
                }
            }
        }
        return valueStr;
    }

    public static void setModuleName(String name){
        if(propertiesMap.containsKey(name)) {
            moduleName.set(name);
        } else {
            throw new IOTException(IOTExceptionCode.MODULE_NOT_FIND_FAIL);
        }
    }

    public static String getModuleName() {
        return moduleName.get();
    }

    public static void removeModuleName(){
        moduleName.remove();
    }
}
