package com.af.plugins.iot;

import com.huawei.iotplatform.client.NorthApiException;
import com.huawei.iotplatform.client.dto.ModifyDeviceInfoInDTO;
import com.huawei.iotplatform.client.dto.QueryDeviceStatusOutDTO;
import com.huawei.iotplatform.client.dto.RegDirectDeviceInDTO;
import com.huawei.iotplatform.client.dto.RegDirectDeviceOutDTO;
import com.huawei.iotplatform.client.invokeapi.DeviceManagement;

/**
 * 注册设备
 * @author Gear
 */
public class DeviceManagementTools {
	/**
	 * 注册设备
	 * @param nodeId 模组号，即IMEI
	 * @return device_id
	 */
    public String regDevice(String nodeId) {
		DeviceManagement dm = new DeviceManagement(NorthApiClientTools.getNorthApiClient());
		RegDirectDeviceInDTO rddid = new RegDirectDeviceInDTO();
		//15位IMEI号
        rddid.setNodeId(nodeId);
        rddid.setVerifyCode(nodeId);
        rddid.setTimeout(0);
        RegDirectDeviceOutDTO rddod;
        try {
            String authToken = AuthenticationTools.getAuthToken();
            rddod = dm.regDirectDevice(rddid, WebMeterInfo.getString("telecomAPIKey"), authToken);
        } catch (NorthApiException e) {
            throw new IOTException(e);
        }
        return rddod.getDeviceId();
	}

	/**
	 * 修改设备信息
	 * @param deviceId device_id，设备ID
	 * @param name 设备名
	 * @return 执行结果
	 */
	public int modifyDeviceInfo(String deviceId, String name) {
		DeviceManagement dm = new DeviceManagement(NorthApiClientTools.getNorthApiClient());
	 	ModifyDeviceInfoInDTO mdiid = new ModifyDeviceInfoInDTO();
        mdiid.setName(name);
        mdiid.setDeviceId(deviceId);
		mdiid.setManufacturerId(WebMeterInfo.getString("manuFacturerId"));
		mdiid.setManufacturerName(WebMeterInfo.getString("manuFacturerName"));
		mdiid.setDeviceType(WebMeterInfo.getString("deviceType"));
		mdiid.setModel(WebMeterInfo.getString("meterModel"));
        mdiid.setProtocolType("CoAP");
        try {
			dm.modifyDeviceInfo(mdiid, WebMeterInfo.getString("telecomAPIKey"), AuthenticationTools.getAuthToken());
			return 0;
		} catch (NorthApiException e) {
            throw new IOTException(e);
		}
	}

	/**
	 * 注销设备
	 * @param device_id device_id，设备ID
	 * @return 执行结果
	 */
	public int cancelDevice(String device_id){
		DeviceManagement dm = new DeviceManagement(NorthApiClientTools.getNorthApiClient());
		try {
			String authToken = AuthenticationTools.getAuthToken();
			dm.deleteDirectDevice(device_id, WebMeterInfo.getString("telecomAPIKey"), authToken);
			return 0;
		} catch (NorthApiException e) {
			throw new IOTException(e);
		}
	}
	
	public int queryDeviceStatus(String deviceId) {
		DeviceManagement dm = new DeviceManagement(NorthApiClientTools.getNorthApiClient());
		try {
			QueryDeviceStatusOutDTO qdsod = dm.queryDeviceStatus(deviceId, WebMeterInfo.getString("telecomAPIKey"), AuthenticationTools.getAuthToken());
            return 0;
		} catch (NorthApiException e) {
            throw new IOTException(e);
		}
	}
}













