package com.af.plugins.iot;

import com.huawei.iotplatform.client.NorthApiException;
import com.huawei.iotplatform.client.dto.AuthOutDTO;
import com.huawei.iotplatform.client.invokeapi.Authentication;

/**
 * 鉴权(线程安全)
 * @author Gear
 */
public class AuthenticationTools {
	private static ThreadLocal<Long> stamp = new ThreadLocal<>();
	private static ThreadLocal<AuthOutDTO> aod = new ThreadLocal<>();

	static {
		stamp.set(System.currentTimeMillis());
	}
	public static String getAuthToken(){
		long current = System.currentTimeMillis();
		if(aod.get() != null && (current - stamp.get()) < (1000 * 60 * 15)) {
	    	return aod.get().getAccessToken();
		}else {
			try {
				Authentication auth = new Authentication(NorthApiClientTools.getNorthApiClient());
				aod.set(auth.getAuthToken());
				stamp.set(System.currentTimeMillis());
				return aod.get().getAccessToken();
			} catch (NorthApiException e) {
				throw new IOTException(IOTExceptionCode.AUTHENTICATION_FAIL);
			}
		}
	}

	public static void logout(){
		stamp.remove();
		aod.remove();
	}
}
