package com.af.plugins.android;

import java.io.File;
import java.io.FileInputStream;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

// 模拟Android端文件上传
public class UploadPlugin {
    public String upload(String urlWithPicId, String fileName) {
        try {
            HttpClient httpClient = new DefaultHttpClient();
            HttpContext httpContext = new BasicHttpContext();
            HttpPost httpPost = new HttpPost(urlWithPicId);
            // 加载文件
            File f = new File(fileName);
            byte[] b = new byte[(int) f.length()];
            FileInputStream r = new FileInputStream(f);
            r.read(b, 0, b.length);
            r.close();
            // 上传文件数据
            ByteArrayEntity entity = new ByteArrayEntity(b);
            httpPost.setEntity(entity);
            HttpResponse response = httpClient.execute(httpPost, httpContext);
            if (response.getStatusLine().getStatusCode() != 200) {
                return null;
            }
            String result = EntityUtils.toString(response.getEntity(), "UTF8");
            return result;
        } catch (Exception e) {
            return null;
        }
    }
}
