package com.af.plugins;

import org.json.JSONObject;

import com.aote.rs.ManagerService;

/**
 * 对url进行映射，获取各url对应的转发地址
 * @author 何宁社 
 *
 */
public class UrlTools {
	private static JSONObject config;

	/**
	 * 获取反向代理服务的地址
	 * @param url  地址
	 * @return 反向代理服务的地址
	 */
	public static synchronized String getUrl(String url) {
		if (config == null) {
            loadConfig();
        }
		String result = config.getString("proxy");
		return result + url;
	}

	private static void loadConfig() {
		try {
			ManagerService ms = new ManagerService();
			String result = ms.getConfig();
			config = new JSONObject(result);
		} catch (RuntimeException e) {
			throw e;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
}
