package com.af.plugins;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.*;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 查找Tomcat上特定日期的日志
 */
public class LogParser {

    /**
     * 查找日志并且转String
     *
     * @param keyfile 日志文件名关键字
     * @param logpath 日志地址
     */
    public static List<File> SelectLogName(String logpath, String keyfile) throws UnsupportedEncodingException {
        //寻找日志文件

        Date d = new Date();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        String date = sf.format(d);
        List<File> logFile = getFileList(logpath, date, keyfile);
        return logFile;
    }

    //判断source中是否含有关键字keys，关键字按逗号分割。如果source中包含
    //给定的所有关键字，返回真。否则，返回false。
    public static boolean contains(String source, String keys, boolean flag) throws UnsupportedEncodingException {
        String[] s = keys.split(",");
        //寻找日志文件名
        if (!flag) {
            //只要有不包含的，就返回false
            if (source.contains(s[0]) && source.contains(s[1])) {
                return true;
            } else {
                return false;
            }
        }
        //寻找指定时间段及关键字的日志
        else {
            //前两次判断时间段是否符合
            String date = source.substring(0, 19);
            int startresult = date.compareTo(s[0]);
            int endresult = date.compareTo(s[1]);
            if (startresult > -1 && endresult < 1) {         //判断是否在时间段内
                if (s.length > 2) {                                  //判断是否需要进行关键字判断
                    for (int i = 2; i < s.length; i++) {   //循环查找关键字
                        //包含关键字返回true
                        if (source.contains(s[i])) return true;
                        else return false;
                    }
                } else return true;
            }
        }
        return false;
    }

    /**
     * 处理一个日志文件，从日志文件里找到含所有关键字的行，写到目标文件中。
     *
     * @param logpath   日志路径
     * @param keyfile   日志文件名关键字
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @param keys      关键字
     */
    public static JSONArray ProcessOneFile(String logpath, String keyfile, String startDate, String endDate, String keys) throws IOException {
        List<File> logFile = SelectLogName(logpath, keyfile);
        //移除最后的空格
        keys = keys.trim();
        startDate = startDate.trim();
        endDate = endDate.trim();
        keys = startDate + "," + endDate + "," + keys;

        JSONArray ja = new JSONArray();
        boolean flag = true;
        //寻找日志文件
        for (File f : logFile) {
            //new一个BufferedReader对象，将文件内容读取到缓存
            StringBuilder result = new StringBuilder();
            BufferedReader bReader = new BufferedReader(new FileReader(f));
            //从日志文件里读一行
            String str = bReader.readLine();
            while (str != null) {
                if (str.equals("")) {
                    str = bReader.readLine();
                    continue;
                }
                //判断是否包含关键词
                if (contains(str, keys, flag)) {
                    result.append(str).append("\n");
                }
                str = bReader.readLine();
            }
            bReader.close();
            //如果查询结果不为空，组织json数据
            if (!result.equals("")) {
                JSONObject item = new JSONObject();
                item.put("filename", f.getName());
                item.put("logstr", result.toString());
                ja.put(item);
            }
        }
        return ja;
    }

    //pid分类
    public static JSONArray PidSort(String logpath, String keyfile, String startDate, String endDate, String keys) throws IOException {
        List<File> logFile = SelectLogName(logpath, keyfile);
        //移除最后的空格
        String key = keys.trim();
        startDate = startDate.trim();
        endDate = endDate.trim();
        keys = startDate + "," + endDate;

        JSONArray ja = new JSONArray();
        boolean flag = true;
        //寻找日志文件
        for (File f : logFile) {
            InputStreamReader isr = new InputStreamReader(new FileInputStream(f), "GBK");
            //new一个BufferedReader对象，将文件内容读取到缓存
            BufferedReader bReader = new BufferedReader(isr, 5 * 1024 * 1024);
            //从日志文件里读一行
            String str = bReader.readLine();
            while (str != null) {
                str = new String(str.getBytes("UTF-8"), "UTF-8");
                if (contains(str, keys, flag)) {
                    StringBuilder result = new StringBuilder();
                    String[] s = str.split("-", 5);
                    String pid = s[3].trim();
                    int t = 0;
                    //循环比对pid是否重复
                    for (int i = 0; i < ja.length(); i++) {
                        JSONObject jo = (JSONObject) ja.get(i);
                        if (jo.get("filename").equals(f.getName()) && jo.get("pid").equals(pid)) {
                            String logstr = (String) jo.get("logstr");
                            logstr = logstr + result.append(str).append("\n").toString();
                            jo.put("logstr", logstr);
                            ja.put(i, jo);
                        } else {
                            t++;
                        }
                    }
                    //无匹配的pid，新增pid到数组中
                    if (t == ja.length()) {
                        JSONObject item = new JSONObject();
                        item.put("filename", f.getName());
                        item.put("pid", pid);
                        item.put("logstr", result.append(str).append("\n").toString());
                        ja.put(item);
                    }
                }
                str = bReader.readLine();
            }
            bReader.close();
        }
        return getPidKey(ja, key);
    }

    //寻找pid分类中的关键字
    public static JSONArray getPidKey(JSONArray ja, String key) throws UnsupportedEncodingException {
        JSONArray result = new JSONArray();
        ArrayList<String> strarray = new ArrayList<String>();
        JSONArray keyresult = new JSONArray();
        //遍历数组
        for (int i = 0; i < ja.length(); i++) {
            JSONObject jo = new JSONObject();
            jo = (JSONObject) ja.get(i);
            String str = (String) jo.get("logstr");
            //接收字段处理
            int index = str.indexOf("接收发送的消息");
            if (index == -1) {
                continue;
            }
            int startindex = str.substring(0, index).lastIndexOf("\n");
            if (startindex == -1) {
                startindex = 0;
            } else {
                startindex = startindex + 1;
            }
            int lastindex = str.lastIndexOf("发送的消息内容");
            if (lastindex == -1) {
                continue;
            }
            int endindex = str.indexOf("\n", lastindex);
            if (endindex == -1) {
                endindex = 0;
            } else {
                str = str.substring(startindex, endindex + 1);
                int l = 0;
                int si = 0;
                for (; ; ) {
                    int index1 = str.indexOf("接收发送的消息", l);
                    int index2 = str.indexOf("接收发送的消息", index1 + 2);
                    if (index1 == -1) {
                        break;
                    }
                    if (index2 == -1) {
                        int index3 = str.indexOf("发送的消息内容", index1);
                        l = str.length();
                        if (index3 != -1) {
                            index2 = str.indexOf("\n", index3) + 1;
                        } else {
                            continue;
                        }
                    }

                    l = index2;
                    if (str.substring(index1, index2).indexOf("发送的消息内容") != -1) {
                        index1 = str.substring(0, index1).lastIndexOf("\n");
                        if (index1 == -1) {
                            index1 = 0;
                        } else {
                            index1 = index1 + 1;
                        }
                        int ls = str.substring(index1, index2).indexOf("发送的消息内容") + index1;

                        index2 = str.substring(ls, index2).indexOf("\n") + ls;
                        if (index2 == -1) {
                            index2 = 0;
                        } else {
                            index2 = index2 + 1;
                        }
                        strarray.add(str.substring(index1, index2));
                    }
                }
            }
        }
        int p = 0;
        for (String s : strarray
                ) {
            String[] st = s.split("-", 5);
            String pid = st[3].trim();
            JSONObject strobject = new JSONObject();
            strobject.put("pid", pid);
            strobject.put("logstr", s);
            strobject.put("id", p);
            result.put(strobject);
            p++;
        }
        //查找关键字
        if (key.isEmpty()) {
            keyresult = result;
        } else {
            JSONObject jos = new JSONObject();
            for (int t = 0; t < result.length(); t++) {
                jos = (JSONObject) result.get(t);
                if (jos.get("logstr").toString().contains(key)) {
                    keyresult.put(jos);
                }
            }
        }
        //pid数据归类
        JSONArray rs=new JSONArray();
        String pid=new String();
        JSONArray ls=new JSONArray();
        for (int i=0;i<keyresult.length();i++){
            JSONObject jos=new JSONObject();
            jos= (JSONObject) keyresult.get(i);
              pid= (String) jos.get("pid");
              ls.put( jos.get("logstr"));
              if(i+1<keyresult.length()){
                  JSONObject jos1=new JSONObject();
                  jos1= (JSONObject) keyresult.get(i+1);
                  if(!pid.equals(jos1.get("pid"))){
                      JSONObject js=new JSONObject();
                      js.put("pid",pid);
                      js.put("logstr",ls);
                      rs.put(js);
                      ls=new JSONArray();
                      pid= (String) jos1.get("pid");
                  }
              }
              if(i==keyresult.length()-1){
                  JSONObject js=new JSONObject();
                  js.put("pid",pid);
                  js.put("logstr",ls);
                  rs.put(js);
              }
        }
        return  delRepeatIndexid(rs);
    }

    //寻找日志文件
    public static List<File> getFileList(String strPath, String date, String keyfile) throws UnsupportedEncodingException {

        File dir = new File(strPath);
        //该文件目录下文件全部放入数组
        File[] files = dir.listFiles();
        List<File> filelist = new ArrayList<File>();
        boolean flag = false;
        if (files != null) {
            for (File file : files) {
                String fileName = file.getName();
                //判断是文件还是文件夹
                if (file.isDirectory()) {
                    //获取文件绝对路径
                    //不考虑log文件夹下不存在文件夹
                    getFileList(file.getAbsolutePath(), date, keyfile);
                    //continue;
                    //判断文件名是否以.log结尾
                }
                String keys = date + "," + keyfile;
                if (contains(fileName, keys, flag)) {
                    String strFileName = file.getAbsolutePath();
                    filelist.add(file);
                }
            }
        }
        return filelist;
    }
    //去重复pid
    public static JSONArray delRepeatIndexid(JSONArray array) {
        JSONArray arrayTemp = new JSONArray();
        int num = 0;
        for(int i = 0;i < array.length();i++){
            if(num==0){
                arrayTemp.put(array.get(i));
            }else{
                int numJ = 0;
                for(int j = 0;j < arrayTemp.length(); j++){
                    JSONObject newJsonObjectI = (JSONObject)array.get(i);
                    JSONObject newJsonObjectJ = (JSONObject)arrayTemp.get(j);
                    String index_idI = newJsonObjectI.get("pid").toString();
                    JSONArray valueI = (JSONArray) newJsonObjectI.get("logstr");
                    String index_idJ = newJsonObjectJ.get("pid").toString();
                    JSONArray valueJ = (JSONArray) newJsonObjectJ.get("logstr");
                    if(index_idI.equals(index_idJ)){
                        valueI=mergeJson(valueI,valueJ);
                        arrayTemp.remove(j);
                        JSONObject newObject = new JSONObject();
                        newObject.put("pid", index_idI);
                        newObject.put("logstr", valueI);
                        arrayTemp.put(newObject);
                        break;
                    }
                    numJ++;
                }
                if(numJ-1 == arrayTemp.length()-1){
                    arrayTemp.put(array.get(i));
                }
            }
            num++;
        }
        return arrayTemp;
    }
    //合并
    public static JSONArray mergeJson(JSONArray array,JSONArray array1){
        for (int i=0;i<array1.length();i++){
            array.put(array1.get(i));
        }
        return array;
    }
}
