package com.af.plugins;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;

/**
 * 转换数据类型插件
 */

public class ConvertTools {

	/**
	 * 字符串转整数
	 *
	 * @param str 字符串
	 * @return 整数
	 */
	public static int stringToInt(String str) {
		return Integer.parseInt(str);
	}

	/**
	 * 字符串转双精度浮点数
	 * @param str 字符串
	 * @return 双精度浮点数
	 */
	public static double stringToDouble(String str){
		return Double.parseDouble(str);
	}

	/**
	 * String转换为bigDecimal
	 * @param num 数字字符串
	 * @return bigDecimal类型
	 */
	public static BigDecimal stringToBigDecimal(String num){
		return new BigDecimal(num);
	}

	/**
	 * bigDecimal转换为String
	 * @param bigDecimal bigDecimal类型
	 * @return String 数字字符串
	 */
	public static String bigDecimalToString(BigDecimal bigDecimal){
		return bigDecimal.toString();
	}

	/**
	 * 字节数组转UTF-8编码字符串
	 * @param bytes 字节数组
	 * @return 字符串
	 * @throws UnsupportedEncodingException 异常
	 */
	public static String byteArrayToString(byte[] bytes) throws UnsupportedEncodingException {
		return byteArrayToCharsetString(bytes,"UTF-8");
	}

	/**
	 * 字节数组转为指定编码格式的字符串
	 * @param bytes 字节数组
	 * @param charset 编码格式
	 * @return 字符串
	 * @throws UnsupportedEncodingException 异常
	 */
	public static String byteArrayToCharsetString(byte[] bytes, String charset) throws UnsupportedEncodingException {
		return new String(bytes, charset);
	}

	/**
	 * 将byte数组进行Base64加密
	 *
	 * @param bytes 待加密的byte数组
	 * @return base64加密字符串
	 */
	public static String base64Encode(byte[] bytes) {
		Base64.Encoder encoder = Base64.getEncoder();
		return new String(encoder.encode(bytes), StandardCharsets.UTF_8);
	}

    /**
	 * 将base64加密的byte数组进行解密
     *
	 * @param bytes 待解密的byte数组
	 * @return base64解密后的byte数组
     */
	public static byte[] base64Decode(byte[] bytes) {
        Base64.Decoder decoder = Base64.getDecoder();
		return decoder.decode(bytes);
    }

    /**
     * byte数组转16进制字符串
     *
     * @param bytes byte数组
     * @return 16进制字符串
     */
    public static String byteToHexStr(byte[] bytes) {
		return Hex.encodeHexString(bytes);
    }

    /**
     * 16进制字符串转byte数组
     *
     * @param hexStr 16进制字符串
     * @return byte数组
	 * @throws DecoderException 异常
     */
	public static byte[] hexStrToByte(String hexStr) throws DecoderException {
		return Hex.decodeHex(hexStr.toCharArray());
    }


	/**
	 * 字符串转byte[]数组
	 * @param str
	 * @return
	 */
    public static  byte[] StrToBytes(String str){
		return  str.getBytes();
	}

    /**
     * byte[]转字符串功能
     * @param bytes
     * @return
     */
    public static  String bytesToStr(byte[] bytes){
        return  new String(bytes);
    }

	/**
	 * 指定编码格式转换字符串
	 *
	 * @param str        字符串
	 * @param oldCharset 原编码格式
	 * @param newCharset 新编码格式
	 * @return 字符串
	 */
	public static String stringToCharset(String str, Charset oldCharset, Charset newCharset) {
		if (null != str) {
			try {
				str = new String(str.getBytes(oldCharset), newCharset);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return str;
	}

	/**
	 * 十六进制转二进制字符串
	 *
	 * @param hexString 十六进制字符串
	 * @return 二进制字符串
	 */
	public static String hexStrToBinaryStr(String hexString) {
		StringBuilder bString = new StringBuilder();
		String tmp;
		for (int i = 0; i < hexString.length(); i++) {
			tmp = "0000" + Integer.toBinaryString(Integer.parseInt(hexString
					.substring(i, i + 1), 16));
			bString.append(tmp.substring(tmp.length() - 4));
		}
		return bString.toString();
	}

	public static void main(String[] args) {
		System.out.println(Arrays.toString(ConvertTools.binaryStrToBinaryArray(ConvertTools.hexStrToBinaryStr("4"), 8)));
	}

	/**
	 * 二进制转十六进制字符串
	 *
	 * @param bString 二进制字符串
	 * @return 十六进制字符串
	 */
	public static String binaryStrToHexStr(String bString) {
		StringBuilder tmp = new StringBuilder();
		int iTmp;
		for (int i = 0; i < bString.length(); i += 4) {
			iTmp = 0;
			for (int j = 0; j < 4; j++) {
				iTmp += Integer.parseInt(bString.substring(i + j, i + j + 1)) << (4 - j - 1);
			}
			tmp.append(Integer.toHexString(iTmp));
		}
		return tmp.toString();
	}

	/**
	 * 二进制字符串转数组
	 *
	 * @param binaryString 二进制字符串
	 * @return 二进制数组
	 */
	public static byte[] binaryStrToBinaryArray(String binaryString) {
		return binaryStrToBinaryArray(binaryString, 0);
	}

	/**
	 * 二进制字符串转指定长度的数组（用0填充）
	 *
	 * @param binaryString 二进制字符串
	 * @param length       返回数组长度，0即表示无填充
	 * @return 二进制数组
	 */
	public static byte[] binaryStrToBinaryArray(String binaryString, Integer length) {
		if (length == 0) {
			length = binaryString.length();
		}
		byte[] binaryArray = new byte[length];
		char[] binaryChars = binaryString.toCharArray();
		for (int i = 0; i < binaryChars.length; i++) {
			if (binaryChars[i] == '1') {
				binaryArray[i] = 1;
			} else {
				binaryArray[i] = 0;
			}
		}
		return binaryArray;
	}

	/**
	 * 向上取整
	 * @param numObj double类型参数
	 * @return 向上取整后的整数
	 */
	public static int ceil(Object numObj){
		double num = Double.parseDouble(numObj.toString());
		return (int) Math.ceil(num);
	}

	/**
	 * 向下取整
	 * @param numObj double类型参数
	 * @return 向下取整后的整数
	 */
	public static int floor(Object numObj){
		double num = Double.parseDouble(numObj.toString());
		return (int) Math.floor(num);
	}

	/**
	 * 四舍五入
	 * @param numObj double类型参数
	 * @return 四舍五入后的参数
	 */
	public static int round(Object numObj){
		BigDecimal b = new BigDecimal(numObj.toString());
		return b.setScale(0, BigDecimal.ROUND_HALF_UP).intValue();
	}

	/**
	 * 去除字符串所有空格
	 * @param str 待处理字符串
	 * @return 处理后的字符串
	 */
	public static String replaceAll(String str){
		return str.replace(" ", "");
	}

	/**
	 * 字符串转ASCII
	 * @param value 待处理字符串
	 * @param split 分隔符
	 * @return 处理后的字符串
	 */
	public static String stringToAscii(String value,String split){
		if(value == null){
			return null;
		}
		StringBuilder sbu = new StringBuilder();
		char[] chars = value.toCharArray();
		for (int i = 0; i < chars.length - 1; i++) {
			sbu.append((int)chars[i]).append(split);
		}
		sbu.append((int)chars[chars.length -1]);
		return sbu.toString();
	}

	/**
	 * ASCII转字符串
	 * @param value 待处理字符串
	 * @param split 分隔符
	 * @return 处理后的字符串
	 */
	public static String asciiToString(String value,String split){
		if(value == null){
			return null;
		}
		StringBuilder sbu = new StringBuilder();
		String[] chars = value.split(split);
		for (String aChar : chars) {
			sbu.append((char) Integer.parseInt(aChar));
		}
		return sbu.toString();
	}
}