/*
 * Decompiled with CFR 0.152.
 */
package com.af.path;

import com.af.path.ClassHelper;
import com.af.path.Delegate;
import com.af.path.Expression;
import com.af.path.StringHelper;
import com.af.path.SubQuery;
import com.af.path.TypeGarther;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.type.Type;

public class UnionSubQuery
extends SubQuery {
    private Map<Type, Integer> maxLen = new HashMap<Type, Integer>();

    public UnionSubQuery(Delegate delegate) {
        super(delegate);
    }

    @Override
    protected UnionSubQuery Clone() {
        UnionSubQuery result = new UnionSubQuery(this.delegate);
        result.copyFrom(this);
        return result;
    }

    @Override
    protected String toSubSelfSelect(String put, SubQuery parent) {
        String type = this.entity + this.ID + "_type";
        String id = this.entity + this.ID + "_" + this.getKey();
        StringBuilder result = new StringBuilder(type + "," + id);
        String append = this.toOrderSubSelect();
        StringHelper.join(result, append);
        return result.toString();
    }

    private String toSelect(SubQuery query, Type type) {
        int start;
        StringBuilder result = new StringBuilder();
        TypeGarther garther = query.getFieldByType(type);
        String append = query.toTypeSelect(type, true);
        StringHelper.join(result, append);
        for (int i = start = query.getFieldByType((Type)type).len; i < this.maxLen.get(type); ++i) {
            append = "null " + ClassHelper.getTypeString(type) + (i + garther.start);
            StringHelper.join(result, append);
        }
        return result.toString();
    }

    @Override
    protected void split(Map<String, Object> map, List<Map<String, Object>> result, SubQuery parent) {
        String type = this.entity + this.ID + "_type";
        String typeName = (String)map.get(type);
        if (typeName == null) {
            return;
        }
        for (SubQuery sub : this.children) {
            if (!sub.tableName.equals(typeName)) continue;
            sub.split(map, result, parent);
        }
    }

    @Override
    protected String toTypeSelect(Type type, boolean isSelf) {
        StringBuilder result = new StringBuilder();
        if (isSelf) {
            return "";
        }
        TypeGarther garther = this.getFieldByType(type);
        int max = this.maxLen.get(type);
        for (int i = 0; i < max; ++i) {
            String append = ClassHelper.getTypeString(type) + (i + garther.start);
            StringHelper.join(result, append);
        }
        return result.toString();
    }

    protected String toSelect(SubQuery query) {
        StringBuilder result = new StringBuilder();
        String append = "'" + query.tableName + "' " + this.entity + this.ID + "_type";
        StringHelper.join(result, append);
        String key = this.getKey();
        append = key + " " + this.entity + this.ID + "_" + key;
        StringHelper.join(result, append);
        String foreignkey = this.getForeignKey();
        append = foreignkey + " c_" + this.entity + this.ID + "_" + foreignkey;
        StringHelper.join(result, append);
        for (Type type : ClassHelper.getTypes()) {
            append = this.toSelect(query, type);
            StringHelper.join(result, append);
        }
        for (SubQuery sub : this.children) {
            if (sub.equals(query)) {
                append = sub.toSelfSelect(null);
                StringHelper.join(result, append);
                continue;
            }
            append = sub.toSelfSelect("null");
            StringHelper.join(result, append);
        }
        return result.toString();
    }

    @Override
    public List<SubQuery> split() {
        ArrayList<SubQuery> result = new ArrayList<SubQuery>();
        for (SubQuery sub : this.children) {
            List<SubQuery> queries = sub.split();
            int i = 0;
            for (SubQuery query : queries) {
                if (result.size() > i) {
                    SubQuery c = (SubQuery)result.get(i);
                    c.Add(query);
                } else {
                    UnionSubQuery newUnion = this.Clone();
                    newUnion.Add(query);
                    result.add(newUnion);
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    protected int computeFieldCol(Type type, int start) {
        int max = 0;
        for (SubQuery sub : this.children) {
            int len = sub.computeFieldCol(type, start);
            if (len <= max) continue;
            max = len;
        }
        this.maxLen.put(type, max);
        TypeGarther garther = this.getFieldByType(type);
        garther.start = start;
        garther.len = max;
        return max;
    }

    private String toOrderSubSelect() {
        StringBuilder result = new StringBuilder();
        for (Expression exp : this.orders) {
            exp.delegate.queries.push(this);
            String order = (String)exp.invoke2(this);
            exp.delegate.queries.pop();
            if (order.endsWith("_desc")) {
                String name = order.substring(0, order.length() - 5);
                StringHelper.join(result, this.entity + this.ID + "_" + name);
                continue;
            }
            StringHelper.join(result, this.entity + this.ID + "_" + order);
        }
        return result.toString();
    }

    private String toOrderSelect() {
        StringBuilder result = new StringBuilder();
        for (Expression exp : this.orders) {
            exp.delegate.queries.push(this);
            String order = (String)exp.invoke2(this);
            exp.delegate.queries.pop();
            if (order.endsWith("_desc")) {
                String name = order.substring(0, order.length() - 5);
                StringHelper.join(result, "p." + name + " " + this.entity + this.ID + "_" + name);
                continue;
            }
            StringHelper.join(result, "p." + order + " " + this.entity + this.ID + "_" + order);
        }
        return result.toString();
    }

    @Override
    protected String getSql() {
        String result = "";
        for (SubQuery sub : this.children) {
            String subSql = sub.getSql();
            if (!result.equals("")) {
                result = result + " union all ";
            }
            result = result + subSql;
        }
        String theId = this.getKey();
        StringBuilder sb = new StringBuilder("u.*");
        String select = StringHelper.join(sb, this.toOrderSelect()).toString();
        result = "select " + select + " from " + this.tableName + " p join (" + result + ") u on p." + theId + "=u." + this.entity + this.ID + "_" + theId;
        return result;
    }

    @Override
    protected void combine(List<Map<String, Object>> result, List<Map<String, Object>> list) {
        for (SubQuery sub : this.children) {
            list = this.getDataByType(list, sub.tableName);
            if ((result = this.getDataByType(result, sub.tableName)).size() > 0) {
                sub.combine(result, list);
                continue;
            }
            if (result.size() != 0) continue;
            result.addAll(list);
        }
    }

    private List<Map<String, Object>> getDataByType(List<Map<String, Object>> list, String type) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (list == null) {
            return result;
        }
        for (Map<String, Object> map : list) {
            if (!map.get("type").equals(type)) continue;
            result.add(map);
        }
        return result;
    }

    @Override
    protected String getFieldName(String field) {
        return this.entity + this.ID + "_" + field;
    }

    @Override
    public UnionSubQuery toUnionSubQuery() {
        return this;
    }

    @Override
    protected String toSelfString() {
        return "union: " + this.entity + "," + this.tableName;
    }
}

