/*
 * Decompiled with CFR 0.152.
 */
package com.af.path;

import com.af.path.ClassHelper;
import com.af.path.Delegate;
import com.af.path.Expression;
import com.af.path.ExpressionType;
import com.af.path.RootSubQuery;
import com.af.path.SqlHelper;
import com.af.path.StringHelper;
import com.af.path.SumSubQuery;
import com.af.path.TypeGarther;
import com.af.path.UnionSubQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.AssociationType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.SetType;
import org.hibernate.type.Type;

public class SubQuery {
    public Delegate delegate;
    public int ID;
    public SubQuery parent;
    public List<SubQuery> children = new ArrayList<SubQuery>();
    protected SumSubQuery arragateSub = null;
    protected SubQuery conditionSub = null;
    public String entity;
    public Type type;
    public String tableName;
    protected String foriegnKey = null;
    public boolean isUnionSubQuery = false;
    protected Map<String, Object> fields = new HashMap<String, Object>();
    protected Map<Type, TypeGarther> fieldTypes = new HashMap<Type, TypeGarther>();
    protected boolean isOutput = false;
    protected Expression exp = null;
    public List<Expression> conditions = new ArrayList<Expression>();
    public List<Expression> groups = new ArrayList<Expression>();
    public List<Expression> orders = new ArrayList<Expression>();
    public Map<String, Object> obj = null;

    public SubQuery(Delegate delegate) {
        this.delegate = delegate;
    }

    private SubQuery(String entity, Delegate delegate) {
        this.entity = entity;
        this.delegate = delegate;
        this.ID = this.delegate.IDS++;
    }

    protected SubQuery Clone() {
        SubQuery result = new SubQuery(this.delegate);
        result.copyFrom(this);
        return result;
    }

    protected void copyFrom(SubQuery other) {
        this.ID = other.ID;
        this.entity = other.entity;
        this.tableName = other.tableName;
        this.foriegnKey = other.foriegnKey;
        this.fields = other.fields;
        this.fieldTypes = other.fieldTypes;
        this.conditionSub = other.conditionSub;
        this.conditions = other.conditions;
        this.orders = other.orders;
        this.groups = other.groups;
        this.type = other.type;
        this.arragateSub = other.arragateSub;
        this.isOutput = other.isOutput;
        this.exp = other.exp;
    }

    protected void copyTo(SumSubQuery other) {
        other.entity = this.entity;
        other.tableName = this.tableName;
        other.foriegnKey = this.foriegnKey;
        other.conditionSub = this.conditionSub;
        other.conditions = this.conditions;
        other.orders = this.orders;
        other.type = this.type;
        other.isOutput = this.isOutput;
        other.exp = this.exp;
    }

    public boolean equals(SubQuery other) {
        if (other == null) {
            return false;
        }
        return this.entity.equals(other.entity) && this.ID == other.ID;
    }

    public void Add(SubQuery query) {
        this.children.add(query);
        query.parent = this;
    }

    public void setField(String key, String value) {
        if (this.fields.containsKey(key)) {
            this.fields.put(key, value);
        }
    }

    public void addField(String key, Object value, ExpressionType type) {
        if (value instanceof SubQuery) {
            SubQuery sub = (SubQuery)value;
            sub.isOutput = true;
            if (sub.isUnionSubQuery || sub instanceof UnionSubQuery) {
                for (SubQuery child : sub.children) {
                    child.isOutput = true;
                }
            }
            return;
        }
        if (type != null && type.equals((Object)ExpressionType.Identy)) {
            Type t = this.getType(key);
            TypeGarther garther = this.getFieldByType(t);
            garther.fields.add(key);
            return;
        }
        this.fields.put(key, value);
    }

    protected TypeGarther getFieldByType(Type t) {
        if (!this.fieldTypes.containsKey(t)) {
            TypeGarther garther = new TypeGarther(t);
            this.fieldTypes.put(t, garther);
        }
        return this.fieldTypes.get(t);
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    public SumSubQuery getAggragateQuery() {
        if (this.arragateSub == null) {
            this.arragateSub = new SumSubQuery(this.delegate);
            this.arragateSub.entity = this.entity;
            this.arragateSub.type = this.type;
            this.arragateSub.tableName = this.tableName;
            this.arragateSub.foriegnKey = this.foriegnKey;
            this.Add(this.arragateSub);
        }
        return this.arragateSub;
    }

    protected SubQuery createConditionSub() {
        SubQuery sub = new SubQuery(this.entity, this.delegate);
        sub.type = this.type;
        sub.tableName = this.tableName;
        sub.foriegnKey = this.foriegnKey;
        if (this.conditionSub != null) {
            this.conditionSub.parent = sub;
            sub.conditionSub = this.conditionSub;
        }
        sub.parent = this;
        this.conditionSub = sub;
        return sub;
    }

    public Type getType(String name) {
        if (this instanceof RootSubQuery) {
            return null;
        }
        Type result = ClassHelper.getType(this.tableName, name, this.delegate.session.getSessionFactory());
        return result;
    }

    protected void init() {
        this.type = this.parent.getType(this.entity);
        this.tableName = this.getTableName();
        this.foriegnKey = this.getForeignKey();
    }

    public String getAssociationName(String name) {
        if (this instanceof RootSubQuery) {
            return name;
        }
        Type type = this.getType(name);
        if (!(type instanceof AssociationType)) {
            return null;
        }
        AssociationType t = (AssociationType)type;
        SessionFactoryImplementor factory = (SessionFactoryImplementor)this.delegate.session.getSessionFactory();
        String entity = t.getAssociatedEntityName(factory);
        return entity;
    }

    public List<String> getEntities() {
        List<String> result = ClassHelper.getExtendClass(this.tableName);
        return result;
    }

    private SubQuery createSubQuery(List<String> types) {
        if ((types = this.removeCreated(types)).size() == 0) {
            return this;
        }
        SubQuery sub = this.toUnionSubQuery();
        for (String type : types) {
            SubQuery query = new SubQuery(this.entity, this.delegate);
            query.tableName = type;
            query.type = sub.type;
            query.isOutput = sub.isOutput;
            sub.Add(query);
        }
        return sub;
    }

    private boolean isCreated(String tableName) {
        SubQuery parent = this;
        while (parent != null) {
            if (parent.tableName != null && parent.tableName.equals(tableName)) {
                return true;
            }
            parent = parent.parent;
        }
        return false;
    }

    private List<String> removeCreated(List<String> tables) {
        ArrayList<String> created = new ArrayList<String>();
        for (String table : tables) {
            if (!this.isCreated(table)) continue;
            created.add(table);
        }
        tables.removeAll(created);
        return tables;
    }

    public SubQuery getSubQuery(Expression exp) {
        for (SubQuery sub : this.children) {
            if (!sub.exp.equals(exp)) continue;
            return sub;
        }
        if (this.conditionSub != null && this.conditionSub.exp.equals(exp)) {
            return this.conditionSub;
        }
        throw new RuntimeException("\u627e\u4e0d\u5230\u7ed9\u5b9a\u540d\u5b57\u7684\u5c5e\u6027\uff1a\n\u5b50\u67e5\u8be2:\n" + this + "\n\u8868\u8fbe\u5f0f:\n" + exp);
    }

    private boolean isFieldCreated(String name) {
        if (name.equals("super")) {
            return false;
        }
        String tableName = this.getTableName(name);
        return this.isCreated(tableName);
    }

    public SubQuery createSubQuery(String name, Expression exp) {
        if (this.isFieldCreated(name)) {
            return null;
        }
        SubQuery sub = new SubQuery(name, this.delegate);
        this.Add(sub);
        sub.init();
        sub.exp = exp;
        return sub;
    }

    public SubQuery createLimitSubQuery(String name, String type) {
        SubQuery query = new SubQuery(name, this.delegate);
        query.tableName = type;
        query.type = this.type;
        query.isOutput = this.isOutput;
        this.Add(query);
        return query;
    }

    public SubQuery toUnionSubQuery() {
        this.isUnionSubQuery = true;
        return this;
    }

    private SubQuery procSelfUnionSubQuery() {
        if (this.isUnionSubQuery) {
            UnionSubQuery union = new UnionSubQuery(this.delegate);
            union.copyFrom(this);
            this.parent.children.remove(this);
            this.parent.Add(union);
            for (SubQuery sub : this.children) {
                union.Add(sub);
            }
            return union;
        }
        return this;
    }

    public void procUnionSubQuery() {
        SubQuery union = this.procSelfUnionSubQuery();
        for (SubQuery sub : union.children) {
            sub.procUnionSubQuery();
        }
    }

    public void addAllFields(boolean recure) {
        List<String> types = this.getEntities();
        SubQuery sub = this.createSubQuery(types);
        List<Object> subs = new ArrayList<SubQuery>();
        if (sub.children.size() > 0) {
            subs = sub.children;
        } else {
            subs.add(sub);
        }
        for (SubQuery subQuery : subs) {
            SessionFactory factory = this.delegate.session.getSessionFactory();
            for (String field : ClassHelper.getFieldNames(subQuery.tableName, factory)) {
                Type subType = subQuery.getType(field);
                if (subType instanceof AssociationType) {
                    SubQuery child;
                    if (!recure || (child = subQuery.createSubQuery(field, null)) == null) continue;
                    subQuery.addField(null, child, null);
                    child.addAllFields(true);
                    continue;
                }
                ExpressionType type = ExpressionType.Identy;
                subQuery.addField(field, field, type);
            }
        }
    }

    private String getTableName(String entity) {
        Type type = this.getType(entity);
        SessionFactory factory = this.delegate.session.getSessionFactory();
        if (type instanceof AssociationType) {
            AssociationType set = (AssociationType)type;
            SessionFactoryImplementor sf = (SessionFactoryImplementor)factory;
            return set.getAssociatedEntityName(sf);
        }
        return null;
    }

    protected String getTableName() {
        if (this.entity.equals("super")) {
            return this.parent.tableName;
        }
        if (this.parent instanceof RootSubQuery) {
            return this.entity;
        }
        if (this instanceof SumSubQuery) {
            return this.parent.tableName;
        }
        Type type = this.type;
        SessionFactory factory = this.delegate.session.getSessionFactory();
        if (type instanceof SetType) {
            SetType set = (SetType)type;
            SessionFactoryImplementor sf = (SessionFactoryImplementor)factory;
            return set.getAssociatedEntityName(sf);
        }
        if (type instanceof ManyToOneType) {
            ManyToOneType t = (ManyToOneType)type;
            return t.getAssociatedEntityName();
        }
        if (type instanceof OneToOneType) {
            OneToOneType t = (OneToOneType)type;
            return t.getAssociatedEntityName();
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b:" + type);
    }

    public void removeNullSelect() {
        ArrayList<SubQuery> removes = new ArrayList<SubQuery>();
        for (SubQuery sub : this.children) {
            if (sub.fields.size() != 0 || sub.fieldTypes.size() != 0 || sub instanceof UnionSubQuery) continue;
            removes.add(sub);
        }
        this.children.removeAll(removes);
        for (SubQuery sub : this.children) {
            sub.removeNullSelect();
        }
    }

    public void procArragateSub() {
        ArrayList<SumSubQuery> removed = new ArrayList<SumSubQuery>();
        for (SubQuery subQuery : this.children) {
            SumSubQuery child;
            if (subQuery.children.size() == 1 && subQuery.children.get(0) instanceof SumSubQuery && subQuery.fields.size() == 0 && subQuery.fieldTypes.size() == 0) {
                child = (SumSubQuery)subQuery.children.get(0);
                subQuery.copyTo(child);
                removed.add(child);
                continue;
            }
            if (subQuery.children.size() != 1 || !(subQuery.children.get(0) instanceof SumSubQuery) || subQuery.children.get((int)0).groups.size() <= 0) continue;
            child = (SumSubQuery)subQuery.children.get(0);
            subQuery.copyTo(child);
            child.fields = subQuery.fields;
            child.fieldTypes = subQuery.fieldTypes;
            removed.add(child);
        }
        for (SubQuery subQuery : removed) {
            this.children.remove(subQuery.parent);
            this.Add(subQuery);
        }
        for (SubQuery subQuery : this.children) {
            subQuery.procArragateSub();
        }
        if (this.conditionSub != null) {
            this.conditionSub.procArragateSub();
        }
    }

    public List<SubQuery> split() {
        ArrayList<SubQuery> queries = new ArrayList<SubQuery>();
        if (this.children.size() == 0) {
            SubQuery sub = this.Clone();
            queries.add(sub);
            return queries;
        }
        for (SubQuery sub : this.children) {
            List<SubQuery> childs = sub.split();
            for (SubQuery child : childs) {
                boolean isConfict = true;
                for (SubQuery already : queries) {
                    if (SubQuery.isChildConfict(already, child)) continue;
                    isConfict = false;
                    already.Add(child);
                    break;
                }
                if (!isConfict) continue;
                SubQuery self = this.Clone();
                self.Add(child);
                queries.add(self);
            }
        }
        return queries;
    }

    private static boolean isChildConfict(SubQuery parent, SubQuery sub) {
        sub.parent = parent;
        for (SubQuery child : parent.children) {
            if (!SubQuery.isConfict(child, sub)) continue;
            return true;
        }
        return false;
    }

    private static boolean isConfict(SubQuery one, SubQuery two) {
        if (SubQuery.isOneConfict(one, two)) {
            return true;
        }
        for (SubQuery sub : one.children) {
            if (!SubQuery.isConfict(sub, two)) continue;
            return true;
        }
        return false;
    }

    private static boolean isOneConfict(SubQuery one, SubQuery two) {
        if (one.isOneToMany() && one.isOutput && two.isOneToMany() && two.isOutput) {
            return true;
        }
        for (SubQuery sub : two.children) {
            if (!SubQuery.isOneConfict(one, sub)) continue;
            return true;
        }
        return false;
    }

    public List<Map<String, Object>> execute() {
        try {
            this.comuteFieldCol();
            String sql = this.getSql();
            String order = this.toOrder();
            if (!order.equals("")) {
                sql = sql + " order by " + order;
            }
            List<Map<String, Object>> result = this.queryToList(sql);
            result = this.split(result);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<Map<String, Object>> queryToList(String sql) {
        if (this.delegate.sqlRunner != null) {
            return this.delegate.sqlRunner.queryToList(this.delegate.session, sql);
        }
        try {
            return SqlHelper.queryToList(this.delegate.session, sql);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void comuteFieldCol() {
        for (Type type : ClassHelper.getTypes()) {
            this.computeFieldCol(type, 0);
        }
    }

    protected int computeFieldCol(Type type, int start) {
        TypeGarther garther = this.getFieldByType(type);
        garther.start = start;
        int len = this.fieldTypes.get((Object)garther.type).fields.size();
        for (SubQuery sub : this.children) {
            len += sub.computeFieldCol(type, start + len);
        }
        if (this.conditionSub != null) {
            len += this.conditionSub.computeFieldCol(type, start + len);
        }
        garther.len = len;
        return len;
    }

    public String getFieldName(Expression exp) {
        for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
            if (!entry.getValue().equals(exp)) continue;
            return this.getFieldName(entry.getKey());
        }
        return null;
    }

    protected String getFieldName(String field) {
        if (this.fields.containsKey(field)) {
            return this.entity + this.ID + "_" + field;
        }
        Type type = this.getType(field);
        TypeGarther garther = this.fieldTypes.get(type);
        if (garther != null && garther.len > 0) {
            int index = garther.fields.indexOf(field);
            return ClassHelper.getTypeString(type) + (index + garther.start);
        }
        return field;
    }

    public String toGroup() {
        StringBuilder result = new StringBuilder();
        for (Expression exp : this.groups) {
            this.delegate.queries.push(this);
            String str = (String)exp.invoke2(this);
            this.delegate.queries.pop();
            if (str == null) continue;
            StringHelper.join(result, str);
        }
        return result.toString();
    }

    protected String toOrder() {
        String result = "";
        for (Expression exp : this.orders) {
            exp.delegate.queries.push(this);
            String s = (String)exp.invoke2(this);
            exp.delegate.queries.pop();
            if (s.endsWith("_desc")) {
                result = result + "," + this.getFieldName(s.substring(0, s.length() - 5)) + " desc";
                continue;
            }
            result = result + "," + this.getFieldName(s);
        }
        if (!(this.parent != null && !this.isOneToMany() || this.parent instanceof UnionSubQuery || this.groups.size() != 0 || this instanceof SumSubQuery)) {
            String idName = this.entity + this.ID + "_" + this.getKey();
            result = result + "," + idName;
        }
        for (SubQuery sub : this.children) {
            String str = sub.toOrder();
            if (str.equals("")) continue;
            result = result + "," + str;
        }
        if (result.equals("")) {
            return result;
        }
        return result.substring(1);
    }

    protected String getSql() {
        String sql = this.getSelfSql();
        String result = "";
        for (SubQuery sub : this.children) {
            String subSql = sub.getSql();
            String join = sub.toOn();
            if (sub instanceof SumSubQuery) {
                result = result + " left join (" + subSql + ") g_" + sub.entity + sub.ID + " on " + join;
                continue;
            }
            result = result + " left join (" + subSql + ") " + sub.entity + sub.ID + " on " + join;
        }
        result = sql + result + this.toWhere();
        if (this instanceof SumSubQuery) {
            String foreignkey = this.getForeignKey();
            StringBuilder builder = new StringBuilder(foreignkey);
            String append = this.toGroup();
            StringHelper.join(builder, append);
            if (builder.length() != 0) {
                result = result + " group by " + builder.toString();
            }
        }
        return result;
    }

    protected String getForeignKey() {
        if (this.foriegnKey != null) {
            return this.foriegnKey;
        }
        if (this.parent == null || this.parent instanceof RootSubQuery) {
            return null;
        }
        if (this.parent instanceof UnionSubQuery) {
            return this.parent.getForeignKey();
        }
        if (this.parent.tableName == null) {
            throw new RuntimeException(this.entity + "\u7684\u7236\u8868\u540d\u4e3a\u7a7a!");
        }
        SessionFactory factory = this.delegate.session.getSessionFactory();
        String foreignkey = ClassHelper.getForiegnKey(this.parent.tableName, this.entity, factory);
        return foreignkey;
    }

    private String getSelfSql() {
        String select = this.toSelect(null);
        String result = "select " + select + " from ";
        result = this.conditionSub != null ? result + "(" + this.conditionSub.getSql() + ") " + this.tableName : (this.parent != null && this.equals(this.parent.arragateSub) && this.parent.conditionSub != null ? result + "(" + this.parent.conditionSub.getSql() + ") " + this.tableName : result + this.tableName);
        return result;
    }

    private String toWhere() {
        String result = "";
        for (Expression exp : this.conditions) {
            exp.delegate.queries.push(this);
            String s = (String)exp.invoke2(this);
            exp.delegate.queries.pop();
            if (!result.equals("")) {
                result = result + " and ";
            }
            result = result + s;
        }
        if (!result.equals("")) {
            result = " where " + result;
        }
        return result;
    }

    private String toOn() {
        SessionFactory factory = this.delegate.session.getSessionFactory();
        String tableName = this.parent.tableName;
        ClassMetadata cm = factory.getClassMetadata(tableName);
        String foreignkey = this.getForeignKey();
        Type t = this.type;
        if (t instanceof SetType) {
            String key = cm.getIdentifierPropertyName();
            if (this instanceof SumSubQuery) {
                if (this.equals(this.parent.arragateSub)) {
                    return this.parent.tableName + "." + foreignkey + "=" + "g_" + this.entity + this.ID + ".g_" + this.entity + this.ID + "_" + foreignkey;
                }
                return this.parent.tableName + "." + key + "=" + "g_" + this.entity + this.ID + ".g_" + this.entity + this.ID + "_" + foreignkey;
            }
            return this.parent.tableName + "." + key + "=" + this.entity + this.ID + ".c_" + this.entity + this.ID + "_" + foreignkey;
        }
        if (t instanceof ManyToOneType) {
            String id = this.getKey();
            return this.parent.tableName + "." + foreignkey + "=" + this.entity + this.ID + "." + this.entity + this.ID + "_" + id;
        }
        if (t instanceof OneToOneType) {
            String id = this.getKey();
            return this.parent.tableName + "." + foreignkey + "=" + this.entity + this.ID + ".c_" + this.entity + this.ID + "_" + id;
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b!" + t);
    }

    private String toTypeSelfSelect(Type type, boolean isSelf) {
        String result = "";
        TypeGarther garther = this.getFieldByType(type);
        for (String name : garther.fields) {
            if (isSelf) {
                result = result + "," + name + " " + this.getFieldName(name);
                continue;
            }
            result = result + "," + this.getFieldName(name);
        }
        if (result.equals("")) {
            return result;
        }
        return result.substring(1);
    }

    protected String toTypeSelect(Type type, boolean isSelf) {
        StringBuilder result = new StringBuilder();
        String str = this.toTypeSelfSelect(type, isSelf);
        StringHelper.join(result, str);
        for (SubQuery query : this.children) {
            if (!query.isOutput || query instanceof SumSubQuery) continue;
            str = query.toTypeSelect(type, false);
            StringHelper.join(result, str);
        }
        return result.toString();
    }

    protected String getFieldName(SubQuery parent, String name) {
        if (this instanceof SumSubQuery) {
            String append = this.getFieldName(name);
            return append;
        }
        String append = parent.entity + parent.ID + "." + this.getFieldName(name);
        return append;
    }

    protected String toSubSelfSelect(String put, SubQuery parent) {
        StringBuilder result = new StringBuilder();
        if (!this.delegate.contains(this)) {
            for (Map.Entry<String, Object> s : this.fields.entrySet()) {
                String name = this.getFieldName(parent, s.getKey());
                if (put != null) {
                    name = put + " " + this.getFieldName(s.getKey());
                }
                StringHelper.join(result, name);
            }
        }
        if (!(this instanceof SumSubQuery) && !(this.parent instanceof UnionSubQuery)) {
            String name;
            if (put == null) {
                name = this.entity + this.ID + "_" + this.getKey();
                StringHelper.join(result, name);
            } else {
                name = put + " " + this.entity + this.ID + "_" + this.getKey();
                StringHelper.join(result, name);
            }
        }
        return result.toString();
    }

    private String toSubSelect(String put, SubQuery parent) {
        if (!this.isOutput) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        String append = this.toSubSelfSelect(put, parent);
        StringHelper.join(result, append);
        for (SubQuery sub : this.children) {
            append = sub.toSubSelect(put, parent);
            StringHelper.join(result, append);
        }
        return result.toString();
    }

    protected String getValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Expression) {
            Expression exp = (Expression)value;
            exp.delegate = this.delegate;
            exp.delegate.queries.push(this);
            String result = (String)exp.invoke2(this);
            exp.delegate.queries.pop();
            return result;
        }
        throw new RuntimeException("\u5c5e\u6027\u503c\u53ea\u80fd\u662f\u8868\u8fbe\u5f0f\u6216\u8005\u76f4\u63a5\u503c");
    }

    /*
     * WARNING - void declaration
     */
    protected String toSelfSelect(String put) {
        String append;
        StringBuilder result = new StringBuilder();
        if (!this.delegate.contains(this)) {
            for (Map.Entry entry : this.fields.entrySet()) {
                String alias = (String)entry.getKey();
                Object value = entry.getValue();
                String exp = this.getValue(value);
                if (put != null) {
                    exp = put;
                }
                String append2 = exp + " " + this.getFieldName(alias);
                StringHelper.join(result, append2);
            }
        }
        for (SubQuery subQuery : this.children) {
            append = subQuery.toSubSelect(put, subQuery);
            StringHelper.join(result, append);
        }
        if (!(this instanceof SumSubQuery) && !(this.parent instanceof UnionSubQuery)) {
            String id = this.getKey();
            String string = put;
            if (put == null) {
                String string2 = id;
            }
            if (!this.fields.containsKey(id)) {
                void var4_9;
                append = (String)var4_9 + " " + this.entity + this.ID + "_" + id;
                StringHelper.join(result, append);
            }
        }
        if (this.parent != null && !(this.parent instanceof UnionSubQuery)) {
            void var4_13;
            String foreignkey = this.getForeignKey();
            String string = put;
            if (put == null) {
                String string3 = foreignkey;
            }
            if (this instanceof SumSubQuery) {
                append = (String)var4_13 + " g_" + this.entity + this.ID + "_" + foreignkey;
                StringHelper.join(result, append);
            } else if (!(this.type instanceof ManyToOneType)) {
                append = (String)var4_13 + " c_" + this.entity + this.ID + "_" + foreignkey;
                StringHelper.join(result, append);
            }
        }
        return result.toString();
    }

    protected String toSelect(String put) {
        if (this.parent instanceof UnionSubQuery) {
            UnionSubQuery parent = (UnionSubQuery)this.parent;
            return parent.toSelect(this);
        }
        if (this.parent != null && this.parent.conditionSub == this) {
            return this.tableName + ".*";
        }
        StringBuilder result = new StringBuilder();
        String str = this.toSelfSelect(put);
        StringHelper.join(result, str);
        for (Type t : ClassHelper.getTypes()) {
            str = this.toTypeSelect(t, true);
            StringHelper.join(result, str);
        }
        return result.toString();
    }

    public boolean isOneToMany() {
        if (this.parent == null || this.parent instanceof RootSubQuery) {
            return false;
        }
        return this.type instanceof SetType;
    }

    public String getKey() {
        SessionFactory factory = this.delegate.session.getSessionFactory();
        String key = ClassHelper.getKey(this.tableName, factory);
        return key;
    }

    private List<Map<String, Object>> split(List<Map<String, Object>> list) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : list) {
            this.split(map, result, this.parent);
        }
        return result;
    }

    protected void split(Map<String, Object> map, List<Map<String, Object>> result, SubQuery parent) {
        if (this.groups.size() > 0 || this.parent == null && this instanceof SumSubQuery) {
            result.add(this.getGroupPartial(map));
            return;
        }
        String key = this.getKey();
        String idName = this.getIdName();
        List<Map<String, Object>> children = null;
        if (parent != null && this.isOneToMany()) {
            children = parent.getSet(this.entity);
        }
        if (map.get(idName) == null) {
            if (this.isOneToMany()) {
                return;
            }
            parent.obj.put(this.entity, null);
            return;
        }
        if (this.obj == null || !this.obj.get(key).equals(map.get(idName))) {
            this.obj = this.getPartial(map);
            if (parent != null) {
                if (this.isOneToMany()) {
                    children.add(this.obj);
                } else {
                    parent.obj.put(this.entity, this.obj);
                }
            } else {
                result.add(this.obj);
            }
        }
        for (SubQuery sub : this.children) {
            if (!sub.isOutput) continue;
            sub.split(map, result, this);
        }
    }

    private List<Map<String, Object>> getSet(String entity) {
        ArrayList children = (ArrayList)this.obj.get(entity);
        if (children == null) {
            children = new ArrayList();
            this.obj.put(entity, children);
        }
        return children;
    }

    private String getIdName() {
        if (this.parent instanceof UnionSubQuery) {
            return this.parent.entity + this.parent.ID + "_" + this.getKey();
        }
        return this.entity + this.ID + "_" + this.getKey();
    }

    private Map<String, Object> getGroupPartial(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
            String name = this.entity + this.ID + "_" + entry.getKey();
            result.put(entry.getKey(), map.get(name));
        }
        for (TypeGarther garther : this.fieldTypes.values()) {
            int pos = 0;
            for (String str : garther.fields) {
                String key = ClassHelper.getTypeString(garther.type) + (garther.start + pos);
                result.put(str, map.get(key));
                ++pos;
            }
        }
        return result;
    }

    protected Map<String, Object> getPartial(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String id = this.getIdName();
        Object keyValue = map.get(id);
        if (keyValue == null) {
            return null;
        }
        result.put(this.getKey(), keyValue);
        if (this.parent instanceof UnionSubQuery) {
            result.put("type", this.tableName);
        }
        for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
            String name = this.entity + this.ID + "_" + entry.getKey();
            result.put(entry.getKey(), map.get(name));
        }
        for (TypeGarther garther : this.fieldTypes.values()) {
            int pos = 0;
            for (String str : garther.fields) {
                String key = ClassHelper.getTypeString(garther.type) + (garther.start + pos);
                result.put(str, map.get(key));
                ++pos;
            }
        }
        return result;
    }

    protected void combine(List<Map<String, Object>> result, List<Map<String, Object>> list) {
        Iterator<Map<String, Object>> resultIterator = result.iterator();
        Iterator<Map<String, Object>> listIterator = list.iterator();
        while (resultIterator.hasNext()) {
            Map<String, Object> resultObj = resultIterator.next();
            Map<String, Object> listObj = listIterator.next();
            for (SubQuery sub : this.children) {
                if (sub instanceof SumSubQuery) continue;
                if (resultObj.containsKey(sub.entity)) {
                    sub.combine((List)resultObj.get(sub.entity), (List)listObj.get(sub.entity));
                    continue;
                }
                resultObj.put(sub.entity, listObj.get(sub.entity));
            }
        }
    }

    public String toString() {
        return this.toString(0);
    }

    private String toString(int level) {
        String result = this.space(level) + this.toSelfString() + "[\n";
        for (SubQuery sub : this.children) {
            result = result + sub.toString(level + 1);
        }
        if (this.conditionSub != null) {
            result = result + this.space(level + 1) + "condition:" + "\n";
            result = result + this.conditionSub.toString(level + 1);
        }
        result = result + this.space(level) + "]\n";
        return result;
    }

    protected String toSelfString() {
        String isUnion = this.isUnionSubQuery ? "union: " : "";
        String isSum = this instanceof SumSubQuery ? "sum: " : "";
        return isSum + isUnion + this.entity + this.ID + "," + this.tableName + " conds: " + this.conditions.size() + " groups: " + this.groups.size() + " orders: " + this.orders.size() + " fiels: " + this.fields.size() + " types: " + this.fieldTypes.size();
    }

    private String space(int level) {
        String result = "";
        for (int i = 0; i < level; ++i) {
            result = result + "    ";
        }
        return result;
    }
}

