/*
 * Decompiled with CFR 0.152.
 */
package com.af.path;

import com.af.path.Delegate;
import com.af.path.Expression;
import com.af.path.ExpressionType;
import com.af.path.Token;
import com.af.path.TokenType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class Program {
    public String Source;
    private Stack<Token> _tokens = new Stack();
    private int pos;
    private boolean inString;
    private Stack<Boolean> inStrings = new Stack();

    public Program(String source) {
        String str;
        this.Source = str = source.replaceAll("--[^\n]*", "");
    }

    public Delegate parse() {
        Expression result = this.Logic();
        Delegate delegate = result.Compile();
        return delegate;
    }

    private List<Expression> AttrList() {
        ArrayList<Expression> result = new ArrayList<Expression>();
        Token t = this.GetToken();
        if (t.Type != TokenType.Oper || !t.Value.equals("(")) {
            throw new RuntimeException(this.GetExceptionMessage("\u5c5e\u6027\u5217\u8868\u5fc5\u987b\u4ee5'('\u5f00\u59cb" + t));
        }
        Expression expression = this.Alias();
        result.add(expression);
        t = this.GetToken();
        while (t.Type == TokenType.Oper && t.Value.equals(",")) {
            expression = this.Alias();
            result.add(expression);
            t = this.GetToken();
        }
        if (t.Type != TokenType.Oper || !t.Value.equals(")")) {
            throw new RuntimeException(this.GetExceptionMessage("\u5c5e\u6027\u5217\u8868\u5fc5\u987b\u4ee5')'\u7ed3\u675f" + t));
        }
        return result;
    }

    private Expression Alias() {
        Expression typeList = this.TypeLimit();
        if (typeList != null) {
            return typeList;
        }
        Token token = this.GetToken();
        this._tokens.push(token);
        if (token.Type == TokenType.Identy && token.Value.equals("group")) {
            return this.Group();
        }
        Expression exp = this.Logic();
        Token t = this.GetToken();
        if (t.Type == TokenType.Identy) {
            String name = (String)t.Value;
            return Expression.Alias(exp, name, this.Source, this.pos);
        }
        this._tokens.push(t);
        if (exp.type == ExpressionType.Method && (exp.value.equals("order") || exp.value.equals("group"))) {
            return Expression.Alias(exp, (String)exp.value, this.Source, this.pos);
        }
        if (exp.type == ExpressionType.Path) {
            return Expression.Alias(exp, (String)exp.value, this.Source, this.pos);
        }
        if (exp.type == ExpressionType.PathList) {
            return Expression.Alias(exp, (String)exp.value, this.Source, this.pos);
        }
        if (exp.type == ExpressionType.Identy || exp.type == ExpressionType.Const) {
            return Expression.Alias(exp, (String)exp.value, this.Source, this.pos);
        }
        throw new RuntimeException(this.GetExceptionMessage("\u8868\u8fbe\u5f0f\u5fc5\u987b\u8d77\u522b\u540d!" + t));
    }

    private Expression Group() {
        Token t = this.GetToken();
        if (t.Type != TokenType.Identy || !t.Value.equals("group")) {
            throw new RuntimeException(this.GetExceptionMessage("\u5fc5\u987b\u662fgroup!" + t));
        }
        List<Expression> alias = this.AttrList();
        return Expression.Group(alias, this.Source, this.pos);
    }

    private Expression TypeLimit() {
        Token t = this.GetToken();
        if (t.Type == TokenType.Identy) {
            Token oper = this.GetToken();
            if (oper.Type == TokenType.Oper && oper.Value.equals(":")) {
                ArrayList<String> strs = new ArrayList<String>();
                strs.add((String)t.Value);
                List<Expression> exps = this.AttrList();
                return Expression.TypeLimit(strs, exps, this.Source, this.pos);
            }
            this._tokens.push(oper);
            this._tokens.push(t);
            return null;
        }
        if (t.Type == TokenType.Oper && t.Value.equals("[")) {
            List<String> types = this.TypeLimitGroup();
            Token token = this.GetToken();
            if (token.Type != TokenType.Oper || !token.Value.equals("]")) {
                throw new RuntimeException(this.GetExceptionMessage("\u7c7b\u578b\u9009\u62e9\u5fc5\u987b\u4ee5]\u7ed3\u675f" + token));
            }
            token = this.GetToken();
            if (token.Type != TokenType.Oper || !token.Value.equals(":")) {
                throw new RuntimeException(this.GetExceptionMessage("\u7c7b\u578b\u9009\u62e9\u5fc5\u987b\u5e26':'" + token));
            }
            List<Expression> exps = this.AttrList();
            return Expression.TypeLimit(types, exps, this.Source, this.pos);
        }
        this._tokens.push(t);
        return null;
    }

    private List<String> TypeLimitGroup() {
        ArrayList<String> result = new ArrayList<String>();
        Token token = this.GetToken();
        while (token.Type == TokenType.Identy) {
            result.add((String)token.Value);
            token = this.GetToken();
            if (token.Type == TokenType.Oper && token.Value.equals(",")) {
                token = this.GetToken();
                continue;
            }
            this._tokens.push(token);
            return result;
        }
        this._tokens.push(token);
        return result;
    }

    private Expression Logic() {
        Token t = this.GetToken();
        if (t.Type == TokenType.Identy && t.Value.equals("not")) {
            Expression exp = this.Logic();
            exp = Expression.OneOperator(ExpressionType.Not, exp, this.Source, this.pos);
            return exp;
        }
        this._tokens.push(t);
        Expression v = this.Compare();
        t = this.GetToken();
        while (t.Type == TokenType.Identy && (t.Value.equals("and") || t.Value.equals("or"))) {
            Expression exp = this.Logic();
            v = t.Value.equals("and") ? Expression.TwoOperator(ExpressionType.And, v, exp, this.Source, this.pos) : Expression.TwoOperator(ExpressionType.Or, v, exp, this.Source, this.pos);
            t = this.GetToken();
        }
        this._tokens.push(t);
        return v;
    }

    private Expression Compare() {
        Expression left = this.Math();
        Token t = this.GetToken();
        if (t.Type == TokenType.Oper && (t.Value.equals(">") || t.Value.equals(">=") || t.Value.equals("<") || t.Value.equals("<="))) {
            Expression rExp = this.Math();
            if (t.Value.equals(">")) {
                return Expression.TwoOperator(ExpressionType.GreaterThan, left, rExp, this.Source, this.pos);
            }
            if (t.Value.equals(">=")) {
                return Expression.TwoOperator(ExpressionType.GreaterThanOrEqual, left, rExp, this.Source, this.pos);
            }
            if (t.Value.equals("<")) {
                return Expression.TwoOperator(ExpressionType.LessThan, left, rExp, this.Source, this.pos);
            }
            if (t.Value.equals("<=")) {
                return Expression.TwoOperator(ExpressionType.LessThanOrEqual, left, rExp, this.Source, this.pos);
            }
        } else if (t.Type == TokenType.Oper && (t.Value.equals("=") || t.Value.equals("!="))) {
            Expression rExp = this.Math();
            if (t.Value.equals("=")) {
                return Expression.TwoOperator(ExpressionType.Equal, left, rExp, this.Source, this.pos);
            }
            if (t.Value.equals("!=")) {
                return Expression.TwoOperator(ExpressionType.NotEqual, left, rExp, this.Source, this.pos);
            }
        }
        this._tokens.push(t);
        return left;
    }

    private Expression Math() {
        Expression v = this.Mul();
        Token t = this.GetToken();
        while (t.Type == TokenType.Oper && (t.Value.equals("+") || t.Value.equals("-"))) {
            Expression r = this.Mul();
            v = t.Value.equals("+") ? Expression.TwoOperator(ExpressionType.Add, v, r, this.Source, this.pos) : Expression.TwoOperator(ExpressionType.Subtract, v, r, this.Source, this.pos);
            t = this.GetToken();
        }
        this._tokens.push(t);
        return v;
    }

    private Expression Mul() {
        Expression v = this.UnarySub();
        Token t = this.GetToken();
        while (t.Type == TokenType.Oper && (t.Value.equals("*") || t.Value.equals("/") || t.Value.equals("%"))) {
            Expression r = this.UnarySub();
            v = t.Value.equals("*") ? Expression.TwoOperator(ExpressionType.Multiply, v, r, this.Source, this.pos) : (t.Value.equals("/") ? Expression.TwoOperator(ExpressionType.Divide, v, r, this.Source, this.pos) : Expression.TwoOperator(ExpressionType.Modulo, v, r, this.Source, this.pos));
            t = this.GetToken();
        }
        this._tokens.push(t);
        return v;
    }

    private Expression UnarySub() {
        Token t = this.GetToken();
        if (t.Type == TokenType.Oper && t.Value.equals("-")) {
            Expression r = this.Item();
            Expression value = Expression.Const(0, this.Source, this.pos);
            return Expression.TwoOperator(ExpressionType.Subtract, value, r, this.Source, this.pos);
        }
        this._tokens.push(t);
        return this.Item();
    }

    private Expression Item() {
        Token t = this.GetToken();
        if (t.Type == TokenType.Oper && t.Value.equals("(")) {
            Expression result = this.Logic();
            t = this.GetToken();
            if (t.Type != TokenType.Oper || !t.Value.equals(")")) {
                throw new RuntimeException(this.GetExceptionMessage("\u62ec\u53f7\u4e0d\u5339\u914d"));
            }
            return result;
        }
        if (t.Type == TokenType.Int || t.Type == TokenType.Double || t.Type == TokenType.Bool) {
            return Expression.Const(t.Value, this.Source, this.pos);
        }
        if (t.Type == TokenType.Identy) {
            String objName = (String)t.Value;
            return this.PathList(objName);
        }
        if (t.Type == TokenType.Oper && (t.Value.equals("*") || t.Value.equals("**"))) {
            return Expression.Const(t.Value, this.Source, this.pos);
        }
        if (t.Type == TokenType.Oper && t.Value.equals("'")) {
            return this.StringUnion();
        }
        if (t.Type == TokenType.Null) {
            return Expression.Const(null, this.Source, this.pos);
        }
        throw new RuntimeException(this.GetExceptionMessage("\u5355\u8bcd\u7c7b\u578b\u9519\u8bef\uff0c" + t));
    }

    private Expression StringUnion() {
        Token t = this.GetToken();
        if (t.Type != TokenType.String) {
            throw new RuntimeException(this.GetExceptionMessage("\u5fc5\u987b\u662f\u5b57\u7b26\u4e32!" + t));
        }
        Expression result = Expression.Const(t.Value, this.Source, this.pos);
        return result;
    }

    private Expression PathList(String name) {
        ArrayList<Expression> pathList = new ArrayList<Expression>();
        Expression oneExp = this.ObjectName(name);
        pathList.add(oneExp);
        Expression objExp = this.ObjectName("_");
        while (objExp.type != ExpressionType.Identy || !objExp.value.equals("_")) {
            pathList.addAll(objExp.children);
            objExp = this.ObjectName("_");
        }
        if (pathList.size() == 1) {
            return (Expression)pathList.get(0);
        }
        Expression result = Expression.PathList(pathList, this.Source, this.pos);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Expression ObjectName(String name) {
        Token n = this.GetToken();
        if (n.Type == TokenType.Oper && n.Value.equals("(")) {
            return this.MethodCall(null, name);
        }
        this._tokens.push(n);
        List<Expression> conditions = this.condition();
        Expression result = null;
        n = this.GetToken();
        if (n.Type == TokenType.Oper && n.Value.equals(".")) {
            n = this.GetToken();
            if (n.Type == TokenType.Oper && n.Value.equals("(")) {
                this._tokens.push(n);
                List<Expression> attrList = this.AttrList();
                return Expression.Path(name, attrList, conditions, this.Source, this.pos);
            }
            if (n.Type != TokenType.Identy) throw new RuntimeException(this.GetExceptionMessage("\u53ea\u80fd\u662f\u5c5e\u6027\u83b7\u53d6\u3001\u5c5e\u6027\u9009\u62e9\u6216\u8005\u65b9\u6cd5\u8c03\u7528 !" + n));
            Expression objExp = Expression.Path(name, conditions, this.Source, this.pos);
            return this.Property(objExp, (String)n.Value);
        }
        this._tokens.push(n);
        return Expression.Identy(name, this.Source, this.pos);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Expression Property(Expression object, String name) {
        Token n = this.GetToken();
        if (n.Type == TokenType.Oper && n.Value.equals("(")) {
            return this.MethodCall(object, name);
        }
        this._tokens.push(n);
        List<Expression> conditions = this.condition();
        Expression result = null;
        n = this.GetToken();
        if (n.Type == TokenType.Oper && n.Value.equals(".")) {
            n = this.GetToken();
            if (n.Type != TokenType.Identy) throw new RuntimeException(this.GetExceptionMessage("\u53ea\u80fd\u662f\u5c5e\u6027\u83b7\u53d6\u6216\u8005\u65b9\u6cd5\u8c03\u7528 !" + n));
            Expression objExp = Expression.Path(name, conditions, this.Source, this.pos);
            return this.Property(objExp, (String)n.Value);
        }
        this._tokens.push(n);
        return Expression.Property(name, object, conditions, this.Source, this.pos);
    }

    private List<Expression> condition() {
        ArrayList<Expression> conditions = new ArrayList<Expression>();
        Token t = this.GetToken();
        while (t.Type == TokenType.Oper && t.Value.equals("[")) {
            Expression logic = this.Logic();
            conditions.add(Expression.Condition(logic, this.Source, this.pos));
            t = this.GetToken();
            if (t.Type != TokenType.Oper || !t.Value.equals("]")) {
                throw new RuntimeException(this.GetExceptionMessage("\u6761\u4ef6\u5fc5\u987b\u4ee5]\u7ed3\u675f!" + t));
            }
            t = this.GetToken();
        }
        this._tokens.push(t);
        return conditions;
    }

    private Expression MethodCall(Expression object, String name) {
        Token t = this.GetToken();
        if (t.Type == TokenType.Oper && t.Value.equals(")")) {
            ArrayList<Expression> params = new ArrayList<Expression>();
            return Expression.Method(name, object, params, this.Source, this.pos);
        }
        this._tokens.push(t);
        List<Expression> params = this.Params();
        t = this.GetToken();
        if (t.Type != TokenType.Oper || !t.Value.equals(")")) {
            throw new RuntimeException(this.GetExceptionMessage("\u51fd\u6570\u8c03\u7528\u62ec\u53f7\u4e0d\u5339\u914d"));
        }
        return Expression.Method(name, object, params, this.Source, this.pos);
    }

    private List<Expression> Params() {
        ArrayList<Expression> result = new ArrayList<Expression>();
        result.add(this.Logic());
        Token t = this.GetToken();
        while (t.Type == TokenType.Oper && t.Value.equals(",")) {
            result.add(this.Logic());
            t = this.GetToken();
        }
        this._tokens.push(t);
        return result;
    }

    private String GetExceptionMessage(String msg) {
        String result = this.Source.substring(0, this.pos) + " <- " + this.Source.substring(this.pos, this.Source.length());
        return msg + ", " + result;
    }

    public Token GetToken() {
        if (this._tokens.size() != 0) {
            Token result = this._tokens.pop();
            return result;
        }
        int sPos = this.pos;
        if (this.pos < this.Source.length() && this.Source.charAt(this.pos) == '{') {
            this.inStrings.push(this.inString);
            this.inString = false;
            String str = this.Source.substring(this.pos, this.pos + 1);
            ++this.pos;
            return new Token(TokenType.Oper, str, sPos);
        }
        if (this.inString) {
            int startPos = this.pos;
            while (this.pos < this.Source.length() && this.Source.charAt(this.pos) != '{' && this.Source.charAt(this.pos) != '\'' && this.Source.charAt(this.pos) != '}') {
                ++this.pos;
            }
            if (this.pos >= this.Source.length() || this.Source.charAt(this.pos) != '{') {
                this.inString = this.inStrings.pop();
            }
            Token t = new Token(TokenType.String, this.Source.substring(startPos, this.pos), sPos);
            if (this.pos < this.Source.length() && this.Source.charAt(this.pos) == '\'') {
                ++this.pos;
            }
            return t;
        }
        while (this.pos < this.Source.length() && (this.Source.charAt(this.pos) == ' ' || this.Source.charAt(this.pos) == '\n' || this.Source.charAt(this.pos) == '\t') || this.pos < this.Source.length() - 2 && this.Source.charAt(this.pos) == '/' && this.Source.charAt(this.pos + 1) == '/') {
            if (this.pos < this.Source.length() && (this.Source.charAt(this.pos) == ' ' || this.Source.charAt(this.pos) == '\n' || this.Source.charAt(this.pos) == '\t')) {
                ++this.pos;
                continue;
            }
            this.pos += 2;
            while (this.pos < this.Source.length() && this.Source.charAt(this.pos) != '\n') {
                ++this.pos;
            }
            ++this.pos;
        }
        if (this.pos == this.Source.length()) {
            return new Token(TokenType.End, null, sPos);
        }
        if (this.Source.charAt(this.pos) >= '0' && this.Source.charAt(this.pos) <= '9') {
            int oldPos = this.pos;
            while (this.pos < this.Source.length() && this.Source.charAt(this.pos) >= '0' && this.Source.charAt(this.pos) <= '9') {
                ++this.pos;
            }
            if (this.pos < this.Source.length() && this.Source.charAt(this.pos) == '.') {
                ++this.pos;
                while (this.pos < this.Source.length() && this.Source.charAt(this.pos) >= '0' && this.Source.charAt(this.pos) <= '9') {
                    ++this.pos;
                }
                String str = this.Source.substring(oldPos, this.pos);
                return new Token(TokenType.Double, new BigDecimal(str), sPos);
            }
            String str = this.Source.substring(oldPos, this.pos);
            return new Token(TokenType.Int, Integer.parseInt(str), sPos);
        }
        if (this.Source.charAt(this.pos) >= 'a' && this.Source.charAt(this.pos) <= 'z' || this.Source.charAt(this.pos) >= 'A' && this.Source.charAt(this.pos) <= 'Z' || this.Source.charAt(this.pos) == '_') {
            int oldPos = this.pos;
            while (this.pos < this.Source.length() && (this.Source.charAt(this.pos) >= 'a' && this.Source.charAt(this.pos) <= 'z' || this.Source.charAt(this.pos) >= 'A' && this.Source.charAt(this.pos) <= 'Z' || this.Source.charAt(this.pos) >= '0' && this.Source.charAt(this.pos) <= '9' || this.Source.charAt(this.pos) == '_')) {
                ++this.pos;
            }
            String str = this.Source.substring(oldPos, this.pos);
            if (str.equals("false") || str.equals("true")) {
                return new Token(TokenType.Bool, Boolean.parseBoolean(str), sPos);
            }
            if (str.equals("null")) {
                return new Token(TokenType.Null, null, oldPos);
            }
            return new Token(TokenType.Identy, str, oldPos);
        }
        if (this.Source.charAt(this.pos) == '&' && this.Source.charAt(this.pos + 1) == '&' || this.Source.charAt(this.pos) == '|' && this.Source.charAt(this.pos + 1) == '|' || this.Source.charAt(this.pos) == '*' && this.Source.charAt(this.pos + 1) == '*') {
            String str = this.Source.substring(this.pos, this.pos + 2);
            this.pos += 2;
            return new Token(TokenType.Oper, str, sPos);
        }
        if (this.Source.charAt(this.pos) == '+' || this.Source.charAt(this.pos) == '-' || this.Source.charAt(this.pos) == '*' || this.Source.charAt(this.pos) == '/' || this.Source.charAt(this.pos) == '%' || this.Source.charAt(this.pos) == '>' || this.Source.charAt(this.pos) == '<' || this.Source.charAt(this.pos) == '!') {
            if (this.pos < this.Source.length() && this.Source.charAt(this.pos + 1) == '=') {
                String str = this.Source.substring(this.pos, this.pos + 2);
                this.pos += 2;
                return new Token(TokenType.Oper, str, sPos);
            }
            String str = this.Source.substring(this.pos, this.pos + 1);
            ++this.pos;
            return new Token(TokenType.Oper, str, sPos);
        }
        if (this.Source.charAt(this.pos) == '=') {
            if (this.pos < this.Source.length() && (this.Source.charAt(this.pos + 1) == '=' || this.Source.charAt(this.pos + 1) == '>')) {
                String str = this.Source.substring(this.pos, this.pos + 2);
                this.pos += 2;
                return new Token(TokenType.Oper, str, sPos);
            }
            String str = this.Source.substring(this.pos, this.pos + 1);
            ++this.pos;
            return new Token(TokenType.Oper, str, sPos);
        }
        if (this.Source.charAt(this.pos) == '(' || this.Source.charAt(this.pos) == ')' || this.Source.charAt(this.pos) == ',' || this.Source.charAt(this.pos) == ';' || this.Source.charAt(this.pos) == '.' || this.Source.charAt(this.pos) == ':' || this.Source.charAt(this.pos) == '@' || this.Source.charAt(this.pos) == '\'' || this.Source.charAt(this.pos) == '{' || this.Source.charAt(this.pos) == '}' || this.Source.charAt(this.pos) == '[' || this.Source.charAt(this.pos) == ']') {
            if (this.Source.charAt(this.pos) == '\'') {
                this.inStrings.push(this.inString);
                this.inString = true;
            }
            if (this.Source.charAt(this.pos) == '{' && this.inStrings.size() != 0) {
                this.inStrings.push(this.inString);
                this.inString = false;
            }
            if (this.Source.charAt(this.pos) == '}' && this.inStrings.size() != 0) {
                this.inString = this.inStrings.pop();
            }
            String str = this.Source.substring(this.pos, this.pos + 1);
            ++this.pos;
            return new Token(TokenType.Oper, str, sPos);
        }
        throw new RuntimeException(this.GetExceptionMessage("\u65e0\u6548\u5355\u8bcd\uff1a" + this.Source.charAt(this.pos)));
    }
}

