/*
 * Decompiled with CFR 0.152.
 */
package com.af.path;

import com.af.path.types.JavaListType;
import com.af.path.types.JavaManyToOneType;
import com.af.path.types.JavaOneToOneType;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.hibernate.QueryException;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.type.AssociationType;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.DateType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.StringType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.Type;

public class ClassHelper {
    static String packageName = "com.af.entity.";
    static List<Class<?>> classes = null;
    static List<Type> types = null;

    public static String getTypeString(Type t) {
        if (t instanceof StringType) {
            return "s";
        }
        if (t instanceof IntegerType) {
            return "i";
        }
        if (t instanceof DateType) {
            return "dt";
        }
        if (t instanceof DoubleType) {
            return "d";
        }
        if (t instanceof BigDecimalType) {
            return "b";
        }
        if (t instanceof TimestampType) {
            return "t";
        }
        throw new RuntimeException("\u6ca1\u6709\u8be5\u7c7b\u578b\u7684\u5b57\u7b26\u4e32\u8868\u793a" + t);
    }

    public static List<Type> getTypes() {
        if (types == null) {
            types = new ArrayList<Type>();
            types.add((Type)StringType.INSTANCE);
            types.add((Type)IntegerType.INSTANCE);
            types.add((Type)DateType.INSTANCE);
            types.add((Type)DoubleType.INSTANCE);
            types.add((Type)BigDecimalType.INSTANCE);
            types.add((Type)TimestampType.INSTANCE);
        }
        return types;
    }

    public static boolean isInterface(String table) {
        try {
            Class<?> c = Class.forName(packageName + table);
            return c.isInterface();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static List<String> getFieldNames(String table, SessionFactory factory) {
        ArrayList<String> result = new ArrayList<String>();
        if (ClassHelper.isInterface(table)) {
            return result;
        }
        ClassMetadata meta = factory.getClassMetadata(table);
        for (String field : meta.getPropertyNames()) {
            result.add(field);
        }
        try {
            Class<?> c = Class.forName("com.af.entity." + table);
            for (Field field : c.getFields()) {
                result.add(field.getName());
            }
            return result;
        }
        catch (ClassNotFoundException e) {
            return result;
        }
    }

    public static String getKey(String table, SessionFactory factory) {
        ClassMetadata cm = factory.getClassMetadata(table);
        if (cm == null) {
            throw new RuntimeException("\u627e\u4e0d\u5230\u8868\uff1a" + table);
        }
        String key = cm.getIdentifierPropertyName();
        return key;
    }

    public static String getForiegnKey(String table, String name, SessionFactory factory) {
        String foreignKey = ClassHelper.getForeignKeyFromHibernate(table, name, factory);
        if (foreignKey != null) {
            return foreignKey;
        }
        return ClassHelper.getForiegnKey(table, name);
    }

    public static String getForiegnKey(String table, String name) {
        try {
            Class<?> c = Class.forName("com.af.entity." + table);
            Field field = c.getField(name);
            OneToMany oneToMany = field.getAnnotation(OneToMany.class);
            if (oneToMany != null) {
                String result = oneToMany.mappedBy();
                return result;
            }
            OneToOne oneToOne = field.getAnnotation(OneToOne.class);
            if (oneToOne != null) {
                String result = oneToOne.mappedBy();
                return result;
            }
            ManyToOne manyToOne = field.getAnnotation(ManyToOne.class);
            if (manyToOne != null) {
                JoinColumn column = field.getAnnotation(JoinColumn.class);
                return column.name();
            }
            throw new RuntimeException("\u8868" + table + "\u5c5e\u6027" + name + "\u4e0d\u662f\u5173\u8054\u5173\u7cfb");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("\u8868" + table + "\u6ca1\u6709" + name + "\u5c5e\u6027");
        }
    }

    private static String getForeignKeyFromHibernate(String table, String name, SessionFactory factory) {
        ClassMetadata cm = factory.getClassMetadata(table);
        if (cm == null) {
            throw new RuntimeException("\u8868" + table + "\u5728hibernate\u91cc\u6ca1\u6709\u914d\u7f6e!");
        }
        try {
            Type type = cm.getPropertyType(name);
            if (!(type instanceof AssociationType)) {
                return null;
            }
            AssociationType set = (AssociationType)type;
            SessionFactoryImplementor sf = (SessionFactoryImplementor)factory;
            Joinable join = set.getAssociatedJoinable(sf);
            String foreignkey = join.getKeyColumnNames()[0];
            return foreignkey;
        }
        catch (QueryException e) {
            return null;
        }
    }

    public static List<String> getExtendClass(String entity) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Class<?> c = Class.forName("com.af.entity." + entity);
            List<Class<?>> cs = ClassHelper.getClassInPackage("com.af.entity");
            for (Class<?> ac : cs) {
                if (!c.isAssignableFrom(ac) || ac == c || ac.isInterface() || Modifier.isAbstract(ac.getModifiers())) continue;
                String name = ac.getName();
                name = name.substring("com.af.entity".length() + 1);
                result.add(name);
            }
        }
        catch (ClassNotFoundException e) {
            result.add(entity);
        }
        return result;
    }

    public static List<Class<?>> getClassInPackage(String packName) {
        if (classes != null) {
            return classes;
        }
        ArrayList result = new ArrayList();
        String path = packName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(path);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    result.addAll(ClassHelper.getClassInPath(packName, filePath));
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                result.addAll(ClassHelper.getClassInJar(jar, path, packName));
            }
            classes = result;
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("\u83b7\u53d6\u5305\u9519\u8bef\uff1a" + path);
        }
    }

    private static List<Class<?>> getClassInJar(JarFile jar, String packageDirName, String packageName) {
        ArrayList result = new ArrayList();
        try {
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                int idx;
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (name.charAt(0) == '/') {
                    name = name.substring(1);
                }
                if (!name.startsWith(packageDirName) || !name.endsWith(".class") || (idx = name.lastIndexOf(47)) == -1 || !name.endsWith(".class")) continue;
                String className = name.substring(packageName.length() + 1, name.length() - 6);
                result.add(Class.forName(packageName + '.' + className));
            }
            return result;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Class<?>> getClassInPath(String packName, String filePath) {
        ArrayList result = new ArrayList();
        File dir = new File(filePath);
        File[] dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".class");
            }
        });
        try {
            for (File file : dirfiles) {
                String className = file.getName().substring(0, file.getName().length() - 6);
                Class<?> c = Class.forName(packName + "." + className);
                result.add(c);
            }
            return result;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Type getType(String tableName, String name, SessionFactory factory) {
        ClassMetadata cm = factory.getClassMetadata(tableName);
        if (cm == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u5b9e\u4f53:" + tableName);
        }
        try {
            Type type = cm.getPropertyType(name);
            return type;
        }
        catch (QueryException e) {
            try {
                Class<?> c = Class.forName("com.af.entity." + tableName);
                Field field = c.getField(name);
                Class<?> fieldClass = field.getType();
                if (fieldClass == List.class) {
                    ParameterizedType paramType = (ParameterizedType)field.getGenericType();
                    String refNames = paramType.getActualTypeArguments()[0].getTypeName();
                    String[] names = refNames.split("\\.");
                    String refName = names[names.length - 1];
                    JavaListType type = new JavaListType(name, refName);
                    return type;
                }
                OneToOne oneToOne = field.getAnnotation(OneToOne.class);
                if (oneToOne != null) {
                    SingleTableEntityPersister table = (SingleTableEntityPersister)factory.getClassMetadata(fieldClass);
                    String tname = table.getTableName();
                    return new JavaOneToOneType(name, tname);
                }
                ManyToOne manyToOne = field.getAnnotation(ManyToOne.class);
                if (manyToOne != null) {
                    String tname = fieldClass.getName();
                    String[] names = tname.split("\\.");
                    String refName = names[names.length - 1];
                    return new JavaManyToOneType(name, refName);
                }
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("\u8868" + tableName + "\u6ca1\u6709" + name + "\u5c5e\u6027");
            }
            catch (NoSuchFieldException ex) {
                throw new RuntimeException("\u8868" + tableName + "\u6ca1\u6709" + name + "\u5c5e\u6027");
            }
            throw new RuntimeException(tableName + "\u6ca1\u6709" + name + "\u5c5e\u6027");
        }
    }
}

