package meter;

import com.af.plugins.CommonTools;
import com.af.plugins.DateTools;
import com.af.plugins.JsonTools;
import com.aote.entity.EntityServer;
import com.aote.sql.SqlServer;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;


public class MeterManage {
    static Logger log = Logger.getLogger(EntityServer.class);
    private Lock lock  =new ReentrantLock() ;
    public  String  getAddress1(String f_pcd,String f_zone,String f_street,String f_residential_area,String f_builid_num,String f_unit,String f_floor,String f_door_num){
        String address = "";
        address = f_pcd+""+f_zone+f_street+f_residential_area+f_builid_num+"号楼"+f_unit+"单元"+f_floor+"层"+f_door_num+"房间";
        return  address;
    }
    public  String  getAddress2(String f_pcd,String f_zone,String f_street,String f_residential_area,String f_store_address){
        String address = "";
        address = f_pcd + "" + f_zone + f_street + f_residential_area + f_store_address;
        return  address;
    }
    public  String  getUserinfoid(SqlServer sql, String f_user_state,String f_userinfo_code) throws Exception{
        String userinfoid = "";
        lock.lock();
        try{
            //处理任务

            JSONArray getMax = sql.query(
                    "select isnull(cast(max(cast(f_userinfo_id as bigint)) as varchar), 0) as maxid from t_userinfo"
            );
            CommonTools commonTools = new CommonTools();
            String max =getMax.getJSONObject(0).getString("maxid");
            userinfoid =commonTools.strAdd(max, 1);
            int a = sql.runSQL("set identity_insert t_userinfo ON insert into t_userinfo (version,f_user_state,f_userinfo_id,f_userinfo_code) values(1,'"+ f_user_state +"','"+ userinfoid +"','"+ f_userinfo_code +"')");
        }catch(Exception ex){

        }finally{
            lock.unlock();   //释放锁
        }
        return userinfoid;
    }

    public JSONArray getMeter( EntityServer entity,JSONArray array,JSONArray app) throws Exception {
        int a;
        int m=1;
        JSONArray o=new JSONArray();
        for (int i=0;i<array.length();i++){
            a=0;

            for (int j= 0 ;j<app.length();j++){
                if (array.getJSONObject(i).getString("f_meternumber").equals(app.getJSONObject(j).getString("f_meternumber"))){
                   a=1;
                }
            }
            if (a==0){
                array.getJSONObject(i).remove("id");
                o.put(m, array.getJSONObject(i));
                m=m+1;
            }
        }
        o.remove(0);
        return o;
    }

    public void meterJoin(SqlServer sql, EntityServer entity, JSONObject data) throws Exception {
        JSONObject model = data.getJSONObject("model");
        JSONArray rowsdata = data.getJSONArray("rowsdata");
        // 仓库id
        int f_warehouse_id = model.getInt("f_warehouse_id");
        // 本次入库的所有表具id
        ArrayList meterinfoids = new ArrayList();
        // 加入当前时间
        String nowDate = DateTools.getNow2();
        model.put("f_operate_date",nowDate);
        log.debug("model:"+model.toString());
        // 开始保存t_meter_record
        for (Object row : rowsdata) {
            JSONObject json = (JSONObject) row;
            // 表具id
            int f_meterinfo_id = json.getInt("id");
            meterinfoids.add(f_meterinfo_id);
            model.put("f_meterinfo_id",f_meterinfo_id);
            // 莫名有个id
            model.remove("id");
            // 保存record记录
            entity.partialSave("t_meter_record",model);
        }
        log.debug("保存t_meter_record完成,共"+rowsdata.length());
        // 生成更新条件
        String ids = meterinfoids.toString().replace("[","(").replace("]",")");
        log.debug("更新meterinfo条件:"+ids);

        int n = sql.runSQL("update t_meterinfo set f_distribution_state = '已入库',f_warehouse_id = "+f_warehouse_id+" where id in "+ids);
        log.debug("更新meterinfo成功:"+n);
        // 更新仓库库存
        n = sql.runSQL("update t_warehouse set f_warehouse_number = ISNULL(f_warehouse_number, 0)+"+rowsdata.length()+",f_notreceive_number=ISNULL(f_notreceive_number, 0)+"+rowsdata.length()+" where id = "+f_warehouse_id);
        log.debug("更新t_warehouse库存成功:"+n);
    }
    // 入库
    public void meterJoin1(SqlServer sql, EntityServer entity, JSONObject data) throws Exception {
        JSONObject model = data.getJSONObject("model");
        JSONArray rowsdata = data.getJSONArray("rowsdata");
        int f_warehouse_id = model.getInt("f_warehouse_id");
        String nowDate = DateTools.getNow2();
        model.put("f_operate_date",nowDate);
        int n=0;
        int id;
        for (int i=0;i<rowsdata.length();i++){
            JSONArray a=sql.query("select * from t_stock where f_material_class_id = "+rowsdata.getJSONObject(i).getInt("f_material_class_id")+" and f_warehouse_id = "+f_warehouse_id);
            if (a.length()>0){
                n=sql.runSQL("update t_stock set f_number = ISNULL(f_number, 0)+"+rowsdata.getJSONObject(i).getInt("number")+" where id = "+a.getJSONObject(0).getInt("id"));
                id=a.getJSONObject(0).getInt("id");
            }else{
                JSONObject stock =new JSONObject();
                stock.put("f_material_class_id",rowsdata.getJSONObject(i).getInt("f_material_class_id"));
                stock.put("f_warehouse_id",f_warehouse_id);
                stock.put("f_number",rowsdata.getJSONObject(i).getInt("number"));
                stock.put("f_isinfo",rowsdata.getJSONObject(i).getString("f_isinfo"));
                JsonTools jsonTools=new JsonTools();
                id=jsonTools.convertToJson(entity.partialSave("t_stock",stock)).getInt("id");

            }
            if (rowsdata.getJSONObject(i).getString("f_isinfo").equals("是")){
                JSONArray meterinfo = rowsdata.getJSONObject(i).getJSONArray("info");
                for (int j=0;j<meterinfo.length();j++){
                    n=sql.runSQL("update t_meterinfo set f_distribution_state = '已入库' where id = "+meterinfo.getJSONObject(j).getInt("id"));
                    n=sql.runSQL("update t_meterinfo set f_stock_id = "+id+" where id = "+meterinfo.getJSONObject(j).getInt("id"));
                    model.put("f_meterinfo_id",meterinfo.getJSONObject(j).getInt("id"));
                    model.put("f_stock_id",id);
                    model.put("f_number", 1);
                    model.remove("id");
                    entity.partialSave("t_meter_record",model);
                }
            }else{
                model.put("f_stock_id",id);
                model.put("f_number",rowsdata.getJSONObject(i).getInt("number"));
                model.remove("id");
                model.remove("f_meterinfo_id");
                entity.partialSave("t_meter_record",model);
            }
            n=sql.runSQL("update t_stock set f_number = ISNULL(f_number, 0)-"+rowsdata.getJSONObject(i).getInt("number")+" where id = "+rowsdata.getJSONObject(i).getInt("id"));
        }
    }
    //调拨
    public void meterAllocate1(SqlServer sql, EntityServer entity,JSONObject data)throws Exception {
        JSONObject model = data.getJSONObject("model");
        JSONArray rowsdata = data.getJSONArray("rowsdata");
        int f_warehouse_id = model.getInt("f_warehouse_id");
        String nowDate = DateTools.getNow2();
        model.put("f_operate_date", nowDate);
        int n = 0;
        int id;
        for (int i = 0; i < rowsdata.length(); i++) {
            JSONArray a = sql.query("select * from t_stock where f_material_class_id = " + rowsdata.getJSONObject(i).getInt("f_material_class_id") + " and f_warehouse_id = " + f_warehouse_id);
            if (a.length() > 0) {
                n = sql.runSQL("update t_stock set f_number = ISNULL(f_number, 0)+" + rowsdata.getJSONObject(i).getInt("number") + " where id = " + a.getJSONObject(0).getInt("id"));
                id = a.getJSONObject(0).getInt("id");
            } else {
                JSONObject stock = new JSONObject();
                stock.put("f_material_class_id", rowsdata.getJSONObject(i).getInt("f_material_class_id"));
                stock.put("f_warehouse_id", f_warehouse_id);
                stock.put("f_number", rowsdata.getJSONObject(i).getInt("number"));
                stock.put("f_isinfo", rowsdata.getJSONObject(i).getString("f_isinfo"));
                JsonTools jsonTools = new JsonTools();
                id = jsonTools.convertToJson(entity.partialSave("t_stock", stock)).getInt("id");

            }
            if (rowsdata.getJSONObject(i).getString("f_isinfo").equals("是")) {
                JSONArray meterinfo = rowsdata.getJSONObject(i).getJSONArray("info");
                for (int j = 0; j < meterinfo.length(); j++) {
                    n=sql.runSQL("update t_meterinfo set f_stock_id = "+id+" where id = "+meterinfo.getJSONObject(j).getInt("id"));
                    model.put("f_meterinfo_id", meterinfo.getJSONObject(j).getInt("id"));
                    model.put("f_stock_id", id);
                    model.put("f_number", 1);
                    model.remove("id");
                    entity.partialSave("t_meter_record", model);
                }
            } else {
                model.put("f_stock_id", id);
                model.put("f_number", rowsdata.getJSONObject(i).getInt("number"));
                model.remove("id");
                model.remove("f_meterinfo_id");
                entity.partialSave("t_meter_record", model);
            }
            n = sql.runSQL("update t_stock set f_number = ISNULL(f_number, 0)-" + rowsdata.getJSONObject(i).getInt("number") + " where id = " + rowsdata.getJSONObject(i).getInt("id"));
        }
    }
    //归还
    public void meterReturn1(SqlServer sql, EntityServer entity,JSONObject data)throws Exception {
        JSONObject model = data.getJSONObject("model");
        JSONArray rowsdata = data.getJSONArray("rowsdata");
        String nowDate = DateTools.getNow2();
        model.put("f_operate_date", nowDate);
        int n = 0;
        int a =0;
        for(int i=0;i<rowsdata.length();i++){
            a=rowsdata.getJSONObject(i).getInt("f_meteroperate_id");
            n = sql.runSQL("update t_stock set f_number = ISNULL(f_number, 0)+" + rowsdata.getJSONObject(i).getInt("number") + " where id = " + rowsdata.getJSONObject(i).getInt("f_stock_id"));
            model.put("f_stock_id", rowsdata.getJSONObject(i).getInt("f_stock_id"));
            model.put("f_number", rowsdata.getJSONObject(i).getInt("number"));
            if (rowsdata.getJSONObject(i).get("f_meterinfo_id")!=null){
                n = sql.runSQL("update t_meterinfo set f_distribution_state = '已入库' where id = "+rowsdata.getJSONObject(i).get("f_meterinfo_id"));
                model.put("f_meterinfo_id", rowsdata.getJSONObject(i).get("f_meterinfo_id"));
                model.remove("id");
                entity.partialSave("t_meter_record", model);

            }else {
                model.remove("id");
                model.remove("f_meterinfo_id");
                entity.partialSave("t_meter_record", model);
            }
        }
        n = sql.runSQL("update t_meter_operate set f_returnstate = '已归还' where id = "+a);


    }
    //退回
    public void Return(SqlServer sql, EntityServer entity,JSONObject data,JSONArray array)throws Exception {
        JSONObject model = data.getJSONObject("model");
        String nowDate = DateTools.getNow2();
        model.put("f_operate_date", nowDate);
        int n = 0;
        int a =data.getJSONObject("param").getInt("id");
        for(int i=0;i<array.length();i++){
            n = sql.runSQL("update t_stock set f_number = ISNULL(f_number, 0)+" + array.getJSONObject(i).getInt("f_number") + " where id = " + array.getJSONObject(i).getInt("f_stock_id"));
            model.put("f_stock_id", array.getJSONObject(i).getInt("f_stock_id"));
            model.put("f_number", array.getJSONObject(i).getInt("f_number"));
            if (array.getJSONObject(i).get("f_meterinfo_id")!=null){
                n = sql.runSQL("update t_meterinfo set f_distribution_state = '已入库' where id = "+array.getJSONObject(i).get("f_meterinfo_id"));
                model.put("f_meterinfo_id", array.getJSONObject(i).get("f_meterinfo_id"));
                model.remove("id");
                entity.partialSave("t_meter_record", model);

            }else {
                model.remove("id");
                model.remove("f_meterinfo_id");
                entity.partialSave("t_meter_record", model);
            }
        }
        n = sql.runSQL("update t_meter_operate set f_returnstate = '已退回' where id = "+a);


    }

    public JSONArray calculation(JSONArray materialrow,JSONArray budgetrow){
        JSONArray array =new JSONArray();
        for (int i=0;i<materialrow.length();i++){
            for (int j=0;j<budgetrow.length();j++){
                if (materialrow.getJSONObject('i').getInt("f_material_class_id")==budgetrow.getJSONObject('i').getInt("f_material_class_id")){
                    if (materialrow.getJSONObject('i').getInt("f_number")<budgetrow.getJSONObject('i').getInt("f_number")){
                        array.getJSONObject(i).put("f_material_class_id",materialrow.getJSONObject('i').getInt("f_material_class_id"));
                        array.getJSONObject(i).put("f_name",materialrow.getJSONObject('i').getString("f_name"));
                        array.getJSONObject(i).put("f_unit",materialrow.getJSONObject('i').getString("f_unit"));
                        int a=budgetrow.getJSONObject('i').getInt("f_number") - materialrow.getJSONObject('i').getInt("f_number");
                        array.getJSONObject(i).put("f_number",a);
                    }
                }
            }
        }
        return array;
    }

    public void meterReceive1(SqlServer sql, EntityServer entity,JSONObject data)throws Exception {
        JSONObject model = data.getJSONObject("model");
        JSONArray rowsdata = data.getJSONArray("rowsdata");
        String nowDate = DateTools.getNow2();
        model.put("f_operate_date", nowDate);
        int n = 0;
        for(int i=0;i<rowsdata.length();i++){
            n = sql.runSQL("update t_stock set f_number = ISNULL(f_number, 0)-" + rowsdata.getJSONObject(i).getInt("number") + " where id = " + rowsdata.getJSONObject(i).getInt("id"));
            if (rowsdata.getJSONObject(i).getString("f_isinfo").equals("是")){
                JSONArray meterinfo = rowsdata.getJSONObject(i).getJSONArray("info");
                for (int j=0;j<meterinfo.length();j++){
                    n = sql.runSQL("update t_meterinfo set f_distribution_state = '已领用' where id = "+meterinfo.getJSONObject(j).getInt("id"));
                    model.put("f_meterinfo_id", meterinfo.getJSONObject(j).getInt("id"));
                    model.put("f_stock_id", rowsdata.getJSONObject(i).getInt("id"));
                    model.put("f_price", rowsdata.getJSONObject(i).getDouble("f_price"));
                    model.put("f_cash", rowsdata.getJSONObject(i).getDouble("f_price"));
                    model.put("f_number", 1);
                    model.remove("id");
                    entity.partialSave("t_meter_record", model);
                }
            }else {
                model.put("f_stock_id", rowsdata.getJSONObject(i).getInt("id"));
                model.put("f_number", rowsdata.getJSONObject(i).getInt("number"));
                model.put("f_price", rowsdata.getJSONObject(i).getDouble("f_price"));
                model.put("f_cash", rowsdata.getJSONObject(i).getDouble("f_price")*rowsdata.getJSONObject(i).getInt("number"));
                model.remove("id");
                model.remove("f_meterinfo_id");
                entity.partialSave("t_meter_record", model);
            }
        }
        n = sql.runSQL("update t_meter_operate set f_cash= a.cash from" +
                "(select sum(f_cash) as cash from t_meter_record where f_meteroperate_id = "+model.getString("f_meteroperate_id")+") a   " +
                "where id = "+model.getString("f_meteroperate_id"));

    }
    // 表具领用
    public void meterReceive(SqlServer sql, EntityServer entity, JSONObject data) throws Exception {
        JSONObject model = data.getJSONObject("model");
        JSONArray rowsdata = data.getJSONArray("rowsdata");
        // 仓库id
        int f_warehouse_id = model.getInt("f_warehouse_id");
        // 本次入库的所有表具id
        ArrayList meterinfoids = new ArrayList();
        // 加入当前时间
        String nowDate = DateTools.getNow2();
        model.put("f_operate_date",nowDate);
        log.debug("model:"+model.toString());
        // 开始保存t_meter_record
        for (Object row : rowsdata) {
            JSONObject json = (JSONObject) row;
            // 表具id
            int f_meterinfo_id = json.getInt("id");
            meterinfoids.add(f_meterinfo_id);
            model.put("f_meterinfo_id",f_meterinfo_id);
            // 莫名有个id
            model.remove("id");
            // 保存record记录
            entity.partialSave("t_meter_record",model);
        }
        log.debug("保存t_meter_record完成,共"+rowsdata.length());
        // 生成更新条件
        String ids = meterinfoids.toString().replace("[","(").replace("]",")");
        log.debug("更新meterinfo条件:"+ids);

        int n = sql.runSQL("update t_meterinfo set f_distribution_state = '已领用' where id in "+ids);
        log.debug("更新meterinfo成功:"+n);
        // 更新仓库库存
        n = sql.runSQL("update t_warehouse set f_receive_number=ISNULL(f_receive_number, 0)+"+rowsdata.length()+",f_notreceive_number=ISNULL(f_notreceive_number, 0)-"+rowsdata.length()+" where id = "+f_warehouse_id);
        log.debug("更新t_warehouse库存成功:"+n);
    }

    //库存调拨
    public void meterAllocate(SqlServer sql, EntityServer entity,JSONObject data)throws Exception{
        JSONObject model = data.getJSONObject("model");
        JSONArray rowsdata = data.getJSONArray("rowsdata");
        // 仓库id
        int f_warehouse_id = model.getInt("f_warehouse_id");
        int f_warehouse_id_old=model.getInt("f_warehouse_id_old");
        // 本次入库的所有表具id
        ArrayList meterinfoids = new ArrayList();
        // 加入当前时间
        String nowDate = DateTools.getNow2();
        model.put("f_operate_date",nowDate);
        log.debug("model:"+model.toString());
        // 开始保存t_meter_record
        for (Object row : rowsdata) {
            JSONObject json = (JSONObject) row;
            // 表具id
            int f_meterinfo_id = json.getInt("id");
            meterinfoids.add(f_meterinfo_id);
            model.put("f_meterinfo_id",f_meterinfo_id);
            // 莫名有个id
            model.remove("id");
            // 保存record记录
            entity.partialSave("t_meter_record",model);
        }
        log.debug("保存t_meter_record完成,共"+rowsdata.length());
        // 生成更新条件
        String ids = meterinfoids.toString().replace("[","(").replace("]",")");
        log.debug("更新meterinfo条件:"+ids);

        int n = sql.runSQL("update t_meterinfo set f_warehouse_id = "+f_warehouse_id+" where id in "+ids);
        log.debug("更新meterinfo成功:"+n);

        int number=rowsdata.length();
        int m=sql.runSQL("update t_warehouse set f_warehouse_number = f_warehouse_number-"+number+", f_notreceive_number = f_notreceive_number-"+number+" where id = "+f_warehouse_id_old);
        int p=sql.runSQL("update t_warehouse set f_warehouse_number = f_warehouse_number+"+number+", f_notreceive_number = f_notreceive_number+"+number+" where id = "+f_warehouse_id);
    }


    public void stockImport(SqlServer sql, EntityServer entity,JSONArray datas)  throws Exception {
        JSONArray array =sql.query("select id from t_material_class");

        int a= 0;
        for (int i=0;i<datas.length();i++) {

            for (int j=0;j<array.length();j++){
                if (datas.getJSONObject(i).getJSONObject("stock").getInt("f_material_class_id")==array.getJSONObject(j).getInt("id")){
                    a=1;
                }
            }
            if (a==0){
                throw new Exception();
            }
            if (datas.getJSONObject(i).getJSONObject("stock").getInt("f_number") <= 0){
                throw new Exception();
            }
            if (datas.getJSONObject(i).getJSONObject("stock").getString("f_isinfo")==null){
                throw new Exception();
            }
        }
        for (int i=0;i<datas.length();i++) {
            if (datas.getJSONObject(i).getJSONObject("stock").getString("f_isinfo").equals("否")){
                int mcid=datas.getJSONObject(i).getJSONObject("stock").getInt("f_material_class_id");
                JSONArray array2 =sql.query("select * from t_stock where f_warehouse_id is null and f_material_class_id = "+mcid);
                if (array2.length()>0){
                    int n = sql.runSQL("update t_stock set f_number=ISNULL(f_number, 0)+"+datas.getJSONObject(i).getJSONObject("stock").getInt("f_number")+" where id = "+array2.getJSONObject(0).getInt("id"));
                }else{
                    JSONObject model = new JSONObject();
                    model.put("f_material_class_id",datas.getJSONObject(i).getJSONObject("stock").getInt("f_material_class_id"));
                    model.put("f_number",datas.getJSONObject(i).getJSONObject("stock").getInt("f_number"));
                    model.put("f_isinfo",datas.getJSONObject(i).getJSONObject("stock").getString("f_isinfo"));
                    entity.partialSave("t_stock",model);
                }
            }else if(datas.getJSONObject(i).getJSONObject("stock").getString("f_isinfo").equals("是")){
                int mcid=datas.getJSONObject(i).getJSONObject("stock").getInt("f_material_class_id");
                JSONArray array2 =sql.query("select * from t_stock where f_warehouse_id is null and f_material_class_id = "+mcid);
                if (array2.length()==0){
                    JSONObject model = new JSONObject();
                    model.put("f_material_class_id",datas.getJSONObject(i).getJSONObject("stock").getInt("f_material_class_id"));
                    model.put("f_number",0);
                    model.put("f_isinfo",datas.getJSONObject(i).getJSONObject("stock").getString("f_isinfo"));
                    entity.partialSave("t_stock",model);
                }
            }

        }

    }

    public void stockadd(SqlServer sql, EntityServer entity,JSONObject datas)  throws Exception {
        JSONArray array =sql.query("select id from t_material_class");

        int a= 0;


            for (int j=0;j<array.length();j++){
                if (datas.getInt("f_material_class_id")==array.getJSONObject(j).getInt("id")){
                    a=1;
                }
            }
            if (a==0){
                throw new Exception();
            }
            if (datas.getInt("f_number") < 0){
                throw new Exception();
            }
            if (datas.getString("f_isinfo")==null){
                throw new Exception();
            }


            if (datas.getString("f_isinfo").equals("否")){
                int mcid=datas.getInt("f_material_class_id");
                JSONArray array2 =sql.query("select * from t_stock where f_warehouse_id is null and f_material_class_id = "+mcid);
                if (array2.length()>0){
                    int n = sql.runSQL("update t_stock set f_number=ISNULL(f_number, 0)+"+datas.getInt("f_number")+" where id = "+array2.getJSONObject(0).getInt("id"));
                }else{
                    JSONObject model = new JSONObject();
                    model.put("f_material_class_id",datas.getInt("f_material_class_id"));
                    model.put("f_number",datas.getInt("f_number"));
                    model.put("f_isinfo",datas.getString("f_isinfo"));
                    entity.partialSave("t_stock",model);
                }
            }else if(datas.getString("f_isinfo").equals("是")){
                int mcid=datas.getInt("f_material_class_id");
                JSONArray array2 =sql.query("select * from t_stock where f_warehouse_id is null and f_material_class_id = "+mcid);
                if (array2.length()==0){
                    JSONObject model = new JSONObject();
                    model.put("f_material_class_id",datas.getInt("f_material_class_id"));
                    model.put("f_number",0);
                    model.put("f_isinfo",datas.getString("f_isinfo"));
                    entity.partialSave("t_stock",model);
                }
            }



    }
    public void newstockadd(SqlServer sql, EntityServer entity,JSONObject datas,JSONObject data)  throws Exception {
        JSONArray array =sql.query("select id from t_material_class");

        int a= 0;


        for (int j=0;j<array.length();j++){
            if (datas.getInt("f_material_class_id")==array.getJSONObject(j).getInt("id")){
                a=1;
            }
        }
        if (a==0){
            throw new Exception();
        }
        if (datas.getInt("f_number") < 0){
            throw new Exception();
        }
        if (datas.getString("f_isinfo")==null){
            throw new Exception();
        }

        JsonTools json = new JsonTools();
        String nowDate = DateTools.getNow2();
        data.put("f_operate_date", nowDate);
        if (datas.getString("f_isinfo").equals("否")){

            int mcid=datas.getInt("f_material_class_id");
            int f_warehouse_id=datas.getInt("f_warehouse_id");
            JSONArray array2 =sql.query("select * from t_stock where f_warehouse_id = "+f_warehouse_id+" and f_material_class_id = "+mcid);
            if (array2.length()>0){
                int n = sql.runSQL("update t_stock set f_number=ISNULL(f_number, 0)+"+datas.getInt("f_number")+" where id = "+array2.getJSONObject(0).getInt("id"));
                data.put("f_stock_id", array2.getJSONObject(0).getInt("id"));
                data.put("f_number", datas.getInt("f_number"));
                data.remove("id");
                data.remove("f_meterinfo_id");
                entity.partialSave("t_meter_record", data);

            }else{
                JSONObject model = new JSONObject();

                model.put("f_material_class_id",datas.getInt("f_material_class_id"));
                model.put("f_number",datas.getInt("f_number"));
                model.put("f_isinfo",datas.getString("f_isinfo"));
                model.put("f_warehouse_id",f_warehouse_id);
                JSONObject sotck=json.convertToJson(entity.partialSave("t_stock",model));
                data.put("f_stock_id", sotck.getInt("id"));
                data.put("f_number", model.getInt("f_number"));
                data.remove("id");
                data.remove("f_meterinfo_id");
                entity.partialSave("t_meter_record", data);
            }
        }else if(datas.getString("f_isinfo").equals("是")){
            int mcid=datas.getInt("f_material_class_id");
            int f_warehouse_id=datas.getInt("f_warehouse_id");
            JSONArray array2 =sql.query("select * from t_stock where f_warehouse_id = "+f_warehouse_id+" and f_material_class_id = "+mcid);
            if (array2.length()==0){
                JSONObject model = new JSONObject();
                model.put("f_material_class_id",datas.getInt("f_material_class_id"));
                model.put("f_number",0);
                model.put("f_isinfo",datas.getString("f_isinfo"));
                model.put("f_warehouse_id",f_warehouse_id);
                entity.partialSave("t_stock",model);
                JSONObject sotck=json.convertToJson(entity.partialSave("t_stock",model));
                data.put("f_stock_id", sotck.getInt("id"));
                data.put("f_number", model.getInt("f_number"));
                data.remove("id");
                data.remove("f_meterinfo_id");
                entity.partialSave("t_meter_record", data);
            }
        }



    }
    //表具退回
    public void meterReturn(SqlServer sql, EntityServer entity,JSONObject data)throws Exception{
        JSONObject model = data.getJSONObject("model");
        JSONArray rowsdata = data.getJSONArray("rowsdata");
        // 仓库id
        int f_warehouse_id = model.getInt("f_warehouse_id");
        // 本次入库的所有表具id
        ArrayList meterinfoids = new ArrayList();
        // 加入当前时间
        String nowDate = DateTools.getNow2();
        model.put("f_operate_date",nowDate);
        log.debug("model:"+model.toString());
        // 开始保存t_meter_record
        for (Object row : rowsdata) {
            JSONObject json = (JSONObject) row;
            // 表具id
            int f_meterinfo_id = json.getInt("id");
            meterinfoids.add(f_meterinfo_id);
            model.put("f_meterinfo_id",f_meterinfo_id);
            // 莫名有个id
            model.remove("id");
            // 保存record记录
            entity.partialSave("t_meter_record",model);
        }
        log.debug("保存t_meter_record完成,共"+rowsdata.length());
        // 生成更新条件
        String ids = meterinfoids.toString().replace("[","(").replace("]",")");
        log.debug("更新meterinfo条件:"+ids);

        int n = sql.runSQL("update t_meterinfo set f_distribution_state = '已入库' where id in "+ids);
        log.debug("更新meterinfo成功:"+n);

        int number=rowsdata.length();
        int m=sql.runSQL("update t_warehouse set f_receive_number = f_receive_number-"+number+", f_notreceive_number = f_notreceive_number+"+number+" where id = "+f_warehouse_id);
    }
}
