SELECT
    f_user_type,
    f_gasproperties,
    f_price_name
FROM(
    SELECT
        s.f_user_type,
        s.f_gasproperties,
        isnull(f_price_name,'_'+s.f_bill_style) f_price_name,
        isnull(s.f_bill_style,'_') f_bill_style,
        isnull(SUM ( f_gas ),0) f_gas,
        isnull(SUM ( f_money ),0) f_money
    FROM
        ( SELECT
            id,
            f_user_type,
            f_gasproperties,
            f_bill_style
        FROM t_sellinggas
        WHERE f_state = '有效'
            AND f_meter_type LIKE '%卡表%'
            AND f_operate_date >= '{startDate}'
            AND f_operate_date <= '{endDate}'
        ) s
        LEFT JOIN (
        SELECT TOP
            1000 f_price_name + '(' + CONVERT ( VARCHAR, f_price ) + ')' f_price_name,
            f_change_id,
            f_gas,
            f_money
        FROM
            t_chargeprice
        WHERE
            f_state = '有效'
        ) c ON c.f_change_id= s.id
    GROUP BY
        s.f_user_type,
        s.f_gasproperties,
        f_price_name,
        s.f_bill_style
) t
GROUP BY f_user_type,f_gasproperties,f_price_name