SELECT
	f_user_type,
    f_gasproperties,
    f_price_name,
    f_bill_style,
    SUM ( f_gas ) f_gas,
    SUM ( f_money ) f_money,
    SUM ( f_gasall ) f_gasall,
    SUM ( f_moneyall ) f_moneyall
FROM(
    SELECT
        s.f_user_type,
        s.f_gasproperties,
        isnull(f_price_name,'_'+s.f_bill_style) f_price_name,
        isnull(s.f_bill_style,'_') f_bill_style,
        isnull(SUM ( f_gas ),0) f_gas,
        isnull(SUM ( f_money ),0) f_money,
        0 f_gasall,
        0 f_moneyall
    FROM
        ( SELECT
            id,
            f_user_type,
            f_gasproperties,
            f_bill_style
        FROM t_sellinggas
        WHERE f_state = '有效'
            AND f_meter_type LIKE '%卡表%'
            AND f_operate_date >= '{startDate}'
            AND f_operate_date <= '{endDate}'
            AND {f_orgid}
        ) s
        LEFT JOIN (
        SELECT TOP
            1000 f_price_name + '(' + CONVERT ( VARCHAR, f_price ) + ')' f_price_name,
            f_change_id,
            f_gas,
            f_money
        FROM
            t_chargeprice
        WHERE
            f_state = '有效'
        ) c ON c.f_change_id= s.id
    GROUP BY
        s.f_user_type,
        s.f_gasproperties,
        f_price_name,
        s.f_bill_style
    UNION ALL
    SELECT
        s.f_user_type,
        s.f_gasproperties,
        isnull(f_price_name,'_'+s.f_bill_style) f_price_name,
        isnull(s.f_bill_style,'_') f_bill_style,
        0 f_gas,
        0 f_money,
        isnull(SUM ( f_gas ),0 ) f_gasall,
        isnull(SUM ( f_money ),0 ) f_moneyall
    FROM
        ( SELECT
            id,
            f_user_type,
            f_gasproperties,
            f_bill_style
        FROM t_sellinggas
        WHERE f_state = '有效'
            AND f_meter_type LIKE '%卡表%'
            AND DATEPART(YY, f_operate_date) = DATEPART(YY, '{endDate}')
            AND {f_orgid}
        ) s
        LEFT JOIN (
        SELECT TOP
            1000 f_price_name + '(' + CONVERT ( VARCHAR, f_price ) + ')' f_price_name,
            f_change_id,
            f_gas,
            f_money
        FROM
            t_chargeprice
        WHERE
            f_state = '有效'
        ) c ON c.f_change_id= s.id
    GROUP BY
        s.f_user_type,
        s.f_gasproperties,
        f_price_name,
        s.f_bill_style
) tt
GROUP BY
	f_user_type,
	f_gasproperties,
	f_price_name,
	f_bill_style