SELECT
	isnull( SUM ( cn ), 0 ) cn,
	isnull( SUM ( sy ), 0 ) sy,
	isnull( SUM ( gf ), 0 ) gf,
	isnull( SUM ( xy ), 0 ) xy,
	isnull( SUM ( price1 ), 0 ) price1,
	isnull( SUM ( price2 ), 0 ) price2,
	isnull( SUM ( price3 ), 0 ) price3,
	isnull( SUM ( qc ), 0 ) qc,
	ISNULL( SUM ( web ), 0 ) web,
	isnull( SUM ( sybq ), 0 ) sybq,
	isnull( SUM ( mybq ), 0 ) mybq,
	isnull( SUM ( gfbq ), 0 ) gfbq,
	isnull( SUM ( cnbq ), 0 ) cnbq,
	isnull( SUM ( hbbq ), 0 ) hbbq 
FROM
	(-- //正常
	SELECT
		CASE WHEN ts.f_gasproperties = '采暖锅炉' THEN 1 ELSE 0 END cn,
		CASE WHEN ts.f_gasproperties LIKE '%商%' THEN 1 ELSE 0 END sy,
		CASE WHEN ts.f_gasproperties LIKE '公福%' THEN 1 ELSE 0 END gf,
		CASE WHEN ts.f_gasproperties LIKE '协议%' THEN 1 ELSE 0 END xy,
		CASE WHEN ts.f_gasproperties= '居民用气' AND ch.f_stair1amount<> 0 THEN 1 ELSE 0 END price1,
		CASE WHEN ts.f_gasproperties= '居民用气' AND ch.f_stair2amount<> 0 AND ch.f_stair1amount= 0 THEN 1 ELSE 0 END price2,
		CASE WHEN ts.f_gasproperties= '居民用气'
				AND ch.f_stair3amount<> 0 
				AND ch.f_stair1amount= 0 
				AND ch.f_stair2amount= 0 THEN 1 ELSE 0 
				END price3,
		0 qc,
		0 web,
		0 sybq,
		0 mybq,
		0 gfbq,
		0 hbbq,
		0 cnbq 
FROM
	t_sellinggas ts
	LEFT JOIN t_userfiles u ON ts.f_user_id= u.f_user_id
	LEFT JOIN t_stairprice s ON ts.f_stairprice_id = s.id
	LEFT JOIN (
	SELECT
		f_charge_id,
        SUM ( CASE WHEN f_price_name = '阶梯1' THEN f_gas ELSE 0 END ) f_stair1amount,
        SUM ( CASE WHEN f_price_name = '阶梯2' THEN f_gas ELSE 0 END ) f_stair2amount,
        SUM ( CASE WHEN f_price_name = '阶梯3' THEN f_gas ELSE 0 END ) f_stair3amount
    FROM
        t_chargeprice
    WHERE
        f_state = '有效'
    GROUP BY
        f_charge_id
        ) ch ON ts.id = ch.f_charge_id
WHERE
	ts.f_state = '有效'
	AND u.f_gaswatchbrand!= '秦川远传' 
	AND ts.f_type <> '超用收费'
	AND ts.f_operate_date>='{startDate}'
    AND ts.f_operate_date<='{endDate}'
	AND { f_orgid}
	UNION ALL-- //秦川远传
SELECT
	0 cn,
	0 sy,
	0 gf,
	0 xy,
	0 price1,
	0 price2,
	0 price3,
	1 qc,
	0 web,
	0 sybq,
	0 mybq,
	0 gfbq,
	0 hbbq,
	0 cnbq 
FROM
	t_sellinggas ts,
	t_userfiles u 
WHERE
	u.f_gaswatchbrand= '秦川远传' 
	AND ts.f_userid= u.f_userid 
	AND ts.f_type <> '超用收费'
	AND ts.f_state = '有效'
	AND ts.f_operate_date>='{startDate}'
    AND ts.f_operate_date<='{endDate}'
	AND { f_orgid}
	UNION ALL-- //物联网表
SELECT
	0 cn,
	0 sy,
	0 gf,
	0 xy,
	0 price1,
	0 price2,
	0 price3,
	0 qc,
	1 web,
	0 sybq,
	0 mybq,
	0 gfbq,
	0 hbbq,
	0 cnbq 
FROM
	t_sellinggas ts,
	t_userfiles u 
WHERE
	ts.f_gaswatchbrand LIKE '%物联网表%' 
	AND ts.f_userid= u.f_userid 
	AND ts.f_type <> '超用收费'
	AND f_payfeevalid = '有效' 
	AND ts.f_operate_date>='{startDate}'
    AND ts.f_operate_date<='{endDate}'
	AND { f_orgid}
	UNION ALL-- //超用
SELECT
	0 cn,
	0 sy,
	0 gf,
	0 xy,
	0 price1,
	0 price2,
	0 price3,
	0 qc,
	0 web,
CASE WHEN ts.f_gasproperties LIKE '%商%' THEN 1 ELSE 0 END sybq,
CASE WHEN ts.f_gasproperties = '民用气价' THEN 1 ELSE 0 END mybq,
CASE WHEN ts.f_gasproperties LIKE '公福%' THEN 1 ELSE 0 END gfbq,
CASE WHEN ts.f_gasproperties = '采暖锅炉%' THEN 1 ELSE 0 END cnbq,
CASE WHEN ts.f_gasproperties = '合表%' THEN 1 ELSE 0 END hbbq 
FROM
	t_sellinggas ts,
	t_userfiles u 
WHERE
	ts.f_state = '有效'
	AND u.f_gaswatchbrand!= '秦川远传' 
	AND ts.f_userid= u.f_userid 
	AND ts.f_type = '超用收费'
	AND ts.f_operate_date>='{startDate}'
    AND ts.f_operate_date<='{endDate}'
	AND { f_orgid } 
	) a