	select
	 f_whether_pay,
	 f_price_name,
	 count(distinct f_userinfo_id) user_number,
	 sum(f_gas) f_gas,
	 sum(f_money) f_money
	from (
		select
			case when sh.f_hand_id is null and h.f_oughtfee>0 then '否' else '是' end f_whether_pay,
			case when s.f_price_name='固定气价' then s.f_price_name
				 when ch.f_price_name='阶梯1' then s.f_price_name+'1档'
				 when ch.f_price_name='阶梯2' then s.f_price_name+'2档'
				 when ch.f_price_name='阶梯3' then s.f_price_name+'3档'
				 else  s.f_price_name+'1档' end f_price_name,
		   h.f_userinfo_id,
		   isnull(ch.f_gas,0) f_gas,
		   isnull(ch.f_money,0) f_money
		from t_handplan h
		left join t_stairprice s on h.f_stairprice_id = s.id
		left join (
			select
				f_hand_id,
				sum(f_debt_money) f_debt_money,
				sum(f_overdue) f_overdue,
				sum(f_charge_money) f_charge_money
			from t_sellinghand where f_state='有效'
			group by f_hand_id
		) sh on h.id = sh.f_hand_id
		left join (select * from t_chargeprice where f_money>0 and f_state='有效') ch on h.id = ch.f_hand_id
		left join t_sellinggas se on h.f_sell_id = se.id
		where h.f_hand_date>='{startDate}' and h.f_hand_date<='{endDate}' and f_meter_state='已抄表' and f_hand_state='有效'
	) h
	group by f_whether_pay,f_price_name