SELECT
	*
FROM
	(
	SELECT
		u.f_userinfo_id,
		u.version,
		u.f_userinfo_code,
		u.f_user_state,
		u.f_balance,
		u.f_cost_type,
		u.f_user_name,
		u.f_credentials,
		u.f_idnumber,
		u.f_user_phone,
		u.f_rent_phone,
		u.f_people_num,
		u.f_createfile_person,
		u.f_createfile_date,
		u.f_contract_id,
		u.f_paper_type,
		u.f_comments,
		u.f_orgid,
		u.f_orgname,
		u.f_depname,
		u.f_operator,
		u.f_depid,
		u.f_operatorid,
		tus.f_user_type,  ---用户类型
		tus.f_gasproperties,  ---用气性质
		address.f_slice_area AS f_zones,
		address.f_address,
		address.f_residential_area f_residential_area,
		address.f_building + address.f_building_suffix AS f_building,
		address.f_unit + address.f_unit_suffix AS f_unit,
		address.f_floor + address.f_floor_suffix AS f_floor,
		address.f_room + address.f_room_suffix AS f_room,
	CASE
			
			WHEN b.f_userinfo_id IS NULL THEN
			'未绑定' ELSE '已绑定'
		END AS f_wechat 
	FROM
		t_userinfo u
		LEFT JOIN t_user_address address ON u.f_userinfo_id = address.f_userinfo_id
		left join t_userfiles tus on tus.f_userinfo_id=u.f_userinfo_id and f_table_state='正常'
		LEFT JOIN ( SELECT f_userinfo_id FROM t_banduser WHERE f_band_state = '有效' GROUP BY f_userinfo_id ) b ON u.f_userinfo_id = b.f_userinfo_id
	) t 
WHERE
    {condition}
ORDER BY
	f_userinfo_code DESC