SELECT
    f_operator,
    SUM ( f_yucun ) f_yucun,
    SUM ( f_oughtfee ) f_oughtfee,
    SUM ( f_cal_collection ) f_cal_collection,
    SUM ( f_collection ) f_collection,
    SUM ( f_other_fee ) f_other_fee,
    COUNT ( * ) f_number,
    sum(f_tuifei_fee) tuifei_fee,
    sum(f_tuifei_num) tuifei_num,
    sum(f_yucun) yucun_fee,
    sum(f_yucun_num) yucun_num,
    sum(f_oughtfee) qifei_fee,
    sum(f_oughtfee_num) qifei_num,
    sum(f_collection) f_heji
FROM
    (
        SELECT
            tss.f_operator,
            tss.f_operate_date,
            tss.f_user_type,
            tss.f_gasproperties,
            gb.f_meter_brand,
            tss.f_meter_type,
            tss.f_payment,
            CASE WHEN tss.f_state= '有效' and f_charge_type='退费' and isnull( f_collection, 0 )<0 then 1 ELSE 0 END f_tuifei_num,
            CASE WHEN tss.f_state= '有效' and f_charge_type='退费' and isnull( f_collection, 0 )<0 then isnull( f_collection, 0 ) ELSE 0 END f_tuifei_fee,
            CASE WHEN tss.f_state!= '无效' and isnull( tsh.sum_f_charge_money, 0 )>0 then 1 ELSE 0 END f_yucun_num,
            CASE WHEN tss.f_state!= '无效' and isnull( tsh.sum_f_charge_money, 0 )<=0 then 1 ELSE 0 END f_oughtfee_num,
            CASE WHEN tss.f_state!= '无效' THEN isnull( tsh.sum_f_charge_money, 0 ) ELSE 0 END f_yucun,
            CASE WHEN tss.f_state!= '无效' THEN isnull( tss.f_preamount, 0 ) ELSE 0 END f_oughtfee,
            CASE WHEN tss.f_state= '冲正' THEN f_collection ELSE 0 END f_cal_collection,
            f_collection,
            0 f_other_fee,
            tss.f_orgid,
            tss.f_depid,
            tss.f_state,
            tss.f_operatorid,
            tss.f_preamount
        FROM
            t_sellinggas tss
                LEFT JOIN ( SELECT f_userfiles_id, f_gasbrand_id FROM t_userfiles) uf ON tss.f_userfiles_id= uf.f_userfiles_id
                LEFT JOIN ( SELECT id, f_meter_brand FROM t_gasbrand ) gb ON uf.f_gasbrand_id= gb.id
                left join(
                SELECT
                    f_sell_id,
                    sum(case when f_type = '预存款' then f_charge_money else 0 end)  sum_f_charge_money,
                    sum(case when f_type <> '预存款' then f_charge_money else 0 end)   sum_not_charge_money,
                    sum(f_charge_money) f_charge_money,
                    sum(f_debt_money) f_debt_money
                FROM t_sellinghand
                group by f_sell_id
            ) tsh on tss.id=tsh.f_sell_id

        UNION ALL
        SELECT
            o.f_operator,
            o.f_operate_date,
            f_user_type,
            f_gasproperties,
            f_meter_brand,
            f_meter_type,
            o.f_payment,
            0 f_tuifei_num,
            0 f_tuifei_fee,
            0 f_yucun_num,
            0 f_oughtfee_num,
            0 f_yucun,
            0 f_oughtfee,
            0 f_cal_collection,
            0 f_collection,
            f_collection f_other_fee,
            o.f_orgid,
            o.f_depid,
            o.f_state,
            o.f_operatorid,
            0 f_preamount
        FROM
            t_othercharge o
                LEFT JOIN ( SELECT f_userinfo_id, f_gasbrand_id, f_user_type, f_gasproperties FROM t_userfiles ) uf ON o.f_userinfo_id= uf.f_userinfo_id
                LEFT JOIN ( SELECT id, f_meter_brand, f_meter_type FROM t_gasbrand ) gb ON uf.f_gasbrand_id= gb.id
        WHERE
                o.f_state= '有效'
    ) s
WHERE
        f_state!='无效'  and { condition }
GROUP BY
    f_operator
