select * from (
  select
    ii.f_invoice_num,   -- 发票号码
    ii.f_invoice_type,  -- 发票类型
    ii.f_operator f_invoiceuse_operator, -- 开票人
    ii.f_invoice_date,  -- 开票时间
    bd.f_bill_number, -- 收据号
    wx.f_bank_type,  -- 付款银行(支付渠道)
    hd.*,
    s.*,
    case when substring(convert(varchar(100),hand.maxdate, 23),0,8)=substring(convert(varchar(100),hand.mindate, 23),0,8) then substring(convert(varchar(100),hand.mindate, 23),0,8)
    else substring(convert(varchar(100),hand.mindate, 23),0,8)+'~'+substring(convert(varchar(100),hand.maxdate, 23),0,8) end f_rest_date,
    sh.*,
    isnull((select  count(*) filltimes from   t_billdetail
                    where f_bill_state='有效' and f_charge_id=s.id and f_bill_type  like '%补打%'
                    group by f_charge_id ),0) filltimes,
    info.f_userinfo_code,
    info.f_idnumber,
    info.f_user_phone,
    ua.f_residential_area,
    sp.f_price_type,
    sp.f_price_name
    from t_sellinggas s
      left join (
      select
        case when max(f_hand_date)<(datename(yy,max(f_hand_date)) + '-' + datename(mm,max(f_hand_date)) +'-25 00:00:00.000' )
               then  dateadd(month,-1,max(f_hand_date)) else max(f_hand_date) end
          maxdate,
        case when min(f_hand_date)<(datename(yy,min(f_hand_date)) + '-' + datename(mm,min(f_hand_date)) +'-25 00:00:00.000' )
               then  dateadd(month,-1,min(f_hand_date)) else min(f_hand_date) end
          mindate,f_sell_id from t_handplan  group by f_sell_id
        ) hand
      on s.id = hand.f_sell_id
      left join (

        select
            f_charge_id,
            CONVERT(decimal(18,2),sum(f_stairamount1)) f_stairamount1,
            CONVERT(decimal(18,2),sum(f_stair1price)) f_stair1price,
            CONVERT(decimal(18,2),sum(f_stair1fee)) f_stair1fee,
            CONVERT(decimal(18,2),sum(f_stair2amount)) f_stair2amount,
            CONVERT(decimal(18,2),sum(f_stair2price)) f_stair2price,
            CONVERT(decimal(18,2),sum(f_stair2fee)) f_stair2fee,
            CONVERT(decimal(18,2),sum(f_stair3amount)) f_stair3amount,
            CONVERT(decimal(18,2),sum(f_stair3price)) f_stair3price,
            CONVERT(decimal(18,2),sum(f_stair3fee)) f_stair3fee

        from (
                 select f_charge_id f_charge_id,
                        sum(case f_price_name when '阶梯1' then f_gas  when '固定气价' then f_gas else 0 end) f_stairamount1,
                        case f_price_name when '阶梯1' then f_price when '固定气价' then f_price else 0 end f_stair1price,
                        sum(case f_price_name when '阶梯1' then f_money when '固定气价' then f_money else 0 end) f_stair1fee,
                        sum(case f_price_name when '阶梯2' then f_gas else 0 end) f_stair2amount,
                        case f_price_name when '阶梯2' then f_price else 0 end f_stair2price,
                        sum(case f_price_name when '阶梯2' then f_money else 0 end) f_stair2fee,
                        sum(case f_price_name when '阶梯3' then f_gas else 0 end) f_stair3amount,
                        case f_price_name when '阶梯3' then f_price else 0 end f_stair3price,
                        sum(case f_price_name when '阶梯3' then f_money else 0 end) f_stair3fee
                 from t_chargeprice where 1=1 group by f_charge_id,f_price_name,f_price
             ) s group by f_charge_id
    ) hd on hd.f_charge_id=s.id
      left join (
      select f_sell_id,
             CONVERT(decimal(18,2),sum(f_yucun)) f_yucun,
             CONVERT(decimal(18,2),sum(f_charge_money)) f_charge_money
             from(
               select
                 f_sell_id,
                 case when f_type='预存款' then
                        case when f_last_balance<0 then
                               case when f_balance>0 then f_balance else 0 end
                             else f_balance-f_last_balance end
                      else
                        0 end f_yucun,
                 case when f_type!='预存款' then f_charge_money else 0 end f_charge_money
                 from t_sellinghand where f_state='有效'
             ) s group by f_sell_id
    ) sh on s.id = sh.f_sell_id
      left join t_userinfo info
      on s.f_userinfo_id = info.f_userinfo_id
      left join t_user_address ua on info.f_userinfo_id= ua.f_userinfo_id
      left join t_stairprice sp
      on cast(s.f_stairprice_id as varchar) = cast(sp.id as varchar)

      left join t_weixinreturnxml wx on s.f_serial_id = wx.f_transaction_id
      left join
      (select f_charge_id,max(f_bill_number) f_bill_number from t_billdetail where f_bill_state='有效'
group by f_charge_id ) bd on s.id = bd.f_charge_id
      left join t_invoiceuse ii on s.f_invoiceuse_id = ii.id
) t
       where {condition} and f_state!='无效'
       order by {orderitem}
