SELECT
	*
FROM (
	SELECT
		f_userinfo_code,
		u.f_user_name,
		u.f_userinfo_id,
		ua.f_address,
		ua.f_residential_area,
		u.f_user_phone,
		u.f_depid,
		u.f_operatorid,
		u.f_operator,
		u.f_idnumber,
		sp.f_price_name,
		f.f_meternumber,
		f.f_gas_person,
		f.f_gas_date,
		u.f_open_date,
		f.f_gasproperties,
		f.f_total_gas,
    gb.f_meter_brand,
		CASE WHEN d.num> 0 THEN '是' ELSE '否' END isbgl,
		f.f_filialeid,
		f.f_whether_hairpin,
		f.f_table_state,
		u.f_user_state,
		isnull(sell.sellnum,0) sellnum
	FROM
		t_userfiles f
		LEFT JOIN t_userinfo u ON f.f_userinfo_id = u.f_userinfo_id
		LEFT JOIN t_user_address ua ON ua.id = f.f_useraddress_id
		LEFT JOIN t_gasbrand gb ON f.f_gasbrand_id= gb.id
		left join (
		    select * from t_stairprice where f_state='有效' and getdate()>=f_perform_date and getdate()<=f_end_date
		    )	sp on f.f_price_id=sp.f_price_id
		LEFT JOIN ( SELECT f_userfiles_id, COUNT ( * ) num FROM t_devices WHERE f_state = '有效' AND f_devices_type = '壁挂炉' GROUP BY f_userfiles_id ) d ON f.f_userfiles_id= d.f_userfiles_id
  	left join ( select f_userinfo_id,count(*) sellnum from t_sellinggas where f_state='有效'  GROUP BY f_userinfo_id) sell ON u.f_userinfo_id= sell.f_userinfo_id
) t_
WHERE
	t_.f_user_state='正常' and f_open_date is not null and sellnum>0 and f_table_state = '正常' and {condition}
ORDER BY f_open_date
