SELECT
	ts.f_month,  -- 月份
	SUM(ts.f_last_balance) f_last_balance,  -- 期初余额
	SUM(ts.f_account) f_account, -- 本期发生额
	SUM(ts.f_wechat_pay) f_wechat_pay,  -- 微信
	SUM(ts.f_money_pay) f_money_pay, -- 现金
	SUM(ts.f_bank_pay) f_bank_pay, -- 银行转账
	SUM(ts.f_pre_pay) f_pre_pay, -- 预付账款抵减
	SUM(ts.f_wechat_pay+ts.f_money_pay+ts.f_bank_pay+ts.f_pre_pay) f_sum_pay, -- 收款金额合计
	SUM(ts.f_balance) f_balance  -- 期末余额
FROM(
SELECT
	DatePart( Mm, d.f_operate_date ) f_month,
	(SELECT f_last_balance FROM t_sellinghand where id=min(d.id) AND f_userinfo_id=d.f_userinfo_id) f_last_balance,
	SUM(s.f_preamount) f_account,
	ISNULL( SUM ( CASE WHEN d.f_type!='余额抵扣' AND s.f_payment='现金缴费' THEN d.f_charge_money END ), 0 ) f_money_pay,
	ISNULL( SUM ( CASE WHEN d.f_type!='余额抵扣' AND s.f_payment='微信支付' THEN d.f_charge_money END ), 0 ) f_wechat_pay,
	ISNULL( SUM ( CASE WHEN d.f_type!='余额抵扣' AND s.f_payment='银行转账' THEN d.f_charge_money END ), 0 ) f_bank_pay,
	ISNULL( SUM ( CASE WHEN d.f_type='余额抵扣' THEN d.f_charge_money END ), 0 ) f_pre_pay,
	(SELECT f_balance FROM t_sellinghand where id=max(d.id) AND f_userinfo_id=d.f_userinfo_id) f_balance
FROM
t_sellinggas s
right JOIN
t_sellinghand d
ON
s.id=d.f_sell_id
WHERE
	s.f_state = '有效'
	AND d.f_state='有效'
	AND s.f_meter_type='机表'
	AND d.f_operate_date>='{ startDate }'
	AND d.f_operate_date<='{ endDate }'
	AND  exists(select f_userinfo_id from t_userinfo tf where {condition} and s.f_userinfo_id=tf.f_userinfo_id )
GROUP BY
	DatePart( Mm, d.f_operate_date ),d.f_userinfo_id
) ts
GROUP BY
	ts.f_month
ORDER BY
  ts.f_month