select f_meter_type
from (
SELECT
	CASE
		WHEN s.f_meter_type LIKE '%卡表%' THEN '卡表'
		WHEN s.f_meter_type IS NULL THEN ''
		ELSE s.f_meter_type
	END f_meter_type,
	ISNULL( ( p.f_price_name + '(' + p.f_number+ ')' ), '' ) f_price_name,
	ISNULL( f_price, 0 ) f_price,
	ISNULL( SUM ( c.f_gas ), 0 ) f_gas,
	ISNULL( SUM ( f_money ), 0 ) f_money
FROM
	t_sellinggas s
	JOIN t_chargeprice c ON s.id= f_charge_id
	JOIN ( SELECT f_price_id, f_price_name FROM t_stairprice WHERE f_state = '有效' ) sp ON s.f_price_id= sp.f_price_id
	JOIN (
		SELECT
			ISNULL( f_meter_type, '' ) f_meter_type,
			ISNULL( sp.f_price_name, '' ) f_price_name,
			CAST ( COUNT ( DISTINCT s.f_userinfo_id ) AS VARCHAR ) f_number
		FROM
			t_sellinggas s
			LEFT JOIN t_chargeprice c ON s.id= f_charge_id
			LEFT JOIN ( SELECT f_price_id, f_price_name FROM t_stairprice WHERE f_state = '有效' ) sp
			ON s.f_price_id= sp.f_price_id
		WHERE
			s.f_state!= '无效'
            AND s.f_operate_date >= '{startDate}'
            AND s.f_operate_date <= '{endDate}'
            AND s.{f_orgid} --   AND f_price is NOT NULL

		GROUP BY
			f_meter_type,
			sp.f_price_name
	) p ON s.f_meter_type= p.f_meter_type
	AND sp.f_price_name= p.f_price_name
WHERE
	s.f_state!= '无效'
	AND s.f_operate_date >= '{startDate}'
	AND s.f_operate_date <= '{endDate}'
	AND s.{f_orgid} --   AND f_price is NOT NULL

GROUP BY
	s.f_meter_type,
	p.f_number,
	p.f_price_name,
	f_price
) ts
group by f_meter_type
