select
    f_meter_type
from(
select
 ts.f_meter_type,
 ts.f_gasproperties,
 SUM ( case when ts.f_payment like '%现金%' then ts.f_collention else 0 end) f_xianjin,
 SUM ( case when ts.f_payment = '转账' then ts.f_collention else 0 end) f_zhuanzhang,
 SUM ( case when ts.f_payment = '刷卡' then ts.f_collention else 0 end) f_shuka,
 SUM ( case when ts.f_payment = '微信支付' then ts.f_collention else 0 end) f_weixin,
 SUM ( case when ts.f_payment like '_扫码盒%' then ts.f_collention else 0 end) f_saomahe,
 SUM ( case when ts.f_payment = '无线扫码盒%' then ts.f_collention else 0 end) f_wxsaomahe,
 SUM ( case when ts.f_payment = '调价退费' then ts.f_collention else 0 end) f_tiaojiatf,
 SUM ( case when ts.f_payment = '电子气费' then ts.f_collention else 0 end) f_dzqifei,
 SUM ( case when ts.f_payment = '银行代收' then ts.f_collention else 0 end) f_yhdaishou,
 SUM ( case when ts.f_payment = '免交' then ts.f_collention else 0 end) f_mianjiao
from
(
SELECT
	f_meter_type,
	f_gasproperties,
	f_payment,
	SUM ( f_collection ) f_collention
FROM
	(
	SELECT
		CASE
			WHEN f_meter_type LIKE '%卡表%' THEN '卡表'
			WHEN f_meter_type LIKE '%机表%' THEN '机表'
			ELSE f_meter_type END f_meter_type,
		f_gasproperties,
		f_payment,
		f_collection
	FROM
		t_sellinggas
	WHERE
		f_state = '有效'
		AND f_gasproperties != '居民用气'
		AND f_meter_type != '机表'
		and f_operate_date>='{ startDate }'
		and f_operate_date<='{ endDate }'
	) s
GROUP BY
	f_meter_type,
	f_gasproperties,
	f_payment
UNION ALL
SELECT
	CASE
			WHEN f_meter_type LIKE '%卡表%' THEN '卡表'
			WHEN f_meter_type LIKE '%机表%' THEN '机表'
			ELSE f_meter_type END f_meter_type,
	CASE
		WHEN ss.f_gasproperties= '民用' THEN ss.f_gasproperties + sd.type
		WHEN ss.f_gasproperties!= '民用' THEN ss.f_gasproperties END f_gasproperties,
		ss.f_payment,
		SUM ( CASE
				WHEN ss.f_gasproperties= '民用' THEN sd.f_charge_money
				WHEN ss.f_gasproperties!= '民用' THEN sd.f_charge_money END ) f_collection
FROM
	t_sellinggas ss
LEFT JOIN (
	SELECT
		f_sell_id,
		SUM ( CASE WHEN f_type = '预存款' THEN f_charge_money ELSE f_charge_money END ) f_charge_money,
		CASE WHEN f_type = '预存款' THEN '预存' ELSE '气费' END type
	FROM
		t_sellinghand
	WHERE
		f_state = '有效'
	GROUP BY
		f_type,
		f_sell_id
	) sd ON sd.f_sell_id= ss.id
WHERE
	f_state = '有效'
	AND f_meter_type = '机表'
	and ss.f_operate_date>='{ startDate }'
	and ss.f_operate_date<='{ endDate }'
GROUP BY
	f_meter_type,
	f_gasproperties,
	f_payment,
	sd.type
) ts
group by
	ts.f_meter_type,
	ts.f_gasproperties
) tc
group by
    f_meter_type